/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Author: Damian Waradzyn
 */

#include "MapChooseMenuElement.h"
#include "../actions/ChangeTileProviderAction.h"
#include "../display/texture.h"
#include "../tile_engine/tile.h"
#include "../tile_engine/tileengine.h"

#define ICON_SIZE 72

GLfloat tilePreviewTexCoords[][8] = { { ICON_SIZE / 256.0f, 0.0f, /* Top Right Of The Texture */
		ICON_SIZE / 256.0f, ICON_SIZE / 256.0f, /* Bottom Right Of The Texture */
		0.0f, 0.0f, /* Bottom Left Of The Texture */
		0.0f, ICON_SIZE / 256.0f, /* Top Left Of The Texture */
} };

MapChooseMenuElement::MapChooseMenuElement(TileProvider* tileProvider) {
	this -> tileProvider = tileProvider;
	this -> name = tileProvider -> name;
	icon = "null";
	surface = NULL;
	texture = 0;
	action = new ChangeTileProviderAction(tileProvider);
	tile = NULL;
}

MapChooseMenuElement::~MapChooseMenuElement() {
}

GLfloat** MapChooseMenuElement::getIconTexCoords() {
	return (GLfloat**) tilePreviewTexCoords;
}

int MapChooseMenuElement::getIconSize() {
	return ICON_SIZE;
}
void MapChooseMenuElement::createTexture() {
	if (tile == NULL) {
		tile = (t_tile*) calloc(1, sizeof(t_tile));
		if (tile == NULL) {
			fprintf(stderr, "memory allocation error in MapChooseMenuElement::MapChooseMenuElement\n");
			exit(1);
		}
		tile -> zoom = 2;
		tile -> tilex = 2;
		tile -> tiley = 1;
		tile -> zoomHelper = 1;
		tile -> provider = tileProvider;
		enqueue(downloadQueue, tile);
	}
	if (tile -> state == STATE_GL_TEXTURE_NOT_CREATED) {
		this -> texture = ::createTexture((GLushort*) tile -> pixels4444, TILE_SIZE, TILE_SIZE, FALSE);
		tile -> state == STATE_LOADED;
	}
}

void MapChooseMenuElement::deleteTexture() {
	if (tile -> state == STATE_LOADED) {
		tile -> state = STATE_GL_TEXTURE_NOT_CREATED;
		::deleteTexture(this -> texture);
		this -> texture = 0;
	}
}
