/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Author: Damian Waradzyn
 */


#ifndef INPUT_H_
#define INPUT_H_

#include <SDL/SDL.h>
#include <wchar.h>

#include "../main.h"
#include "../geocoding/geocoder.h"
#include "../tile_engine/tileengine.h"
#include "../display/buildings3d.h"
#include "../display/uielement.h"
#include "../display/glcanvas.h"

void initInput();
void processKeyDown(SDL_KeyboardEvent key);
void processKeyUp(SDL_KeyboardEvent key);
void processKeyboard();
void processAccelerometer();
void processMouse();

#endif /* INPUT_H_ */
