/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Author: Damian Waradzyn
 */

#ifndef PARALLELTRANSITION_H_
#define PARALLELTRANSITION_H_

#include "../Transition.h"
#include <QList>

class ParallelTransition: public Transition {
	bool isFinished;
	QList<Transition*> transitions;
public:
	ParallelTransition(QList<Transition*> transitions) : transitions(transitions), isFinished(false) {};
	virtual ~ParallelTransition();
	virtual void nextFrame();
	virtual void reset();
	virtual bool finished();
};

#endif /* PARALLELTRANSITION_H_ */
