/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Author: Damian Waradzyn
 */

#include "ParallelTransition.h"

void ParallelTransition::reset() {
	QListIterator<Transition*> i(transitions);
	while (i.hasNext()) {
		Transition* transition = i.next();
		transition -> reset();
	}
	isFinished = false;
}

void ParallelTransition::nextFrame() {
	QListIterator<Transition*> i(transitions);
	isFinished = true;

	while (i.hasNext()) {
		Transition* transition = i.next();
		transition -> nextFrame();
		if (!transition -> finished()) {
			isFinished = false;
		}
	}
}

bool ParallelTransition::finished() {
	return isFinished;
}

ParallelTransition::~ParallelTransition() {
	// TODO Auto-generated destructor stub
}
