/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Author: Damian Waradzyn
 */

#ifndef LINEARTRANSITION_H_
#define LINEARTRANSITION_H_

#include "../../main.h"
#include "../Transition.h"
#include <QtCore/QDebug>

class LinearTransition : public Transition {
	GLfloat lower;
	GLfloat upper;
	int numFrames;
	int currentFrame;
	GLfloat* target;

public:
	LinearTransition(GLfloat* target, GLfloat lower, GLfloat upper, int numFrames) :
		lower(lower), upper(upper), numFrames(numFrames), currentFrame(0), target(target) {};
	virtual void nextFrame();
	virtual void reset();
	virtual bool finished();
};

#endif /* LINEARTRANSITION_H_ */
