/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Author: Damian Waradzyn
 */

#include <QtCore/QDebug>
#include "LinearTransition.h"

void LinearTransition::nextFrame() {
	if (currentFrame <= numFrames) {
		GLfloat normalizedValue = 1.0 - (GLfloat) currentFrame / (GLfloat) numFrames;
		GLfloat targetValue = upper + normalizedValue * (lower - upper);
		*target = targetValue;
		currentFrame++;
	}
}
void LinearTransition::reset() {
	currentFrame = 0;
}

bool LinearTransition::finished() {
	return currentFrame >= numFrames;
}
