/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Author: Damian Waradzyn
 */

#ifndef ANIMATEDELEMENT_H_
#define ANIMATEDELEMENT_H_

#include "TransitionState.h"

class AnimatedElement {
private:
	bool paused;
	bool transitionInCompleted;
	TransitionState *current;
	TransitionState *target;
public:
	AnimatedElement();
	virtual ~AnimatedElement();
	void setTargetState(TransitionState *target);
	void setTransitionInCompleted(bool completed);
	void setPaused(bool paused);
	bool isPaused();
	void reset();
	friend class AnimationManager;
};

#endif /* ANIMATEDELEMENT_H_ */
