/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Author: Damian Waradzyn
 */

#ifndef ABOUTDIALOG_H_
#define ABOUTDIALOG_H_

#include <QtCore/QString>
#include <SDL/SDL.h>
#include "../gl.h"
#include "../animation/AnimatedElement.h"

class AboutDialog {
	AnimatedElement* rotationAnimation;
	TransitionState* rotationStateLandscape;
	bool active;
	void renderText(QString text, GLfloat tx, GLfloat ty, int fontSize);
	SDL_Surface* donateSurface;
	GLuint donateTexture;
	SDL_Surface* logoSurface;
	GLuint logoTexture;
	GLfloat rotation;
public:
	AboutDialog();
	void show();
	void render();
	bool isActive();
	void handleMouse();
	virtual ~AboutDialog();
};

#endif /* ABOUTDIALOG_H_ */
