/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Author: Damian Waradzyn
 */

#include "AboutDialog.h"
#include "../main.h"
#include "../display/glcanvas.h"
#include "../resources/TextSurfaceManager.h"
#include <QtCore/QString>
#include <QtCore/QUrl>
#include <QtGui/QDesktopServices>
#include "../animation/transitions/CubicTransition.h"

AboutDialog::AboutDialog() {
	active = false;
	donateSurface = loadTextureFromFile("/opt/cloudgps/res/menu/donate.png", NULL, NULL);
	donateTexture = 0;

	logoSurface = loadTextureFromFile("/opt/cloudgps/res/menu/about.png", NULL, NULL);
	logoTexture = 0;

	rotationAnimation = new AnimatedElement();
	rotationStateLandscape = new TransitionState();
	Transition* transitionIn = new CubicTransition(&rotation, 0.0, 90.0, 60);
	transitionIn -> setSkipAllowed(false);
	rotationStateLandscape -> setTransitionIn(transitionIn);
	Transition* transitionOut = new CubicTransition(&rotation, 90.0, 0.0, 60);
	transitionOut -> setSkipAllowed(false);
	rotationStateLandscape -> setTransitionOut(transitionOut);

}

void AboutDialog::show() {
	active = true;
	canvas.dimmed = true;
	rotation = options.orientation == PORTRAIT ? 0.0 : 90.0;
}

void AboutDialog::renderText(QString text, GLfloat translatex, GLfloat translatey, int fontSize) {
	TextSurfaceManager* txtMan = TextSurfaceManager::instance();
	TextEntry* entry = txtMan -> getTextEntry(fontSize, text);
	resetQuadStripVertices();
	GLfloat tx = -entry -> height / 2 + translatex;
	GLfloat ty = -entry -> width / 2 + translatey;
	setQuadStripSize(entry -> height, entry -> width, quadStripVertices);
	glTranslatef(tx, ty, 0);
	glTexCoordPointer(2, GL_FLOAT, 0, txtMan -> getTexCoords(entry));
	glBindTexture(GL_TEXTURE_2D, entry -> texture);
	glDrawArrays(GL_TRIANGLE_STRIP, 0, 4);
	glTranslatef(-tx, -ty, 0);
}

extern TransitionState* emptyState;
void AboutDialog::render() {
	if (!active) {
		if (donateTexture != 0) {
			deleteTexture(donateTexture);
			donateTexture = 0;
			deleteTexture(logoTexture);
			logoTexture = 0;
		}
		return;
	}
	if (options.orientation == LANDSCAPE) {
		rotationAnimation -> setTargetState(rotationStateLandscape);
		rotationAnimation -> setPaused(false);
	} else {
		rotationAnimation -> setTargetState(emptyState);
		rotationAnimation -> setPaused(false);
	}

	if (donateTexture == 0) {
		donateTexture = createTexture((GLushort*)donateSurface -> pixels, donateSurface -> w, donateSurface -> h, FALSE);
		logoTexture = createTexture((GLushort*)logoSurface -> pixels, logoSurface -> w, logoSurface -> h, FALSE);
	}
	QString about = "CloudGPS ver. " CLOUDGPS_VERSION;
	QString about2 = "by Damian Waradzyn";
	QString about3 = "damian.waradzyn@gmail.com";
	glRotatef(rotation, 0, 0, 1);
	glColor4f(1,1,1,1);
	renderText(about, -40, 0, 40);
	glColor4f(1,1,1,0.5);
	renderText(about2, 30, 0, 20);
	glColor4f(1,1,1,0.5);
	renderText(about3, 70, 0, 20);
	glTranslatef(150, -donateSurface-> w / 2 - 16, 0);
	setQuadStripSize(donateSurface->h, donateSurface-> w, quadStripVertices);
	glVertexPointer(3, GL_FLOAT, 0, quadStripVertices);
	glTexCoordPointer(2, GL_FLOAT, 0, texCoordsPortrait);
	glBindTexture(GL_TEXTURE_2D, donateTexture);
	glDrawArrays(GL_TRIANGLE_STRIP, 0, 4);
	glTranslatef(-150, donateSurface-> w /2 + 16, 0);

	glTranslatef(-150, -logoSurface-> w / 2, 0);
	setQuadStripSize(logoSurface->h, logoSurface-> w, quadStripVertices);
	glBindTexture(GL_TEXTURE_2D, logoTexture);
	glDrawArrays(GL_TRIANGLE_STRIP, 0, 4);
	glTranslatef(150, logoSurface-> w / 2, 0);
	glRotatef(-rotation, 0, 0, 1);
}

void AboutDialog::handleMouse() {
	if (mouse[0].button == 0 && mouse[0].oldButton != 0) {
		int x1, x2, y1, y2;
		if (options.orientation == PORTRAIT) {
			x1 = SCREEN_WIDTH / 2 + 150 - donateSurface -> h;
			y1 = SCREEN_HEIGHT / 2 - donateSurface -> w / 2 - 16;
			x2 = x1 + donateSurface -> h * 3;
			y2 = y1 + donateSurface -> w;
		} else {
			x1 = SCREEN_WIDTH / 2  - donateSurface -> w / 2 - 16;
			y1 = SCREEN_HEIGHT / 2 + 150 - donateSurface -> h;
			x2 = x1 + donateSurface -> w - 16;
			y2 = y1 + donateSurface -> h * 3;
		}

		if (mouse[0].x >= x1 && mouse[0].x <= x2 && mouse[0].y >= y1 && mouse[0].y <= y2) {
			QDesktopServices::openUrl(QUrl("https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=AP4ZZ7EHBZMLG"));
		} else {
			active = false;
			canvas.dimmed = false;
		}
	}
}

bool AboutDialog::isActive() {
	return active;
}

AboutDialog::~AboutDialog() {
	// TODO Auto-generated destructor stub
}
