/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Author: Damian Waradzyn
 */

#include "KeyboardLayout.h"
#include "../main.h"
#include <QtCore/QDebug>
#include <json/json.h>
#include <json/json_object_private.h>

#define KEYBOARD_LAYOUTS_JSON_FILE "/opt/cloudgps/vkb_layouts.json"

#define KEY_LAYOUTS "layouts"
#define KEY_NAME "name"
#define KEY_ABBREVIATION "abbreviation"
#define KEY_LOWERCASE_CHARS "lowercaseChars"
#define KEY_UPPERCASE_CHARS "uppercaseChars"
#define KEY_ALTERNATE_LOWERCASE_CHARS "alternateLowercaseChars"
#define KEY_ALTERNATE_UPPERCASE_CHARS "alternateUppercaseChars"

void readFourStrings(QList<QString>* strings, json_object* jobj) {
	for (int i = 0; i < 4; i++) {

		QString string = QString::fromUtf8(json_object_get_string(json_object_array_get_idx(jobj, i)));
		strings -> append(string);
	}
}

QList<KeyboardLayout*>* KeyboardLayout::loadFromConfig() {
	char *contents;
	size_t length;

	if (g_file_get_contents(KEYBOARD_LAYOUTS_JSON_FILE, &contents, &length, NULL)) {
		json_object* jobj = json_tokener_parse(contents);
		if (is_error(jobj)) {
			qDebug() << "Parse error: " << KEYBOARD_LAYOUTS_JSON_FILE;
			exit(1);
		}
		json_object* layouts = json_object_object_get(jobj, KEY_LAYOUTS);
		int layoutCount = json_object_array_length(layouts);

		QList<KeyboardLayout*>* result = new QList<KeyboardLayout*>();

		for (int i = 0; i < layoutCount; i++) {
			json_object* layout = json_object_array_get_idx(layouts, i);
			QString name = json_object_get_string(json_object_object_get(layout, KEY_NAME));
			QString abbreviation = json_object_get_string(json_object_object_get(layout, KEY_ABBREVIATION));
			QList<QString> *lowercaseChars = new QList<QString>();
			readFourStrings(lowercaseChars, json_object_object_get(layout, KEY_LOWERCASE_CHARS));
			QList<QString> *uppercaseChars = new QList<QString>();
			readFourStrings(uppercaseChars, json_object_object_get(layout, KEY_UPPERCASE_CHARS));
			QList<QString> *alternateLowercaseChars = new QList<QString>();
			readFourStrings(alternateLowercaseChars, json_object_object_get(layout, KEY_ALTERNATE_LOWERCASE_CHARS));
			QList<QString> *alternateUppercaseChars = new QList<QString>();
			readFourStrings(alternateUppercaseChars, json_object_object_get(layout, KEY_ALTERNATE_UPPERCASE_CHARS));
			KeyboardLayout* keyboardLayout = new KeyboardLayout(name, abbreviation, lowercaseChars, uppercaseChars,
					alternateLowercaseChars, alternateUppercaseChars);
			result -> append(keyboardLayout);
		}
		g_free(contents);
		return result;
	} else {
		qDebug() << "Unable to read VKB layouts from file: " << KEYBOARD_LAYOUTS_JSON_FILE;
		exit(1);
	}
	return NULL;
}

KeyboardLayout::~KeyboardLayout() {
	// TODO Auto-generated destructor stub
}
