/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Author: Damian Waradzyn
 */

#include "accelerometer.h"

AccelerometerSensor* accelerometerSensor;

void initAccelerometer() {
	accelerometerSensor = new AccelerometerSensor();
}

AccelerometerSensor::AccelerometerSensor() {
	sensor.addFilter(this);
	sensor.start();
	if (sensor.isActive()) {
		fprintf(stderr, "Accelerometer initialized\n");
	} else {
		fprintf(stderr, "Accelerometer not present\n");
	}
}

void ensureFloatRange(float min, float max, float* value) {
	if (*value < min) {
		*value = min;
	}
	if (*value > max) {
		*value = max;
	}
}

bool AccelerometerSensor::filter(QAccelerometerReading *reading) {
#ifdef N950
	accelerometer.x = -reading->y()*100.0 - accelerometer.calibrateX;
	accelerometer.y = -reading->x()*100.0 - accelerometer.calibrateY;
	accelerometer.z = (reading->z()-9.8)*100.0 - accelerometer.calibrateZ;
#endif

#ifdef N900
	accelerometer.x = reading->x()*100.0 - accelerometer.calibrateX;
	accelerometer.y = -reading->y()*100.0 - accelerometer.calibrateY;
	accelerometer.z = (reading->z()-9.8)*100.0 - accelerometer.calibrateZ;
#endif

	ensureFloatRange(-1000.0, 1000.0, &accelerometer.x);
	ensureFloatRange(-1000.0, 1000.0, &accelerometer.y);
	ensureFloatRange(-1000.0, 1000.0, &accelerometer.z);
	//fprintf(stderr, "accelerometer: %.2f, %.2f, %.2f\n", accelerometer.x, accelerometer.y, accelerometer.z);
	return false;
}
