/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Author: Damian Waradzyn
 */

#include "MenuElement.h"
#include "../main.h"
#include "../display/texture.h"
#include "../display/glcanvas.h"

MenuElement::MenuElement(QString name, QString icon, Action* action) {
	this -> name = name;
	this -> icon = icon;
	this -> action = action;
	if (icon != NULL) {
		surface = loadTextureFromFile(icon.toUtf8().data(), NULL, NULL);
	} else {
		surface = 0;
	}
	texture = 0;
}

GLfloat** MenuElement::getIconTexCoords() {
	return (GLfloat**) texCoordsPortrait;
}

int MenuElement::getIconSize() {
	if (surface == 0) {
		return 0;
	}
	return surface -> w;
}
void MenuElement::createTexture() {
	if (surface == 0) {
		return;
	}
	if (this -> texture == 0) {
		this -> texture = ::createTexture((GLushort*)surface -> pixels, surface -> w, surface -> h, FALSE);
	}
}

void MenuElement::deleteTexture() {
	::deleteTexture(this -> texture);
	this -> texture = 0;
}

MenuElement::~MenuElement() {
	// TODO Auto-generated destructor stub
}
