/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Author: Damian Waradzyn
 */

#ifndef MENU_H_
#define MENU_H_

#include "MenuElement.h"
#include <QtCore/QList>

class Menu {
private:
	MenuElement* elementUnderMouse;
	AnimatedElement* rotationAnimation;
	TransitionState* rotationStateLandscape;
	QList<MenuElement*>* elements;
	bool active;
	bool verticalRotation;
	bool renderIcon;
	bool renderBackground;
	GLfloat position;
	GLfloat rotation;
	GLfloat positionDelta;
	GLfloat maxPosition;
	int columns;
	int elementWidth;
	int elementHeight;
	int padding;
	Transition* createTransitionIn(MenuElement* element, int i);
	void renderTexture(GLuint texture, int width, int height, GLfloat rotation);
	void renderElementBackground(MenuElement* element, GLfloat tx, GLfloat ty);
	void renderElementCaption(MenuElement* element, GLfloat tx, GLfloat ty);
	void renderElementIcon(MenuElement* element, GLfloat tx, GLfloat ty);
public:
	Menu(QList<MenuElement*>* elements);
	void enterComboBoxMode();
	void show();
	void hide();
	void render();
	bool isActive();
	void handleMouse();
	GLfloat getElemPositionX(MenuElement* element, int i);
	GLfloat getElemPositionY(MenuElement* element, int i);
	GLfloat calculateMinPosition();
	GLfloat calculateMaxPosition();
	GLfloat getElemWidth();
	GLfloat getElemHeight();
	GLfloat getPadding();
	void setColumns(int columns);
	void setElemWidth(int width);
	void setElemHeight(int height);
	void setPadding(int padding);
	void setVerticalRotation(bool verticalRotation);
	void setRenderBackground(bool renderBackground);
	void setRenderIcon(bool renderIcon);
	virtual ~Menu();

	static QList<MenuElement*>* createMainMenuElements();
	static QList<MenuElement*>* createOptionsMenuElements();
	static QList<MenuElement*>* createMapChooseMenuElements();
	static QList<MenuElement*>* createSearchServiceMenuElements();
	static QList<MenuElement*>* createRoutingServiceMenuElements();
	static QList<MenuElement*>* createMapPopupMenuElements();
	static QList<MenuElement*>* createKeyboardLanguageMenuElements();
};

#endif /* MENU_H_ */
