/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Author: Damian Waradzyn
 */

#ifndef MAPCHOOSEMENUELEMENT_H_
#define MAPCHOOSEMENUELEMENT_H_

#include "../main.h"
#include "../tile_engine/tile.h"
#include "MenuElement.h"

class MapChooseMenuElement: public MenuElement {
private:
	TileProvider* tileProvider;
	t_tile* tile;
public:
	MapChooseMenuElement(TileProvider* tileProvider);
	virtual ~MapChooseMenuElement();
	virtual void createTexture();
	virtual void deleteTexture();
	virtual int getIconSize();
	virtual bool isHighlighted() {return tileProvider == canvas.provider;}
	virtual GLfloat** getIconTexCoords();
};

#endif /* MAPCHOOSEMENUELEMENT_H_ */
