/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Author: Damian Waradzyn
 */


#ifndef GLCANVAS_H_
#define GLCANVAS_H_

#include <SDL/SDL.h>

#ifdef N900
#include <SDL/SDL_gles.h>
#endif


#include "../main.h"
#include "textRender.h"
#include "glunproject.h"
#include "texture.h"
#include "markerIterator.h"
#include "../tile_engine/tile.h"
#include "../tile_engine/tileengine.h"

extern GLfloat texCoordsLandscape[][8];
extern GLfloat arrowVertices[12];
extern GLfloat boxVertices[12];
extern GLfloat quadStripVertices[12];
extern GLfloat texCoordsPortrait[][8];
extern GLfloat zoomBarLines[40 * 3 * 2];
extern const int MEDIUM_FONT_METRICS[256];

int initGL();
void drawGLScene();
void setupGlScene();
void rotate2d(GLfloat* x, GLfloat* y, double rotation);
void resetQuadStripVertices();
void setQuadStripSize(GLfloat w, GLfloat h, GLfloat quad[12]);
void rotateQuadStripVertices(double angle, GLfloat rotx, GLfloat roty);
void setBoxSize(GLfloat w, GLfloat h, GLfloat box[12]);
void drawString(char* str, GLfloat r, GLfloat g, GLfloat b, int useMask);
void drawStringAlpha(char* str, GLfloat r, GLfloat g, GLfloat b, GLfloat a, int useMask, GLenum sfactor, GLenum dfactor);
int stringWidth(char * str);

void setDimmed(bool dimmed);

#endif /* GLCANVAS_H_ */
