/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Author: Damian Waradzyn
 */

#include "SequentialTransition.h"

void SequentialTransition::reset() {
	iter = new QListIterator<Transition*>(transitions);
	while (iter -> hasNext()) {
		iter -> next() -> reset();
	}
	isFinished = false;
	iter = NULL;
}

void SequentialTransition::nextFrame() {
	if (iter == NULL) {
		iter = new QListIterator<Transition*>(transitions);
		if (!iter -> hasNext()) {
			isFinished = true;
			delete iter;
			iter = NULL;
			return;
		}
		current = iter -> next();
	}
	current -> nextFrame();

	if (current -> finished()) {
		if (!iter -> hasNext()) {
			isFinished = true;
			delete iter;
			iter = NULL;
			return;
		}
		current = iter -> next();
	}
}

bool SequentialTransition::finished() {
	return isFinished;
}

SequentialTransition::~SequentialTransition() {
}
