/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Author: Damian Waradzyn
 */

#ifndef CUBICTRANSITION_H_
#define CUBICTRANSITION_H_

#include "../../main.h"
#include "../Transition.h"

class CubicTransition: public Transition {
private:
	GLfloat lower;
	GLfloat upper;
	int numFrames;
	int currentFrame;
	GLfloat* target;

public:
	CubicTransition(GLfloat* target, GLfloat lower, GLfloat upper, int numFrames) :
	lower(lower), upper(upper), numFrames(numFrames), currentFrame(0), target(target) {};
	virtual void nextFrame();
	virtual void reset();
	virtual bool finished();
	virtual ~CubicTransition();
};

#endif /* CUBICTRANSITION_H_ */
