/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Author: Damian Waradzyn
 */

#include "DialogText.h"
#include <QtCore/QList>
#include "../transitions/LinearTransition.h"
#include "../transitions/ParallelTransition.h"
#include "../transitions/DelayTransition.h"
#include "../transitions/SequentialTransition.h"

DialogText::DialogText() : translateX(0), translateY(0), transparency(0){
	QList<Transition*> transitionsIn;
//	transitionsIn.append(new LinearTransition(&transparency, 1.0, 1.0/64.0));
	transitionsIn.append(new DelayTransition(100));
//	transitionsIn.append(new LinearTransition(&translateX, -30.0, -1.0/2.0));
//	transitionsIn.append(new DelayTransition(100));
//	transitionsIn.append(new LinearTransition(&translateY, -30.0, -1.0/2.0));
//	transitionsIn.append(new DelayTransition(100));
//	transitionsIn.append(new LinearTransition(&translateX, 0.0, 1.0/4.0));
//	transitionsIn.append(new LinearTransition(&translateY, 0.0, 1.0/4.0));
//	transitionsIn.append(new LinearTransition(&transparency, .0, -1.0/64.0));
	transitionIn = new SequentialTransition(transitionsIn);
	transitionIn -> setSkipAllowed(false);

//	QList<Transition*> transitionsOut;
//	transitionOut = new SequentialTransition(transitionsOut);
//	transitionOut -> setSkipAllowed(false);
}

DialogText::~DialogText() {
	// TODO Auto-generated destructor stub
}
