/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Author: Damian Waradzyn
 */

#include "AnimationManager.h"
#include "Transition.h"

QList<AnimatedElement*> AnimationManager::animatedElements;

void AnimationManager::addAnimation(AnimatedElement* animatedElement) {
	animatedElements.append(animatedElement);
}

void AnimationManager::updateAnimations() {
	QListIterator<AnimatedElement*> iter(animatedElements);

	while (iter.hasNext()) {
		AnimatedElement* element = iter.next();
		if (element -> isPaused()) {
			continue;
		}
		TransitionState* current = element -> current;
		TransitionState* target = element -> target;

		Transition* transitionIn = current -> transitionIn;

		if (target != current) {
			target -> transitionIn -> reset();
			target -> transitionOut -> reset();
			if ((element -> transitionInCompleted || (transitionIn -> getSkipAllowed()))
			   && current -> transitionOut -> getSkipAllowed()) {
				element -> current = target;
				element -> transitionInCompleted = false;
			} else if (element -> transitionInCompleted && !(current -> transitionOut -> getSkipAllowed())) {
				current -> transitionOut -> nextFrame();
				if (current -> transitionOut -> finished()) {
					element -> transitionInCompleted = false;
					element -> current = target;
					continue;
				}
			}
		}

		transitionIn = element -> current -> transitionIn;

		if (!element -> transitionInCompleted) {
			transitionIn -> nextFrame();
			if (transitionIn -> finished()) {
				element -> transitionInCompleted = true;
			}
		}
	}
}

