/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Author: Damian Waradzyn
 */


#include "cloudmade_geocoder.h"

#define KEY_FEATURES "features"
#define KEY_CENTROID "centroid"
#define KEY_COORDINATES "coordinates"
#define KEY_BOUNDS "bounds"
#define KEY_PROPERTIES "properties"
#define KEY_NAME "name"
#define KEY_IS_IN "is_in"
#define KEY_WIKIPEDIA "Wikipedia"

void readCloudmadeWorldCoordinate(json_object * jobj, WorldCoordinate *wc) {
	wc -> latitude = json_object_get_double(json_object_array_get_idx(jobj, 0));
	wc -> longitude = json_object_get_double(json_object_array_get_idx(jobj, 1));
}

// features ->
//             centroid -> coordinates -> array[2] -> double
//             bounds -> array[2] -> array[2] -> double
//             properties ->
//                            name
//                            is_in

void cloudmade_parse_response(char* response) {
	// fprintf(stderr, "%s\n", json_string);
	size_t length;
	int i;

	json_object * jobj = json_tokener_parse(response);
	json_object * features = json_object_object_get(jobj, KEY_FEATURES);
	if (features != NULL) {
		length = json_object_array_length(features);
		for (i = 0; i < length; i++) {
			json_object * feature = json_object_array_get_idx(features, i);
			GeoCodeResult * result = calloc(1, sizeof(GeoCodeResult));
			readCloudmadeWorldCoordinate(json_object_object_get(json_object_object_get(feature, KEY_CENTROID), KEY_COORDINATES), &result -> centroid);
			readCloudmadeWorldCoordinate(json_object_array_get_idx(json_object_object_get(feature, KEY_BOUNDS), 0), &result -> bounds[0]);
			readCloudmadeWorldCoordinate(json_object_array_get_idx(json_object_object_get(feature, KEY_BOUNDS), 1), &result -> bounds[1]);
			json_object *properties = json_object_object_get(feature, KEY_PROPERTIES);
			result -> name = json_object_get_string(json_object_object_get(properties, KEY_NAME));
			result -> description = json_object_get_string(json_object_object_get(properties, KEY_IS_IN));
			result -> wikipedia = json_object_get_string(json_object_object_get(properties, KEY_WIKIPEDIA));

			//                    fprintf(stderr, "Name: '%s' Description: '%s', center: %f, %f, Wikipedia: '%s'\n", result -> name, result -> description, result -> centroid.latitude, result -> centroid.longitude, result-> wikipedia == NULL ? "null": result -> wikipedia);
			geocodingResults = g_list_append(geocodingResults, result);
		}
		searchResultsStatus = RESULTS_READY;
	} else {
		searchResultsStatus = ZERO_RESULTS;
	}
}
