/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Author: Damian Waradzyn
 */

SDL_mutex *mutex = NULL;

GQueue* createQueue() {
    GQueue* queue = g_queue_new();
    if (queue == NULL) {
        fprintf(stderr, "memory allocation error in createQueue\n");
        return NULL;
    }
    if (mutex == NULL) {
        mutex = SDL_CreateMutex();
    }
//    fprintf(stderr, "createQueue success\n");
    return queue;
}

void enqueue(GQueue* queue, gpointer data) {
    if (SDL_mutexP(mutex) == -1) {
        fprintf(stderr, "mutexP failed in enqueue\n");
        return;
    }
    g_queue_push_tail(queue, data);
    if (SDL_mutexV(mutex) == -1) {
        fprintf(stderr, "mutexV failed in enqueue\n");
    }
}

gpointer dequeue(GQueue* queue) {
    if (queue -> length == 0) {
        return NULL;
    }
    if (SDL_mutexP(mutex) == -1) {
        fprintf(stderr, "mutexP failed in dequeue\n");
        return NULL;
    }
    if (queue -> length == 0) {
        if (SDL_mutexV(mutex) == -1) {
            fprintf(stderr, "mutexV failed in dequeue (1)\n");
        }
        return NULL;
    }
    gpointer data = NULL;

    GList * elem = queue -> head;
    while (elem != NULL) {
        t_tile * tile = (t_tile*) elem -> data;
        if (tile -> visible) {
            data = elem->data;
            g_queue_remove_all(queue, tile);
            break;
        }
        elem = elem -> next;
    }

    if (data == NULL) {
        // TODO return tile nearest to visible tile
        data = g_queue_pop_head(queue);
    }

    if (SDL_mutexV(mutex) == -1) {
        fprintf(stderr, "mutexV failed in dequeue(2)\n");
    }
    ((t_tile*)data) -> state = STATE_LOADING;
    return data;
}

void deleteElems(GQueue * queue, gpointer data) {
    if (SDL_mutexP(mutex) == -1) {
        fprintf(stderr, "mutexP failed in deleteElem\n");
        return;
    }
    g_queue_remove_all(queue, data);

    if (SDL_mutexV(mutex) == -1) {
        fprintf(stderr, "mutexV failed in deleteElem\n");
    }
}

void purgeQueue(GQueue *queue) {
    if (SDL_mutexP(mutex) == -1) {
        fprintf(stderr, "mutexP failed in purgeQueue\n");
        return;
    }

    g_queue_clear(queue);

    if (SDL_mutexV(mutex) == -1) {
        fprintf(stderr, "mutexV failed in purgeQueue\n");
    }
}

int queueSize(GQueue * queue) {
    return queue -> length;
}
