/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Author: Damian Waradzyn
 */

// those need updating on portrait/landscape change.
GList* volatileUiElems = NULL;

void loadTexture(Texture* texture, char* filename) {
    SDL_Surface* textureRGB = NULL;
    //    fprintf(stderr, "loading texture from %s\n", filename);
    textureRGB = loadTextureFromFile(filename, NULL);
    //    fprintf(stderr, "loadTextureFromFile returned: %p\n", textureRGB);
    if (textureRGB != NULL) {
        texture -> size = textureRGB -> w;
        texture -> name = createTexture(convert8888to4444(textureRGB, FALSE), texture->size, texture-> size, FALSE);
        SDL_FreeSurface(textureRGB);
    } else {
        fprintf(stderr, "loadTexture %s failed\n", filename);
    }
}

UiElement* createUiElement(char* texture, char* mask, int landscapex, int landscapey, int portraitx, int portraity, void(*handlePressed)(),
        void(*handleDragged)(), int addToList) {
    UiElement* element = calloc(1, sizeof(UiElement));
    if (element == NULL) {
        fprintf(stderr, "memory allocation failed in createUiElement\n");
        return NULL;
    }

    loadTexture(&(element -> mask), mask);
    loadTexture(&(element -> texture), texture);

    landscapex -= (element -> texture.size) / 2;
    landscapey -= (element -> texture.size) / 2;
    portraitx -= (element -> texture.size) / 2;
    portraity -= (element -> texture.size) / 2;

    element -> landscapex = landscapex;
    element -> landscapey = landscapey;
    element -> x = landscapex;
    element -> y = landscapey;
    element -> portraitx = portraitx;
    element -> portraity = portraity;
    element -> status = UI_SHOWN;
    element -> color.r = 1.0;
    element -> color.g = 1.0;
    element -> color.b = 1.0;
    element -> color.a = 1.0;
    element -> handlePressed = handlePressed;
    element -> handleDragged = handleDragged;
    element -> texCoords = texCoordsLandscape[0];

    //    fprintf(stderr, "addtoqueue = %d\n", addToQueue);
    if (addToList) {
        uiElems = g_list_append(uiElems, element);
    }

    return element;
}

void destroyUiElement(UiElement* elem) {
    fprintf(stderr, "STUB - destroyUiElement(UiElement* elem)\n");
}

void drawUiElement(UiElement* elem) {

    glTranslatef(elem -> x, elem -> y, 0);
    glEnable(GL_BLEND);
    // mask
    glBlendFunc(GL_DST_COLOR, GL_ZERO);
    glColor4f(1.0, 1.0, 1.0, elem->color.a);
    glBindTexture(GL_TEXTURE_2D, elem->mask.name);

    // Dirty hack to make position always the same size on map.
    if (elem == position) {
        setQuadSize(elem->mask.size / canvas.scale, elem->mask.size / canvas.scale, quadVertices);
    } else {
        setQuadSize(elem->mask.size, elem->mask.size, quadVertices);
    }

    glVertexPointer(3, GL_FLOAT, 0, quadVertices);
    glTexCoordPointer(2, GL_FLOAT, 0, elem->texCoords);

    if (elem != zoomKnot) {
        glDrawArrays(GL_TRIANGLE_STRIP, 0, 4);
    }

    // texture

    // Dirty hack to make the zoom knot transculent
    if (elem == zoomKnot) {
        glBlendFunc(GL_ZERO, GL_ONE_MINUS_SRC_COLOR);
    } else {
        glBlendFunc(GL_ONE, GL_ONE_MINUS_SRC_ALPHA);
    }
    glColor4f(elem->color.r, elem->color.g, elem->color.b, elem->color.a);
    glBindTexture(GL_TEXTURE_2D, elem-> texture.name);
    glDrawArrays(GL_TRIANGLE_STRIP, 0, 4);

    glTranslatef(-elem -> x, -elem -> y, 0);
}

void loadUI() {
    loadTexture(&fontMedium, "/opt/cloudgps/res/font-medium.png");
    loadTexture(&fontMediumMask, "/opt/cloudgps/res/font-medium-mask.png");
    //loadTexture(&barbgmask, "/opt/cloudgps/res/bar-bg-mask.png");
    //    loadTexture(&barbg, "/opt/cloudgps/res/bar-bg.png");
    //    loadTexture(&barbg, "/opt/cloudgps/res/zoom-minus-mask.png");

    zoomOut = createUiElement("/opt/cloudgps/res/zoom-minus.png", "/opt/cloudgps/res/zoom-minus-mask.png", 50, SCREEN_HEIGHT - 150, SCREEN_WIDTH
            - 150, SCREEN_HEIGHT - 50, &tileEngineZoomOut, &tileEngineZoomOut, TRUE);

    zoomIn = createUiElement("/opt/cloudgps/res/zoom-plus.png", "/opt/cloudgps/res/zoom-plus-mask.png", SCREEN_WIDTH - 50, SCREEN_HEIGHT - 150,
            SCREEN_WIDTH - 150, 50, &tileEngineZoomIn, &tileEngineZoomIn, TRUE);
    gotomypos = createUiElement("/opt/cloudgps/res/gotomypos.png", "/opt/cloudgps/res/gotomypos-mask.png", SCREEN_WIDTH - 50, SCREEN_HEIGHT - 50,
            SCREEN_WIDTH - 50, 50, &tileEngineGotomypos, &tileEngineGotomypos, TRUE);
    position = createUiElement("/opt/cloudgps/res/position.png", "/opt/cloudgps/res/position-mask.png", 0, 0, 0, 0, NULL, NULL, TRUE);
    view2d = createUiElement("/opt/cloudgps/res/2d.png", "/opt/cloudgps/res/2d-mask.png", 50, SCREEN_HEIGHT - 50, SCREEN_WIDTH - 50, SCREEN_HEIGHT
            - 50, &tileEngineViewMode2D, NULL, TRUE);
    view2d -> status = UI_HIDDEN;
    view3d = createUiElement("/opt/cloudgps/res/3d.png", "/opt/cloudgps/res/3d-mask.png", 50, SCREEN_HEIGHT - 50, SCREEN_WIDTH - 50, SCREEN_HEIGHT
            - 50, &tileEngineViewMode3D, NULL, TRUE);
    crosshair = createUiElement("/opt/cloudgps/res/crosshair.png", "/opt/cloudgps/res/crosshair-mask.png", SCREEN_WIDTH / 2, SCREEN_HEIGHT / 2,
            SCREEN_WIDTH / 2, SCREEN_HEIGHT / 2, NULL, NULL, TRUE);
    compass = createUiElement("/opt/cloudgps/res/compass.png", "/opt/cloudgps/res/compass-mask.png", 150, SCREEN_HEIGHT - 50, SCREEN_WIDTH - 50,
            SCREEN_HEIGHT - 150, &tileEngineToggle2dRotation, NULL, TRUE);
    search = createUiElement("/opt/cloudgps/res/search.png", "/opt/cloudgps/res/search-mask.png", SCREEN_WIDTH - 150, SCREEN_HEIGHT - 50,
            SCREEN_WIDTH - 50, 150, &tileEngineToggleSearchBar, NULL, TRUE);
    zoomKnot = createUiElement("/opt/cloudgps/res/zoom-knot.png", "/opt/cloudgps/res/zoom-knot-mask.png", SCREEN_WIDTH - 150, SCREEN_HEIGHT - 50,
            SCREEN_WIDTH - 50, 150, &tileEngineZoomKnotPressed, &tileEngineZoomKnotDragged, TRUE);
    zoomKnot -> status = UI_HIDDEN;
    volatileUiElems = g_list_append(volatileUiElems, zoomOut);
    volatileUiElems = g_list_append(volatileUiElems, view2d);
    volatileUiElems = g_list_append(volatileUiElems, view3d);
    volatileUiElems = g_list_append(volatileUiElems, compass);
    volatileUiElems = g_list_append(volatileUiElems, search);
    volatileUiElems = g_list_append(volatileUiElems, gotomypos);
    volatileUiElems = g_list_append(volatileUiElems, zoomIn);
}

SDL_Surface * texttmpsurface = NULL;

void drawUiElems() {
    GList* elem = uiElems;

    while (elem != NULL) {
        UiElement* uiElem = (UiElement*) elem -> data;
        if (uiElem -> status != UI_HIDDEN && uiElem != position) {
            drawUiElement(elem -> data);
        }
        elem = elem -> next;
    }
    glTranslatef(compass -> x + compass -> texture.size / 2, compass -> y + compass -> texture.size / 2, 0.0);
    glDisable(GL_TEXTURE_2D);
    glEnable(GL_BLEND);
    glBlendFunc(GL_DST_COLOR, GL_ZERO);
    if (canvas.viewMode == VIEW_2D && canvas.rotation2d == FALSE) {
        glColor4f(.2, .2, .2, 0.6);
    } else {
        glColor4f(.3, .3, 1.0, 0.6);
    }
    glVertexPointer(3, GL_FLOAT, 0, arrowVertices);
    glRotatef(canvas.rotz, 0.0, 0.0, 1.0);
    glDrawArrays(GL_TRIANGLE_STRIP, 0, 4);
    glRotatef(canvas.rotz, 0.0, 0.0, -1.0);

    glTranslatef(-compass -> x - compass -> texture.size / 2, -compass -> y - compass -> texture.size / 2, 0.0);
    glEnable(GL_TEXTURE_2D);

    //
    //    SDL_Color color = { 0, 0, 0 };
    //    SDL_Surface *surface;
    //    if (!(surface = TTF_RenderText_Blended(font, "Hello World!", color))) {
    //        fprintf(stderr, "TTF_RenderText_Shaded failed: %s\n", TTF_GetError());
    //    } else {
    //
    //        if (texttmpsurface == NULL) {
    //            texttmpsurface = SDL_CreateRGBSurface(SDL_SWSURFACE, 512, 512, 32, 0x000000FF, 0x0000FF00, 0x00FF0000, 0xFF000000);
    //            if (texttmpsurface == NULL) {
    //                fprintf(stderr, "createRGBsurface texttmpsurface failed \n");
    //                exit(1);
    //            }
    //        }
    //        SDL_Rect rect;
    //        rect.x = 0;
    //        rect.y = 0;
    //        rect.w = surface->w;
    //        rect.h = surface->h;
    //        SDL_BlitSurface(surface, &rect, texttmpsurface, &rect);
    //        SDL_FreeSurface(surface);
    //
    //
    //        GLushort * aaa = convert8888to4444(texttmpsurface, FALSE);
    //        int cropRect[] = {0,0,100, 100};
    //        GLuint texture = 0;
    //        glEnable(GL_TEXTURE_2D);
    //        glGenTextures(1, &texture);
    //        glBindTexture(GL_TEXTURE_2D, texture);
    //        glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, 512, 512, 0, GL_RGBA, GL_UNSIGNED_SHORT_4_4_4_4, aaa);
    //        glTexParameteriv(GL_TEXTURE_2D, GL_TEXTURE_CROP_RECT_OES, cropRect);//crash
    //        m_exgldrawte(0, 0, 1, 256, 256);//crash
    //
    //
    //        createTexture(aaa, surface -> w, surface -> h, FALSE);
    //
    //        //SDL_BlitSurface(text_surface,NULL,screen,NULL);
    //        //perhaps we can reuse it, but I assume not for simplicity.
    //
    //        SDL_FreeSurface(surface);
    //    }
}

void drawZoomBar() {
    int idx = 0, i;

    if (canvas.zoomBarAlpha == 0.0) {
        return;
    }
    if (canvas.orientationTransitionLinear < 80) {
        glTranslatef(0, SCREEN_HEIGHT - canvas.searchBarY, 0);
    } else {
        glTranslatef(SCREEN_WIDTH - canvas.searchBarY, SCREEN_HEIGHT, 0);
        glRotatef(-90, 0.0, 0.0, 1.0);
    }
    if (canvas.orientationTransitionLinear == 80) {
        activateZoomBar();
    }

    GLfloat screenSize = options.orientation == LANDSCAPE ? SCREEN_WIDTH : SCREEN_HEIGHT;
    int zoomLevelCount = canvas.provider -> maxZoom - canvas.provider -> minZoom + 1;

    if (zoomBarInitialized == FALSE) {
        for (i = 0; i <= zoomLevelCount; i++) {
            zoomBarLines[idx++] = i * (screenSize - 200) / zoomLevelCount + 100;
            zoomBarLines[idx++] = -148;
            zoomBarLines[idx++] = 0.0;

            zoomBarLines[idx++] = i * (screenSize - 200) / zoomLevelCount + 100;
            zoomBarLines[idx++] = -158;
            zoomBarLines[idx++] = 0.0;

        }
        zoomBarInitialized = TRUE;
    }

    glDisable(GL_TEXTURE_2D);
    glEnable(GL_BLEND);
    glBlendFunc(GL_DST_COLOR, GL_ZERO);
    glVertexPointer(3, GL_FLOAT, 0, zoomBarLines);
    glColor4f(1.0 - canvas.zoomBarAlpha, 1.0 - canvas.zoomBarAlpha, 1.0 - canvas.zoomBarAlpha, 1.0);
    glDrawArrays(GL_LINES, 0, zoomLevelCount * 2 + 2);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    glColor4f(.4, .4, .4, canvas.zoomBarAlpha);
    glDrawArrays(GL_LINES, 0, zoomLevelCount * 2 + 2 + 8);
    glEnable(GL_TEXTURE_2D);

    GLfloat x = canvas.orientationTransitionLinear < 80 ? zoomKnot -> x : SCREEN_HEIGHT - zoomKnot -> y - 64;
    glTranslatef(x, -180, 0);
    sprintf(buf, "zoom = %d", getKnotDestZoom());
    drawStringAlpha(buf, canvas.zoomBarAlpha, canvas.zoomBarAlpha, canvas.zoomBarAlpha, 1.0, FALSE, GL_ZERO, GL_ONE_MINUS_SRC_COLOR);
    glTranslatef(-x, 180, 0);

    if (canvas.orientationTransitionLinear < 80) {
        glTranslatef(0, -SCREEN_HEIGHT + canvas.searchBarY, 0);
    } else {
        glRotatef(90, 0.0, 0.0, 1.0);
        glTranslatef(-SCREEN_WIDTH + canvas.searchBarY, -SCREEN_HEIGHT, 0);
    }
}

void drawSearchBar() {
    if (canvas.searchBarY > 0.0) {
        glDisable(GL_TEXTURE_2D);
        glEnable(GL_BLEND);
        if (canvas.orientationTransitionLinear < 80) {
            glTranslatef(0, SCREEN_HEIGHT - canvas.searchBarY, 0);
        } else {
            glTranslatef(SCREEN_WIDTH - canvas.searchBarY, SCREEN_HEIGHT, 0);
            glRotatef(-90, 0.0, 0.0, 1.0);
        }

        setQuadSize(canvas.orientationTransitionLinear < 80 ? SCREEN_WIDTH : SCREEN_HEIGHT, 64, quadVertices);
        glBlendFunc(GL_DST_COLOR, GL_ZERO);
        glColor4f(.7, .7, .7, 0.5);
        glVertexPointer(3, GL_FLOAT, 0, quadVertices);
        glDrawArrays(GL_TRIANGLE_STRIP, 0, 4);

        glTranslatef(5, 5, 0);
        setQuadSize(canvas.orientationTransitionLinear < 80 ? SCREEN_WIDTH - 10 : SCREEN_HEIGHT - 10, 64 - 10, quadVertices);
        glColor4f(0.7, .7, .7, 0.5);
        glVertexPointer(3, GL_FLOAT, 0, quadVertices);
        glDrawArrays(GL_TRIANGLE_STRIP, 0, 4);
        glTranslatef(5, 25, 0);

        if (((nowMillis - searchBar.lastChange) / 200) % 2 == 0) {
            GLfloat cursor[] = { searchBar.cursorScreen, -10, 0, searchBar.cursorScreen, 24, 0 };
            glDisable(GL_BLEND);
            glColor4f(1.0, 1.0, 1.0, 1.0);
            glVertexPointer(3, GL_FLOAT, 0, cursor);
            glDrawArrays(GL_LINES, 0, 2);
        }
        glEnable(GL_BLEND);
        glEnable(GL_TEXTURE_2D);
        drawString(searchBar.input, 1.0, 1.0, 1.0, FALSE);
        if (canvas.orientationTransitionLinear < 80) {
            glTranslatef(-10, -SCREEN_HEIGHT + canvas.searchBarY - 30, 0);
        } else {
            glTranslatef(-10, -30, 0);
            glRotatef(90, 0.0, 0.0, 1.0);
            glTranslatef(-SCREEN_WIDTH + canvas.searchBarY, -SCREEN_HEIGHT, 0);
        }
    }
}

GLfloat satelliteBars[18 * MAX_SATTELITES];
GLfloat satelliteBarOutlines[24 * MAX_SATTELITES];
GLfloat satelliteBarColors[4 * 6 * MAX_SATTELITES];
GLfloat satelliteBarOutlineColors[4 * 8 * MAX_SATTELITES];
int satelliteBarOutlinesInitialized = FALSE;

void drawSatelliteBars(GLfloat barHeight, GLfloat barWidth, GLfloat separation) {
    int i, j;
    GLfloat x;
    if (!satelliteBarOutlinesInitialized) {
        for (i = 0; i < MAX_SATTELITES; i++) {
            x = i * (barWidth + separation);
            /*    1
             *  -----
             * |     |
             * |4    |2
             * |     |
             *  -----
             *    3
             */
            // 1
            satelliteBarOutlines[i * 24] = x;
            satelliteBarOutlines[i * 24 + 1] = 0.0;
            satelliteBarOutlines[i * 24 + 2] = 0.0;

            satelliteBarOutlines[i * 24 + 3] = x + barWidth;
            satelliteBarOutlines[i * 24 + 4] = 0.0;
            satelliteBarOutlines[i * 24 + 5] = 0.0;

            //2
            satelliteBarOutlines[i * 24 + 6] = x + barWidth;
            satelliteBarOutlines[i * 24 + 7] = 0.0;
            satelliteBarOutlines[i * 24 + 8] = 0.0;

            satelliteBarOutlines[i * 24 + 9] = x + barWidth;
            satelliteBarOutlines[i * 24 + 10] = barHeight;
            satelliteBarOutlines[i * 24 + 11] = 0.0;

            //3
            satelliteBarOutlines[i * 24 + 12] = x + barWidth;
            satelliteBarOutlines[i * 24 + 13] = barHeight;
            satelliteBarOutlines[i * 24 + 14] = 0.0;

            satelliteBarOutlines[i * 24 + 15] = x;
            satelliteBarOutlines[i * 24 + 16] = barHeight;
            satelliteBarOutlines[i * 24 + 17] = 0.0;

            // 4
            satelliteBarOutlines[i * 24 + 18] = x;
            satelliteBarOutlines[i * 24 + 19] = barHeight;
            satelliteBarOutlines[i * 24 + 20] = 0.0;

            satelliteBarOutlines[i * 24 + 21] = x;
            satelliteBarOutlines[i * 24 + 22] = 0.0;
            satelliteBarOutlines[i * 24 + 23] = 0.0;
        }
        satelliteBarOutlinesInitialized = TRUE;
    }

    if (device && device -> satellites) {
        for (i = 0; i < MAX_SATTELITES; i++) {
            x = i * (barWidth + separation);
            if (i < device -> satellites -> len) {
                LocationGPSDeviceSatellite* sat = device -> satellites -> pdata[i];
                int signalHeight = (sat -> signal_strength) / 2;

                if (sat -> in_use) {
                    for (j = 0; j < 8; j++) {
                        satelliteBarOutlineColors[i * 32 + j * 4] = 1.0;
                        satelliteBarOutlineColors[i * 32 + j * 4 + 1] = 1.0;
                        satelliteBarOutlineColors[i * 32 + j * 4 + 2] = 1.0;
                        satelliteBarOutlineColors[i * 32 + j * 4 + 3] = 0.5;
                        if (j < 6) {
                            satelliteBarColors[i * 24 + j * 4] = 1.0;
                            satelliteBarColors[i * 24 + j * 4 + 1] = 1.0;
                            satelliteBarColors[i * 24 + j * 4 + 2] = 1.0;
                            satelliteBarColors[i * 24 + j * 4 + 3] = 0.5;
                        }
                    }
                } else {
                    for (j = 0; j < 8; j++) {
                        satelliteBarOutlineColors[i * 32 + j * 4] = 0.4;
                        satelliteBarOutlineColors[i * 32 + j * 4 + 1] = 0.4;
                        satelliteBarOutlineColors[i * 32 + j * 4 + 2] = 0.4;
                        satelliteBarOutlineColors[i * 32 + j * 4 + 3] = 0.5;
                        if (j < 6) {
                            satelliteBarColors[i * 24 + j * 4] = 0.4;
                            satelliteBarColors[i * 24 + j * 4 + 1] = 0.4;
                            satelliteBarColors[i * 24 + j * 4 + 2] = 0.4;
                            satelliteBarColors[i * 24 + j * 4 + 3] = 0.5;
                        }
                    }
                }

                /*  1,6         2
                 *    ---------
                 *   | \      |
                 *   |  \     |
                 *   |   \    |
                 *   |    \   |
                 *   |     \  |
                 *   |      \ |
                 *  5 --------3,4
                 *
                 */
                // 1
                satelliteBars[i * 18] = x;
                satelliteBars[i * 18 + 1] = barHeight - 1 - signalHeight;
                satelliteBars[i * 18 + 2] = 0.0;

                // 2
                satelliteBars[i * 18 + 3] = x + barWidth;
                satelliteBars[i * 18 + 4] = barHeight - 1 - signalHeight;
                satelliteBars[i * 18 + 5] = 0.0;

                // 3
                satelliteBars[i * 18 + 6] = x + barWidth;
                satelliteBars[i * 18 + 7] = barHeight - 1;
                satelliteBars[i * 18 + 8] = 0.0;

                // 4
                satelliteBars[i * 18 + 9] = x + barWidth;
                satelliteBars[i * 18 + 10] = barHeight - 1;
                satelliteBars[i * 18 + 11] = 0.0;

                // 5
                satelliteBars[i * 18 + 12] = x;
                satelliteBars[i * 18 + 13] = barHeight - 1;
                satelliteBars[i * 18 + 14] = 0.0;

                // 6
                satelliteBars[i * 18 + 15] = x;
                satelliteBars[i * 18 + 16] = barHeight - 1 - signalHeight;
                satelliteBars[i * 18 + 17] = 0.0;

                // TODO - this should be optimized and passed to opengl in one call.
                sprintf(buf, "%d", sat -> prn);
                x += 5 - stringWidth(buf) / 2;

                glTranslatef(x, barHeight, 0);
                drawString(buf, .7 + .3 * (i % 2), .7 + .3 * (i % 2), .7 + .3 * (i % 2), TRUE);
                glTranslatef(-x, -barHeight, 0);

            } else {
                for (j = 0; j < 8; j++) {
                    satelliteBarOutlineColors[i * 32 + j * 4] = 0.4;
                    satelliteBarOutlineColors[i * 32 + j * 4 + 1] = 0.4;
                    satelliteBarOutlineColors[i * 32 + j * 4 + 2] = 0.4;
                    satelliteBarOutlineColors[i * 32 + j * 4 + 3] = 0.5;
                    if (j < 6) {
                        satelliteBarColors[i * 24 + j * 4] = 0.4;
                        satelliteBarColors[i * 24 + j * 4 + 1] = 0.4;
                        satelliteBarColors[i * 24 + j * 4 + 2] = 0.4;
                        satelliteBarColors[i * 24 + j * 4 + 3] = 0.5;
                    }
                }
            }
        }
    }

    glBindTexture(GL_TEXTURE_2D, 0);
    glEnableClientState(GL_COLOR_ARRAY);
    if (device -> satellites && device -> satellites -> len > 0) {
        glColorPointer(4, GL_FLOAT, 0, satelliteBarColors);
        glVertexPointer(3, GL_FLOAT, 0, satelliteBars);
        glDrawArrays(GL_TRIANGLES, 0, 6 * device -> satellites -> len);
    }

    glColorPointer(4, GL_FLOAT, 0, satelliteBarOutlineColors);
    glVertexPointer(3, GL_FLOAT, 0, satelliteBarOutlines);
    glDrawArrays(GL_LINES, 0, 8 * MAX_SATTELITES);
    glDisableClientState(GL_COLOR_ARRAY);
}

void drawStatusBar(Orientation orientation) {
    if (canvas.orientationTransition > 0.001 && canvas.orientationTransition < .999) {
        if (orientation == LANDSCAPE) {
            glTranslatef(-SCREEN_WIDTH * canvas.orientationTransition, 0, 0);
        } else {
            glTranslatef(0, SCREEN_HEIGHT * canvas.orientationTransition, 0);
        }
    } else {
        if (orientation != options.orientation) {
            return;
        }
        if (orientation == PORTRAIT) {
            glTranslatef(0, SCREEN_HEIGHT * canvas.orientationTransition, 0);
        }
    }
    if (orientation == PORTRAIT) {
        glRotatef(-90, 0.0, 0.0, 1.0);
    }
    glEnable(GL_BLEND);
    glBlendFunc(GL_DST_COLOR, GL_ZERO);
    glColor4f(.4, .4, .4, 0.5);

    GLfloat statusBarHeight;

    if (orientation == LANDSCAPE) {
        statusBarHeight = 50;
    } else {
        statusBarHeight = 70;
    }

    // statusbar background - half transparent grey rectangle
    setQuadSize(SCREEN_WIDTH, statusBarHeight, quadVertices);
    glBindTexture(GL_TEXTURE_2D, 0);
    glVertexPointer(3, GL_FLOAT, 0, quadVertices);
    glDrawArrays(GL_TRIANGLE_STRIP, 0, 4);

    glTranslatef(10, 5, 0);
    if (orientation == LANDSCAPE) {
        sprintf(buf, "Downloaded: %.2f kb", downloaded / 1024.0);
    } else {
        sprintf(buf, "D/l: %.2f kb", downloaded / 1024.0);
    }
    drawString(buf, 1.0, 1.0, 1.0, FALSE);
    glTranslatef(0, 20, 0);
    switch (device -> fix -> mode) {
        case LOCATION_GPS_DEVICE_MODE_2D:
            sprintf(buf, "GPS fix: 2D");
            break;
        case LOCATION_GPS_DEVICE_MODE_3D:
            sprintf(buf, "GPS fix: 3D");
            break;
        case LOCATION_GPS_DEVICE_MODE_NOT_SEEN:
            sprintf(buf, "GPS fix: not seen");
            break;
        case LOCATION_GPS_DEVICE_MODE_NO_FIX:
            sprintf(buf, "GPS fix: no fix");
            break;
    }
    drawString(buf, 1.0, 1.0, 1.0, FALSE);
    if (orientation == LANDSCAPE) {
        glTranslatef(180, -20, 0);
    } else {
        glTranslatef(120, -20, 0);
    }

    if (device -> satellites_in_use > 0 && device -> fix -> fields | LOCATION_GPS_DEVICE_ALTITUDE_SET && !isnan(device -> fix -> altitude)) {
        sprintf(buf, "Altitude: %.2f m", device -> fix -> altitude);
    } else {
        sprintf(buf, "Altitude: ---");
    }
    drawString(buf, 1.0, 1.0, 1.0, FALSE);
    glTranslatef(0, 20, 0);

    if (device -> satellites_in_use > 0 && device -> fix -> fields | LOCATION_GPS_DEVICE_SPEED_SET && !isnan(device -> fix -> speed)) {
        sprintf(buf, "Speed: %.2f km/h", device -> fix -> speed);
    } else {
        sprintf(buf, "Speed: ---");
    }
    drawString(buf, 1.0, 1.0, 1.0, FALSE);

    if (orientation == LANDSCAPE) {
        glTranslatef(SCREEN_WIDTH - 280, -20, 0);
    } else {
        glTranslatef(-120, 20, 0);
    }

    sprintf(buf, "FPS: %.1f", fps);
    drawString(buf, 1.0, 1.0, 1.0, FALSE);
    if (orientation == LANDSCAPE) {
        glTranslatef(0, 20, 0);
    } else {
        glTranslatef(120, 0, 0);
    }

    sprintf(buf, "Battery: %d%%", batteryPercentage);
    drawString(buf, 1.0, 1.0, 1.0, FALSE);

    if (orientation == LANDSCAPE) {
        glTranslatef(-250, -23, 0);
    } else {
        glTranslatef(135, -30, 0);
    }

    glBlendFunc(GL_ONE, GL_ONE_MINUS_SRC_ALPHA);
    glBindTexture(GL_TEXTURE_2D, 0);
    drawSatelliteBars(32, 12, 6);

    if (orientation == LANDSCAPE) {
        glTranslatef(SCREEN_WIDTH * canvas.orientationTransition, 0, 0);
    }
}

int processUiMouse() {
    GList* elem = uiElems;
    if (canvas.zoomBarAlpha > 0.2) {
        zoomKnot -> status = UI_SHOWN;
    } else {
        zoomKnot -> status = UI_HIDDEN;
    }
    if (mouse.button == 1) {
        if (mouse.oldButton == 0) {
            while (elem != NULL) {
                UiElement* e = (UiElement*) elem->data;
                if (e -> status == UI_SHOWN && mouse.x >= e->x && mouse.x <= e->x + e->texture.size && mouse.y >= e->y && mouse.y <= e->y
                        + e->texture.size) {
                    pressedUiElem = e;
                    if (pressedUiElem -> handlePressed != NULL) {
                        pressedUiElem -> handlePressed();
                        return TRUE;
                    }
                    return FALSE;
                }

                elem = elem -> next;
            }
            pressedUiElem = NULL;
        } else {
            if (pressedUiElem != NULL) {
                if (pressedUiElem -> handleDragged != NULL) {
                    pressedUiElem -> handleDragged();
                }
                return TRUE;
            }
        }
    }
    return FALSE;
}

void updateAnimationValue(int enabled, GLfloat *value, GLfloat minValue, GLfloat maxValue, GLfloat speed) {
    if (enabled) {
        if (*value < maxValue * (1.0 - speed * speed)) {
            *value += speed * (maxValue - *value);
        } else {
            *value = maxValue;
        }
    } else {
        if (*value > minValue + (maxValue - minValue) * speed * speed) {
            *value -= speed * (*value - minValue);
        } else {
            *value = minValue;
        }
    }

}

void updateUi() {
    if (device && device -> fix) {

        if (device -> fix -> fields | LOCATION_GPS_DEVICE_LATLONG_SET) {
            position -> status = UI_SHOWN;
            WorldCoordinate wc;
            wc.latitude = device -> fix -> latitude;
            wc.longitude = device -> fix -> longitude;
            TileCoordinate tc;
            toTileCoordinate(&wc, &tc, canvas.zoom);

            toScreenCoordinate(&tc, &position ->x, &position -> y);
            position -> x -= position -> texture.size / 2 / canvas.scale;
            position -> y -= position -> texture.size / 2 / canvas.scale;

            position -> color.a = 0.75 + 0.25 * sin(nowMillis / 500.0);
            position -> color.r = position -> color.a;
            position -> color.g = position -> color.a;

            if (device -> satellites_in_use > 0) {
                position -> color.b = 1.0 - position -> color.a;
            } else {
                position -> color.b = position -> color.a;
            }

            //            fprintf(stderr, "position on screeen: x = %f, y = %f, color = %f\n", position -> x, position -> y, position -> color.a);
        } else {
            position -> status = UI_HIDDEN;
        }
    }

    gotomypos -> color.r = canvas.followingMypos * .3 + .4;
    gotomypos -> color.g = canvas.followingMypos * .3 + .4;
    gotomypos -> color.b = canvas.followingMypos * .3 + .4;

    updateAnimationValue(canvas.searchBarActive, &canvas.searchBarY, 0.0, 64.0, 0.1);
    updateAnimationValue(canvas.zoomBarActive, &canvas.zoomBarAlpha, 0.0, 1.0, 0.03);

    GList * volatileElem = volatileUiElems;
    if (canvas.orientationTransitionLinear > 0 && canvas.orientationTransitionLinear < 160) {
        int i = 0;

        if (canvas.orientationTransitionLinear == 80) {
            zoomBarInitialized = FALSE;
        }

        if (canvas.searchBarActive) {
            if (canvas.orientationTransitionLinear <= 80) {
                canvas.searchBarY = 64 - canvas.orientationTransitionLinear;
            } else {
                canvas.searchBarY = 64 - (160 - canvas.orientationTransitionLinear);
            }
            if (canvas.searchBarY < 0.0) {
                canvas.searchBarY = 0.0;
            }
        }
        while (volatileElem != NULL) {
            UiElement * elem = volatileElem -> data;

            if (canvas.orientationTransitionLinear <= 80) {
                elem -> x = elem -> landscapex;
                elem -> y = elem -> landscapey - canvas.searchBarY;
                if (canvas.orientationTransitionLinear > i) {
                    GLfloat xxx = canvas.orientationTransitionLinear - i;
                    elem -> y += pow((xxx), 1.65);
                }
                elem -> texCoords = texCoordsLandscape[0];
            } else {
                elem -> x = elem -> portraitx - canvas.searchBarY;
                elem -> y = elem -> portraity;
                elem -> texCoords = texCoordsPortrait[0];
                if (160 - canvas.orientationTransitionLinear > i) {
                    GLfloat xxx = 160 - (canvas.orientationTransitionLinear) - i;
                    elem -> x += pow(xxx, 1.65);
                }
            }
            volatileElem = volatileElem -> next;
            i += 10;
        }
    } else {
        while (volatileElem != NULL) {
            UiElement * elem = volatileElem -> data;
            if (options.orientation == LANDSCAPE) {
                elem -> x = elem -> landscapex;
                elem -> y = elem -> landscapey - canvas.searchBarY;
                elem -> texCoords = texCoordsLandscape[0];
            } else {
                elem -> x = elem -> portraitx - canvas.searchBarY;
                elem -> y = elem -> portraity;
                elem -> texCoords = texCoordsPortrait[0];
            }
            volatileElem = volatileElem -> next;
        }
    }

    if (nowMillis > canvas.zoomBarVisibleMilis) {
        canvas.zoomBarActive = FALSE;
    }

    if (canvas.orientationTransitionLinear == 79) {
        activateZoomBar();
        zoomKnot -> x = canvas.zoomKnotPosition;
        zoomKnot -> y = SCREEN_HEIGHT - 185 - canvas.searchBarY;
    } else if (canvas.orientationTransitionLinear == 80) {
        activateZoomBar();
        zoomKnot -> y = canvas.zoomKnotPosition;
        zoomKnot -> x = SCREEN_WIDTH - 185 - canvas.searchBarY;
    }

    zoomKnot -> color.r = canvas.zoomBarAlpha;
    zoomKnot -> color.g = canvas.zoomBarAlpha;
    zoomKnot -> color.b = canvas.zoomBarAlpha;
    zoomKnot -> color.a = 1.0;
//    zoomKnot -> status = UI_HIDDEN;
    if (canvas.orientationTransitionLinear < 80) {
        zoomKnot -> x += (canvas.zoomKnotPosition - zoomKnot -> x) / 4.0;
        zoomKnot -> y = SCREEN_HEIGHT - 185 - canvas.searchBarY;
        zoomKnot -> texCoords =  texCoordsLandscape[0];
    } else {
        zoomKnot -> x = SCREEN_WIDTH - 185 - canvas.searchBarY;
        zoomKnot -> y += (canvas.zoomKnotPosition - zoomKnot -> y) / 4.0;
        zoomKnot -> texCoords =  texCoordsPortrait[0];
    }
}

