SDL_GLES_Context *context;

void setQuadSize(GLfloat h, GLfloat w, GLfloat quad[12]) {
    quad[3] = w;
    quad[7] = h;
    quad[9] = w;
    quad[10] = h;
}

const int MEDIUM_FONT_METRICS[256] = { 8, 8, 8, 8, 8, 8, 8, 8, 8, 56, 0, 8, 8, 0, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 4, 5, 5, 11,
        8, 12, 11, 3, 5, 5, 7, 11, 4, 5, 4, 4, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 4, 4, 11, 11, 11, 7, 13, 9, 9, 9, 10, 8, 7, 10, 10, 3, 3, 8, 7, 11, 10,
        10, 8, 10, 8, 9, 7, 10, 9, 11, 10, 7, 10, 5, 4, 5, 11, 7, 7, 8, 8, 7, 8, 8, 4, 8, 8, 3, 3, 7, 3, 13, 8, 8, 8, 8, 5, 7, 5, 8, 7, 9, 7, 7, 7,
        8, 4, 8, 11, 8, 8, 8, 4, 8, 7, 13, 7, 7, 7, 17, 9, 5, 14, 8, 10, 8, 8, 4, 4, 7, 7, 8, 7, 13, 7, 13, 7, 5, 13, 8, 7, 7, 8, 5, 8, 8, 8, 8, 4,
        7, 7, 13, 6, 8, 11, 5, 13, 7, 7, 11, 5, 5, 7, 8, 8, 4, 7, 5, 6, 8, 13, 13, 13, 7, 9, 9, 9, 9, 9, 9, 13, 9, 8, 8, 8, 8, 3, 3, 3, 3, 10, 10,
        10, 10, 10, 10, 10, 11, 10, 10, 10, 10, 10, 7, 8, 8, 8, 8, 8, 8, 8, 8, 13, 7, 8, 8, 8, 8, 3, 3, 3, 3, 8, 8, 8, 8, 8, 8, 8, 11, 8, 8, 8, 8, 8,
        7, 8, 7 };

/* general OpenGL initialization function */
int initGL(GLvoid) {
    SDL_GLES_Init(SDL_GLES_VERSION_1_1);

    context = SDL_GLES_CreateContext();
    SDL_GLES_MakeCurrent(context);

    /* Enable Texture Mapping ( NEW ) */
    glEnable(GL_TEXTURE_2D);

    glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
    glEnable(GL_CLEAR);

    glEnableClientState(GL_VERTEX_ARRAY);
    glEnableClientState(GL_TEXTURE_COORD_ARRAY);

    glDisable(GL_DEPTH_TEST);
    glDisable(GL_CULL_FACE);
    glViewport(0, 0, (GLint) SCREEN_WIDTH, (GLint) SCREEN_HEIGHT);
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    glOrthof(0, SCREEN_WIDTH, SCREEN_HEIGHT, 0, -100.0, 100.0);
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();

//    const GLubyte *extensions = glGetString(GL_EXTENSIONS);
//    fprintf(stderr, "GL extensions: %s\n", (const char*) extensions);

    return (TRUE);
}

GLfloat quadVertices[12] = { 0.0f, 0.0f, 0.0f, /* Bottom Left Of The Quad */
1.0f, 0.0f, 0.0f, /* Bottom Right Of The Quad */
0.0f, 1.0f, 0.0f, /* Top Left Of The Quad */
1.0f, 1.0f, 0.0f, /* Top Right Of The Quad */
};

const GLfloat texCoords[][8] = { { 0.0f, 0.0f, /* Bottom Left Of The Texture */
1.0f, 0.0f, /* Bottom Right Of The Texture */
0.0f, 1.0f, /* Top Left Of The Texture */
1.0f, 1.0f, /* Top Right Of The Texture */
} };

float color = 1.0;

void drawTile(t_tile *tile) {
    switch (tile->state) {
        case STATE_EMPTY:
            //            glColor4f(0.0f, 0.0f, 1.0f, 1.0f);
            //            glVertexPointer(3, GL_FLOAT, 0, boxVertices[0]);
            //            glDrawArrays(GL_LINE_LOOP, 0, 4);
            break;
        case STATE_ERROR:
            //            glColor4f(1.0f, 0.0f, 0.0f, 1.0f);
            //            glVertexPointer(3, GL_FLOAT, 0, boxVertices[0]);
            //            glDrawArrays(GL_LINE_LOOP, 0, 4);
            break;
        case STATE_LOADING:
            //            glColor4f(0.0f, 1.0f, 0.0f, 1.0f);
            //            glVertexPointer(3, GL_FLOAT, 0, boxVertices[0]);
            //            glDrawArrays(GL_LINE_LOOP, 0, 4);
            break;
        case STATE_LOADED:
            if (now - tile->stateChangeTime < 1000) {
                color = (now - tile->stateChangeTime) / 1000.0;
                color = sqrt(color);
            } else {
                color = 1.0;
            }

            glColor4f(color, color, color, 1.0);
            glBindTexture(GL_TEXTURE_2D, tile->texture);
            setQuadSize(TILE_SIZE, TILE_SIZE, quadVertices);
            glVertexPointer(3, GL_FLOAT, 0, quadVertices);
            glTexCoordPointer(2, GL_FLOAT, 0, texCoords[0]);
            glDrawArrays(GL_TRIANGLE_STRIP, 0, 4);
            break;
        case STATE_TEXTURE_BIND_WAIT:
        case STATE_SCALED_LOADING:
            break;
    }
}

SDL_Surface* loadTextureFromFile(char *filename);
GLuint createTexture(SDL_Surface* surfaceRGB, int enableBlending);

typedef struct {
    GLuint name;
    int size;
} Texture;

Texture crosshair = { 0, -1 }, fontMediumMask, fontMedium;

char buf[500];

void loadTexture(Texture* texture, char* filename) {
    SDL_Surface* textureRGB = NULL;
    fprintf(stderr, "loading texture from %s\n", filename);
    textureRGB = loadTextureFromFile(filename);
    if (textureRGB != NULL) {
        texture -> name = createTexture(textureRGB, TRUE);
        texture -> size = textureRGB -> w;
        SDL_FreeSurface(textureRGB);
    } else {
        fprintf(stderr, "loadTexture returned NULL\n");
    }
}

void drawString(char* str, GLfloat r, GLfloat g, GLfloat b) {
    int i, len, charTileSize, xpos = 0;
//    int j;
    len = strlen(str);
    GLfloat *vertices, *fontTextureCoords;

    int tx, ty;

    if (len == 0) {
        return;
    }

    charTileSize = fontMediumMask.size / 16;
    setQuadSize(charTileSize, charTileSize, quadVertices);

    vertices = malloc(sizeof(GLfloat) * (len) * 18);
    fontTextureCoords = malloc(sizeof(GLfloat) * len * 12);



    for (i = 0; i < len; i++) {
        //        fprintf(stderr, "------------------------------\ni = %d\n", i);
        vertices[i * 18] = xpos;
        vertices[i * 18 + 1] = 0;
        vertices[i * 18 + 2] = 0;

        vertices[i * 18 + 3] = xpos;
        vertices[i * 18 + 4] = charTileSize;
        vertices[i * 18 + 5] = 0;

        vertices[i * 18 + 6] = xpos + charTileSize;
        vertices[i * 18 + 7] = charTileSize;
        vertices[i * 18 + 8] = 0;

        vertices[i * 18 + 9] = xpos;
        vertices[i * 18 + 10] = 0;
        vertices[i * 18 + 11] = 0;

        vertices[i * 18 + 12] = xpos + charTileSize;
        vertices[i * 18 + 13] = charTileSize;
        vertices[i * 18 + 14] = 0;

        vertices[i * 18 + 15] = xpos + charTileSize;
        vertices[i * 18 + 16] = 0;
        vertices[i * 18 + 17] = 0;

        xpos += MEDIUM_FONT_METRICS[(int)str[i]];
//        fprintf(stderr, "Width of '%c' is %d. xpos = %d\n", str[i], MEDIUM_FONT_METRICS[(int)str[i]], xpos);

        //        for (j = 0; j < 18; j++) {
        //            fprintf(stderr, "vertices[%d] = %g\n", i * 18 + j, vertices[i * 18 + j]);
        //        }

        tx = (str[i] % 16) * charTileSize;
        ty = str[i] / 16 * charTileSize;

        fontTextureCoords[i * 12 + 0] = tx / (GLfloat) fontMediumMask.size;
        fontTextureCoords[i * 12 + 1] = ty / (GLfloat) fontMediumMask.size;

        fontTextureCoords[i * 12 + 2] = tx / (GLfloat) fontMediumMask.size;
        fontTextureCoords[i * 12 + 3] = (ty + charTileSize) / (GLfloat) fontMediumMask.size;

        fontTextureCoords[i * 12 + 4] = (tx + charTileSize) / (GLfloat) fontMediumMask.size;
        fontTextureCoords[i * 12 + 5] = (ty + charTileSize) / (GLfloat) fontMediumMask.size;

        fontTextureCoords[i * 12 + 6] = tx / (GLfloat) fontMediumMask.size;
        fontTextureCoords[i * 12 + 7] = ty / (GLfloat) fontMediumMask.size;

        fontTextureCoords[i * 12 + 8] = (tx + charTileSize) / (GLfloat) fontMediumMask.size;
        fontTextureCoords[i * 12 + 9] = (ty + charTileSize) / (GLfloat) fontMediumMask.size;

        fontTextureCoords[i * 12 + 10] = (tx + charTileSize) / (GLfloat) fontMediumMask.size;
        fontTextureCoords[i * 12 + 11] = ty / (GLfloat) fontMediumMask.size;

        //        for (j = 0; j < 12; j++) {
        //            fprintf(stderr, "textureCoords[%d] = %g\n", i * 12 + j, fontTextureCoords[i * 12 + j]);
        //        }
    }

    glBlendFunc(GL_DST_COLOR, GL_ZERO);
    glColor4f(1.0, 1.0, 1.0, 1.0);
    glBindTexture(GL_TEXTURE_2D, fontMediumMask.name);
    glVertexPointer(3, GL_FLOAT, 0, vertices);
    glTexCoordPointer(2, GL_FLOAT, 0, fontTextureCoords);
    glDrawArrays(GL_TRIANGLES, 0, len * 6);


    glColor4f(r, g, b, 1.0);
    glBlendFunc(GL_ONE, GL_ONE_MINUS_SRC_ALPHA);
    glBindTexture(GL_TEXTURE_2D, fontMedium.name);
    glVertexPointer(3, GL_FLOAT, 0, vertices);
    glTexCoordPointer(2, GL_FLOAT, 0, fontTextureCoords);
    glDrawArrays(GL_TRIANGLES, 0, len * 6);


    free(vertices);
    free(fontTextureCoords);
}

void initUI() {
    loadTexture(&crosshair, "/opt/cloudgps2/res/crosshair.png");
    loadTexture(&fontMedium, "/opt/cloudgps2/res/font-medium.png");
    loadTexture(&fontMediumMask, "/opt/cloudgps2/res/font-medium-mask.png");
}

void drawUI() {
    if (crosshair.size == -1) {
        initUI();
    }

    glTranslatef(SCREEN_WIDTH / 2 - crosshair.size / 2, SCREEN_HEIGHT / 2 - crosshair.size / 2, 0);
    glEnable(GL_BLEND);

    // crosshair
    glBlendFunc(GL_DST_COLOR, GL_ZERO);
    glColor4f(1.0, 1.0, 1.0, 1.0);
    glBindTexture(GL_TEXTURE_2D, crosshair.name);
    setQuadSize(crosshair.size, crosshair.size, quadVertices);
    glVertexPointer(3, GL_FLOAT, 0, quadVertices);
    glTexCoordPointer(2, GL_FLOAT, 0, texCoords[0]);
    glDrawArrays(GL_TRIANGLE_STRIP, 0, 4);

    /* // crosshair
     glBlendFunc(GL_ONE, GL_ONE_MINUS_SRC_ALPHA);
     glBindTexture(GL_TEXTURE_2D, crosshairTexture);
     glVertexPointer(3, GL_FLOAT, 0, quadVertices);
     glTexCoordPointer(2, GL_FLOAT, 0, texCoords[0]);
     glDrawArrays(GL_TRIANGLE_STRIP, 0, 4);
     */
    glTranslatef(-SCREEN_WIDTH / 2 + crosshair.size / 2, -SCREEN_HEIGHT / 2 + crosshair.size / 2, 0);
}

GLfloat seconds;
GLfloat fps;

/* Here goes our drawing code */
int drawGLScene(GLvoid) {
    static GLint oldTicks = 0;
    static GLint frames = 0;
    int i, j;

    glClear(GL_COLOR_BUFFER_BIT);

    glLoadIdentity();
    glTranslatef((int) canvas.x - TILE_SIZE, (int) canvas.y - TILE_SIZE, 0.0f);

    glDisable(GL_ALPHA_TEST);
    glBlendFunc(GL_SRC_ALPHA, GL_ZERO);
    //glDisable(GL_BLEND);

    for (i = 0; i < TILES_X; i++) {
        for (j = 0; j < TILES_Y; j++) {
            glTranslatef(i * TILE_SIZE, j * TILE_SIZE, 0);
            drawTile(tiles[i][j][currentTilesIdx]);
            glTranslatef(-i * TILE_SIZE, -j * TILE_SIZE, 0);
        }
    }
    glTranslatef(-(int) canvas.x + TILE_SIZE, -(int) canvas.y + TILE_SIZE, 0.0f);

    drawUI();


    /* Gather our frames per second */
    frames++;
    {
        GLint t = SDL_GetTicks();
        if (t - oldTicks >= 1000) {
            seconds = (t - oldTicks) / 1000.0;
            fps = frames / seconds;
            oldTicks = t;
            frames = 0;
        }
        sprintf(buf, "%.1f FPS\n", fps);
        glTranslatef(SCREEN_WIDTH - 80, 0, 0);
        drawString(buf, 1.0, 0.0, 0.0);
    }

    /* Draw it to the screen */
    SDL_GLES_SwapBuffers();

    return (TRUE);
}
