/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Author: Damian Waradzyn
 */
void initInput() {
    mouse.x = -1;
    mouse.y = -1;
    mouse.button = -1;
    mouse.oldx = -1;
    mouse.oldy = -1;
    mouse.xdelta = 0;
    mouse.ydelta = 0;
    mouse.oldButton = -1;
    mouse.pressed = -1;
    mouse.moved = -1;
    SDL_EventState(SDL_MOUSEMOTION, SDL_IGNORE);
    SDL_EventState(SDL_MOUSEBUTTONDOWN, SDL_IGNORE);
    SDL_EventState(SDL_MOUSEBUTTONUP, SDL_IGNORE);
}

void processMouse() {

    mouse.oldx = mouse.x;
    mouse.oldy = mouse.y;
    mouse.oldButton = mouse.button;
    mouse.button = SDL_GetMouseState(&mouse.x, &mouse.y);

    if (mouse.button == 0) {
        mouse.pressed = -1;
        mouse.xdelta = 0;
        mouse.ydelta = 0;
    }

    if (mouse.button == 1 && mouse.oldButton == 0) {
        mouse.pressed = nowMillis;
    }

    if (mouse.oldButton == 1 && mouse.button == 1) {
        mouse.xdelta = mouse.x - mouse.oldx;
        mouse.ydelta = mouse.y - mouse.oldy;
        if (mouse.xdelta != 0 || mouse.ydelta != 0) {
            mouse.moved = nowMillis;
        }
    }
    tileEngineProcessMouse(processUiMouse());

}

void processKeyDown(SDL_KeyboardEvent key) {
    switch (key.keysym.sym) {
        case SDLK_g:
            options.showGrid = 1 - options.showGrid;
            break;
        case SDLK_h:
            options.showDebugTiles = 1 - options.showDebugTiles;
            break;
        case SDLK_c:
            options.showCoordinates = 1 - options.showCoordinates;
            break;
        case SDLK_SPACE:
            canvas.followingMypos = 1 - canvas.followingMypos;
            break;
        case SDLK_x:
            options.accelerometerEnabled = 1 - options.accelerometerEnabled;
            accelerometer.performCalibration = TRUE;
            break;
        case SDLK_m:
            options.mipmapToggle = 1 - options.mipmapToggle;
            recreateTiles();
            break;
        case SDLK_n: {
            GList *provider = tileProviders;
            while (provider != NULL) {
                TileProvider *tileProvider = provider -> data;
                if (canvas.provider == tileProvider) {
                    if (provider -> next != NULL) {
                        canvas.provider = provider -> next -> data;
                    } else {
                        canvas.provider = tileProviders -> data;
                    }
//                    fprintf(stderr, "new provider: %s\n", canvas.provider -> name);
                    break;
                }
                provider = provider -> next;
            }
            recreateTiles();
        }
            break;
        default:
            //            fprintf(stderr, "unhandled key down: key name %s\n", SDL_GetKeyName(key.keysym.sym));
            break;
    }
}
void processKeyUp(SDL_KeyboardEvent key) {

}

void processKeyboard() {
    Uint8 *keys = SDL_GetKeyState(0);

    if (keys[SDLK_q]) {
        quit = TRUE;
    }

    if (keys[SDLK_LEFT]) {
        if (canvas.viewMode == VIEW_3D) {
            canvas.drotz += .2;
        } else {
            canvas.followingMypos = 0;
            canvas.dx += 0.2 * sin((canvas.rotz + 90 + 90 * options.orientation) * M_PI / 180.0);
            canvas.dy += 0.2 * cos((canvas.rotz + 90 + 90 * options.orientation) * M_PI / 180.0);
        }
    }
    if (keys[SDLK_RIGHT]) {
        if (canvas.viewMode == VIEW_3D) {
            canvas.drotz -= .2;
        } else {
            canvas.followingMypos = 0;
            canvas.dx += 0.2 * sin((canvas.rotz - 90 + 90 * options.orientation) * M_PI / 180.0);
            canvas.dy += 0.2 * cos((canvas.rotz - 90 + 90 * options.orientation) * M_PI / 180.0);
        }
    }
    if (keys[SDLK_UP]) {
        canvas.followingMypos = 0;
        canvas.dx += 0.2 * sin((canvas.rotz + 90 * options.orientation) * M_PI / 180.0);
        canvas.dy += 0.2 * cos((canvas.rotz + 90 * options.orientation) * M_PI / 180.0);
    }
    if (keys[SDLK_DOWN]) {
        canvas.followingMypos = 0;
        canvas.dx += 0.2 * sin((canvas.rotz + 180 + 90 * options.orientation) * M_PI / 180.0);
        canvas.dy += 0.2 * cos((canvas.rotz + 180 + 90 * options.orientation) * M_PI / 180.0);
    }
    if (keys[SDLK_KP_ENTER]) {
        tileEngineZoomIn();
    }
    if (keys[SDLK_PERIOD]) {
        tileEngineZoomOut();
    }

    //    if (keys[SDLK_a]) {
    //        if (canvas.viewMode == VIEW_3D) {
    //            if (canvas.destRotx < 50) {
    //                canvas.destRotx += .1;
    //            }
    //        }
    //    }
    //    if (keys[SDLK_z]) {
    //        if (canvas.viewMode == VIEW_3D) {
    //            if (canvas.destRotx > 0) {
    //                canvas.destRotx -= .1;
    //            }
    //        }
    //    }
}

int liqaccel_read(int *ax, int *ay, int *az);

void processAccelerometer() {
    if (accelerometer.performCalibration) {
        ocnt = 0;
    }
    liqaccel_read(&accelerometer.x, &accelerometer.y, &accelerometer.z);
    if (accelerometer.performCalibration) {
        accelerometer.calibrateX = accelerometer.x;
        accelerometer.calibrateY = accelerometer.y;
        accelerometer.calibrateZ = accelerometer.z;
        accelerometer.performCalibration = FALSE;
    }
    accelerometer.x -= accelerometer.calibrateX;
    accelerometer.y -= accelerometer.calibrateY;
    accelerometer.z -= accelerometer.calibrateZ;
    tileEngineProcessAccelerometer();
}
