/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Author: Damian Waradzyn
 */
SDL_GLES_Context *context;

void setQuadSize(GLfloat w, GLfloat h, GLfloat quad[12]) {
    quad[3] = w;
    quad[7] = h;
    quad[9] = w;
    quad[10] = h;
}

void setBoxSize(GLfloat w, GLfloat h, GLfloat box[12]) {
    box[4] = h;
    box[6] = w;
    box[7] = h;
    box[9] = w;
}

Texture fontMediumMask, fontMedium, barbg, barbgmask;

const int MEDIUM_FONT_METRICS[256] = { 8, 8, 8, 8, 8, 8, 8, 8, 8, 56, 0, 8, 8, 0, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 4, 5, 5, 11,
        8, 12, 11, 3, 5, 5, 7, 11, 4, 5, 4, 4, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 4, 4, 11, 11, 11, 7, 13, 9, 9, 9, 10, 8, 7, 10, 10, 3, 3, 8, 7, 11, 10,
        10, 8, 10, 8, 9, 7, 10, 9, 11, 10, 7, 10, 5, 4, 5, 11, 7, 7, 8, 8, 7, 8, 8, 4, 8, 8, 3, 3, 7, 3, 13, 8, 8, 8, 8, 5, 7, 5, 8, 7, 9, 7, 7, 7,
        8, 4, 8, 11, 8, 8, 8, 4, 8, 7, 13, 7, 7, 7, 17, 9, 5, 14, 8, 10, 8, 8, 4, 4, 7, 7, 8, 7, 13, 7, 13, 7, 5, 13, 8, 7, 7, 8, 5, 8, 8, 8, 8, 4,
        7, 7, 13, 6, 8, 11, 5, 13, 7, 7, 11, 5, 5, 7, 8, 8, 4, 7, 5, 6, 8, 13, 13, 13, 7, 9, 9, 9, 9, 9, 9, 13, 9, 8, 8, 8, 8, 3, 3, 3, 3, 10, 10,
        10, 10, 10, 10, 10, 11, 10, 10, 10, 10, 10, 7, 8, 8, 8, 8, 8, 8, 8, 8, 13, 7, 8, 8, 8, 8, 3, 3, 3, 3, 8, 8, 8, 8, 8, 8, 8, 11, 8, 8, 8, 8, 8,
        7, 8, 7 };

GLfloat boxVertices[12] = { 0.0f, 0.0f, 0.0f, 0.0f, 256.0f, 0.0f, 256.0f, 256.0f, 0.0f, 256.0f, 0.0f, 0.0f, };

GLfloat fakeFogColorsLandscape[16] = { 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.01f, 0.0f, 0.0f, 0.0f, 0.01f };
GLfloat fakeFogColorsPortrait[16] = { 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.01f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.01f };

int debugTilesGridInitialized = FALSE;
GLfloat debugTilesGrid[(TILES_X + TILES_Y + 2) * 3 * 2];

GLfloat quadVertices[12] = { 0.0f, 0.0f, 0.0f, /* Bottom Left Of The Quad */
1.0f, 0.0f, 0.0f, /* Bottom Right Of The Quad */
0.0f, 1.0f, 0.0f, /* Top Left Of The Quad */
1.0f, 1.0f, 0.0f, /* Top Right Of The Quad */
};

GLfloat texCoordsLandscape[][8] = { { 0.0f, 0.0f, /* Bottom Left Of The Texture */
1.0f, 0.0f, /* Bottom Right Of The Texture */
0.0f, 1.0f, /* Top Left Of The Texture */
1.0f, 1.0f, /* Top Right Of The Texture */
} };

GLfloat texCoordsPortrait[][8] = { { 1.0f, 0.0f, /* Top Right Of The Texture */
1.0f, 1.0f, /* Bottom Right Of The Texture */
0.0f, 0.0f, /* Bottom Left Of The Texture */
0.0f, 1.0f, /* Top Left Of The Texture */

} };

SDL_Surface* loadTextureFromFile(char *filename, t_tile* tile);

GLuint createTexture(GLushort * pixels4444, int w, int h, int isTile);

char buf[500];

int stringWidth(char * str) {
    int result = 0, i = 0;
    while (str[i] != '\0') {
        result += MEDIUM_FONT_METRICS[(int) str[i]];
        i++;
    }
    return result;
}

void drawString(char* str, GLfloat r, GLfloat g, GLfloat b, int useMask) {
    int i, len, charTileSize, xpos = 0;
    //    int j;
    len = strlen(str);
    GLfloat *vertices, *fontTextureCoords;

    int tx, ty;

    if (len == 0) {
        return;
    }

    charTileSize = fontMediumMask.size / 16;
    setQuadSize(charTileSize, charTileSize, quadVertices);

    vertices = malloc(sizeof(GLfloat) * (len) * 18);
    fontTextureCoords = malloc(sizeof(GLfloat) * len * 12);

    for (i = 0; i < len; i++) {
        //        fprintf(stderr, "------------------------------\ni = %d\n", i);
        vertices[i * 18] = xpos;
        vertices[i * 18 + 1] = 0;
        vertices[i * 18 + 2] = 0;

        vertices[i * 18 + 3] = xpos;
        vertices[i * 18 + 4] = charTileSize;
        vertices[i * 18 + 5] = 0;

        vertices[i * 18 + 6] = xpos + charTileSize;
        vertices[i * 18 + 7] = charTileSize;
        vertices[i * 18 + 8] = 0;

        vertices[i * 18 + 9] = xpos;
        vertices[i * 18 + 10] = 0;
        vertices[i * 18 + 11] = 0;

        vertices[i * 18 + 12] = xpos + charTileSize;
        vertices[i * 18 + 13] = charTileSize;
        vertices[i * 18 + 14] = 0;

        vertices[i * 18 + 15] = xpos + charTileSize;
        vertices[i * 18 + 16] = 0;
        vertices[i * 18 + 17] = 0;

        xpos += MEDIUM_FONT_METRICS[(int) str[i]];
        //        fprintf(stderr, "Width of '%c' is %d. xpos = %d\n", str[i], MEDIUM_FONT_METRICS[(int)str[i]], xpos);

        //        for (j = 0; j < 18; j++) {
        //            fprintf(stderr, "vertices[%d] = %g\n", i * 18 + j, vertices[i * 18 + j]);
        //        }

        tx = (str[i] % 16) * charTileSize;
        ty = str[i] / 16 * charTileSize;

        fontTextureCoords[i * 12 + 0] = tx / (GLfloat) fontMediumMask.size;
        fontTextureCoords[i * 12 + 1] = ty / (GLfloat) fontMediumMask.size;

        fontTextureCoords[i * 12 + 2] = tx / (GLfloat) fontMediumMask.size;
        fontTextureCoords[i * 12 + 3] = (ty + charTileSize) / (GLfloat) fontMediumMask.size;

        fontTextureCoords[i * 12 + 4] = (tx + charTileSize) / (GLfloat) fontMediumMask.size;
        fontTextureCoords[i * 12 + 5] = (ty + charTileSize) / (GLfloat) fontMediumMask.size;

        fontTextureCoords[i * 12 + 6] = tx / (GLfloat) fontMediumMask.size;
        fontTextureCoords[i * 12 + 7] = ty / (GLfloat) fontMediumMask.size;

        fontTextureCoords[i * 12 + 8] = (tx + charTileSize) / (GLfloat) fontMediumMask.size;
        fontTextureCoords[i * 12 + 9] = (ty + charTileSize) / (GLfloat) fontMediumMask.size;

        fontTextureCoords[i * 12 + 10] = (tx + charTileSize) / (GLfloat) fontMediumMask.size;
        fontTextureCoords[i * 12 + 11] = ty / (GLfloat) fontMediumMask.size;

        //        for (j = 0; j < 12; j++) {
        //            fprintf(stderr, "textureCoords[%d] = %g\n", i * 12 + j, fontTextureCoords[i * 12 + j]);
        //        }
    }
    if (useMask) {
        glEnable(GL_BLEND);
        glBlendFunc(GL_DST_COLOR, GL_ZERO);
        glColor4f(1.0, 1.0, 1.0, 1.0);
        glBindTexture(GL_TEXTURE_2D, fontMediumMask.name);
        glVertexPointer(3, GL_FLOAT, 0, vertices);
        glTexCoordPointer(2, GL_FLOAT, 0, fontTextureCoords);
        glDrawArrays(GL_TRIANGLES, 0, len * 6);
    }

    glColor4f(r, g, b, 1.0);
    glBlendFunc(GL_ONE, GL_ONE_MINUS_SRC_ALPHA);
    glBindTexture(GL_TEXTURE_2D, fontMedium.name);
    glVertexPointer(3, GL_FLOAT, 0, vertices);
    glTexCoordPointer(2, GL_FLOAT, 0, fontTextureCoords);
    glDrawArrays(GL_TRIANGLES, 0, len * 6);

    free(vertices);
    free(fontTextureCoords);
}

#include "uielement.c"

float color = 1.0;

void drawBoundingBox() {
    glDisable(GL_BLEND);
    glBindTexture(GL_TEXTURE_2D, 0);
    glColor4f(0, 0, 1, 1.0f);

    GLfloat boundingTrapezoidVertices[12] = {
    // first point:
            (canvas.boundingTrapezoid[0].tilex - canvas.tilex) * TILE_SIZE + canvas.boundingTrapezoid[0].x, (canvas.boundingTrapezoid[0].tiley
                    - canvas.tiley) * TILE_SIZE + canvas.boundingTrapezoid[0].y, 0,
            // second point:
            (canvas.boundingTrapezoid[1].tilex - canvas.tilex) * TILE_SIZE + canvas.boundingTrapezoid[1].x, (canvas.boundingTrapezoid[1].tiley
                    - canvas.tiley) * TILE_SIZE + canvas.boundingTrapezoid[1].y, 0,
            // third point:
            (canvas.boundingTrapezoid[2].tilex - canvas.tilex) * TILE_SIZE + canvas.boundingTrapezoid[2].x, (canvas.boundingTrapezoid[2].tiley
                    - canvas.tiley) * TILE_SIZE + canvas.boundingTrapezoid[2].y, 0,
            // fourth point:
            (canvas.boundingTrapezoid[3].tilex - canvas.tilex) * TILE_SIZE + canvas.boundingTrapezoid[3].x, (canvas.boundingTrapezoid[3].tiley
                    - canvas.tiley) * TILE_SIZE + canvas.boundingTrapezoid[3].y, 0, };

    glVertexPointer(3, GL_FLOAT, 0, boundingTrapezoidVertices);
    glDrawArrays(GL_LINE_LOOP, 0, 4);

}

void drawTile_debug(t_tile *tile) {
    switch (tile -> state) {
        case STATE_EMPTY:
            glColor4f(0,0,0, 0.5);
            break;
        case STATE_ERROR:
            glColor4f(1,0,0, 0.5);
            break;
        case STATE_LOADING:
            glColor4f(0,0,1, 0.5);
            break;
        case STATE_LOADED:
            glColor4f(0,1,0, 0.5);
            break;
        case STATE_GL_TEXTURE_NOT_CREATED:
            glColor4f(0,0.2,0, 0.5);
            break;
        case STATE_SCALED_LOADING:
            glColor4f(0.5,0.5,0.5, 0.5);
            break;
        case STATE_LOADED_SYNC_WAIT:
            glColor4f(1,0,1, 0.5);
            break;

    }
    glVertexPointer(3, GL_FLOAT, 0, quadVertices);
    glDrawArrays(GL_TRIANGLE_STRIP, 0, 4);

    //        sprintf(buf, "%d", tile -> state);
    //        glScalef(10.0, 10.0, 10.0);
    //        drawString(buf, 0.1f, .0, 1.0, TRUE);
    //        glScalef(.1, .1, .1);
}

void drawTile(t_tile* tile) {
    int i;

    switch (tile->state) {
        case STATE_EMPTY:
            //            glColor4f(0.0f, 0.0f, 1.0f, 1.0f);
            //            glVertexPointer(3, GL_FLOAT, 0, boxVertices[0]);
            //            glDrawArrays(GL_LINE_LOOP, 0, 4);
            break;
        case STATE_ERROR:
            glColor4f(1.0f, 0.0f, 0.0f, 1.0f);
            setBoxSize(TILE_SIZE, TILE_SIZE, boxVertices);
            glVertexPointer(3, GL_FLOAT, 0, boxVertices);
            glDrawArrays(GL_LINE_LOOP, 0, 4);
            if (tile -> errorMessage) {
                sprintf(buf, "Error: %s", tile->errorMessage);
                drawString(buf, 1.0f, .2, .2, TRUE);
            }

            break;
        case STATE_LOADING:
            //            glColor4f(0.0f, 1.0f, 0.0f, 1.0f);
            //            glVertexPointer(3, GL_FLOAT, 0, boxVertices[0]);
            //            glDrawArrays(GL_LINE_LOOP, 0, 4);
            break;

        case STATE_LOADED:
            //            tile -> transitionTime = 1500;
            if (nowMillis - tile->stateChangeTime < tile->transitionTime) {
                color = (nowMillis - tile->stateChangeTime) / (float) tile->transitionTime;
                //color = 1.0 - sqrt(sqrt(1.0 - color));
            } else {
                color = 1.0;
                int j, k, count;
                TDeallocationData *data = NULL;
                for (i = 0; i < 4; i++) {
                    if (tile->oldTexture[i]) {
                        count = 0;
                        if (i == 0) {
                            for (j = 0; j < TILES_X; j++) {
                                for (k = 0; k < TILES_Y; k++) {
                                    if (tiles[j][k][currentTilesIdx] -> visible && tiles[j][k][currentTilesIdx] -> oldTexture[0]
                                            == tile -> oldTexture[0]) {
                                        count++;
                                    }
                                }
                            }
                        }
//                        fprintf(stderr, "(%d, %d) texture = %d, oldpixels[%d] = %p, count = %d\n", tile->tilex, tile->tiley, tile -> oldTexture[i],
//                                i, tile -> oldPixels4444[i], count);
                        GLushort * oldpixels4444 = tile -> oldPixels4444[i];
                        if (count < 2) {
                            if (i == 0) {
                                for (j = 0; j < TILES_X; j++) {
                                    for (k = 0; k < TILES_Y; k++) {
                                        if (tiles[j][k][currentTilesIdx] -> oldPixels4444[0] == oldpixels4444) {
                                            tiles[j][k][currentTilesIdx] -> oldPixels4444[0] = NULL;
                                        }
                                    }
                                }
                            }

                            glDeleteTextures(1, &tile->oldTexture[i]);
                            if (data == NULL) {
                                data = calloc(1, sizeof(TDeallocationData));
                                data -> frame = frame;
                            }
                            data -> oldPixels4444[i] = oldpixels4444;
                        }
                        tile->oldTexture[i] = 0;

                        if (tile -> oldPixels4444[i] != NULL) {
//                            fprintf(stderr, "############################### 1\n");
                            tile -> oldPixels4444[i] = NULL;
                        }
                    }
                }
                if (data != NULL) {
                    g_queue_push_tail(deallocationQueue, data);
                }
            }

            if (color < 1.0) {
                setQuadSize(tile->oldTextureSize, tile->oldTextureSize, quadVertices);
                glEnable(GL_BLEND);
                glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
                for (i = 0; i < 4; i++) {
                    if (tile->oldTexture[i] > 0) {
                        glTranslatef(TILE_SIZE / 2 * (i / 2), TILE_SIZE / 2 * (i % 2), 0);
                        glColor4f(1.0, 1.0, 1.0, 1.0 - color);
                        glBindTexture(GL_TEXTURE_2D, tile->oldTexture[i]);
                        glVertexPointer(3, GL_FLOAT, 0, quadVertices);
                        glTexCoordPointer(2, GL_FLOAT, 0, tile->oldTextureCoords[i]);
                        glDrawArrays(GL_TRIANGLE_STRIP, 0, 4);
                        glTranslatef(-TILE_SIZE / 2 * (i / 2), -TILE_SIZE / 2 * (i % 2), 0);
                    }
                }
            } else {
                glDisable(GL_BLEND);
            }
            glColor4f(1.0, 1.0, 1.0, color);
            glBindTexture(GL_TEXTURE_2D, tile->texture);
            setQuadSize(TILE_SIZE, TILE_SIZE, quadVertices);
            glVertexPointer(3, GL_FLOAT, 0, quadVertices);
            glTexCoordPointer(2, GL_FLOAT, 0, texCoordsLandscape[0]);
            glDrawArrays(GL_TRIANGLE_STRIP, 0, 4);
            break;

        case STATE_LOADED_SYNC_WAIT:
        case STATE_SCALED_LOADING:
            glDisable(GL_BLEND);
            setQuadSize(tile->oldTextureSize, tile->oldTextureSize, quadVertices);
            for (i = 0; i < 4; i++) {
                if (tile->oldTexture[i] > 0) {
                    glTranslatef(TILE_SIZE / 2 * (i / 2), TILE_SIZE / 2 * (i % 2), 0);
                    glColor4f(1.0, 1.0, 1.0, 1.0);
                    glBindTexture(GL_TEXTURE_2D, tile->oldTexture[i]);
                    glVertexPointer(3, GL_FLOAT, 0, quadVertices);
                    glTexCoordPointer(2, GL_FLOAT, 0, tile->oldTextureCoords[i]);
                    glDrawArrays(GL_TRIANGLE_STRIP, 0, 4);
                    glTranslatef(-TILE_SIZE / 2 * (i / 2), -TILE_SIZE / 2 * (i % 2), 0);
                }
            }
            break;
        case STATE_GL_TEXTURE_NOT_CREATED:
            //            fprintf(stderr, "internal error: trying to draw tile in state STATE_GL_TEXTURE_NOT_CREATED\n");
            break;
    }
    if (options.showGrid) {
        glDisable(GL_BLEND);
        setBoxSize(TILE_SIZE, TILE_SIZE, boxVertices);
        glBindTexture(GL_TEXTURE_2D, 0);
        glColor4f(0.7f, .7f, 0.7f, 1.0f);
        glVertexPointer(3, GL_FLOAT, 0, boxVertices);
        glDrawArrays(GL_LINE_LOOP, 0, 4);

        sprintf(buf, "%d, %d", tile->tilex, tile -> tiley);
        drawString(buf, 0.1f, .0, 1.0, TRUE);
    }
}

/* general OpenGL initialization function */
int initGL(GLvoid) {
    SDL_GLES_Init(SDL_GLES_VERSION_1_1);

    context = SDL_GLES_CreateContext();
    SDL_GLES_MakeCurrent(context);

    glEnable(GL_TEXTURE_2D);

    glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
    glEnable(GL_CLEAR);

    glEnableClientState(GL_VERTEX_ARRAY);
    glEnableClientState(GL_TEXTURE_COORD_ARRAY);

    glMatrixMode(GL_PROJECTION);
    glDisable(GL_DEPTH_TEST);
    glDisable(GL_CULL_FACE);
    glViewport(0, 0, (GLint) SCREEN_WIDTH, (GLint) SCREEN_HEIGHT);
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    glFrustumf(-200, 200, 120, -120, 50.0, 600);
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();

    //    GLfloat fogColor[4] = { 0.0f, 0.0f, 0.0f, 1.0f };
    //    glFogx(GL_FOG_MODE, GL_LINEAR); // Fog Mode
    //    glFogfv(GL_FOG_COLOR, fogColor); // Set Fog Color
    //    glFogf(GL_FOG_DENSITY, .1f); // How Dense Will The Fog Be
    //    glHint(GL_FOG_HINT, GL_FASTEST); // Fog Hint Value
    //    glFogf(GL_FOG_START, 100.0f); // Fog Start Depth
    //    glFogf(GL_FOG_END, 400.0f); // Fog End Depth
    //    glEnable(GL_FOG);
    //    const GLubyte *extensions = glGetString(GL_EXTENSIONS);
    //    fprintf(stderr, "GL extensions: %s\n", (const char*) extensions);

    return (TRUE);
}

GLfloat seconds;

void setupGlScene() {
    int pixelPerfect;

    glClear(GL_COLOR_BUFFER_BIT);

    glLoadIdentity();

    GLfloat scale = canvas.scale;
    if (fabs(canvas.rotx) > 0.1) {
        scale += fabs(canvas.rotx) / 35.0;
    }
    if (fabs(canvas.roty) > 0.1) {
        scale += fabs(canvas.roty) / 25.0;
    }
    glTranslatef(-(scale - 1.0) * SCREEN_WIDTH / 2 - SCREEN_WIDTH / 2, -(scale - 1.0) * SCREEN_HEIGHT / 2 - SCREEN_HEIGHT / 2, -100.0f);
    glScalef(scale, scale, scale);

    glTranslatef(SCREEN_WIDTH / 2, SCREEN_HEIGHT / 2, 0);
    if (fabs(canvas.rotx) < 0.01 && (fabs(canvas.rotz) < 0.01 || fabs(canvas.rotz + 90.0) < 0.01) && fabs(canvas.roty) < 0.01) {
        glRotatef(canvas.rotz, 0.0, 0.0, 1.0);
        pixelPerfect = TRUE;
    } else {
        glRotatef(canvas.rotx, 1.0, 0.0, 0.0);
        glRotatef(canvas.roty, 0.0, 1.0, 0.0);
        glRotatef(canvas.rotz, 0.0, 0.0, 1.0);
        pixelPerfect = FALSE;
    }
    glTranslatef(-SCREEN_WIDTH / 2, -SCREEN_HEIGHT / 2, 0);

    if (canvas.scale - 1.0 < 0.01 && pixelPerfect) {
        // for pixel perfect representation of tiles in 2d mode
        glTranslatef((int) canvas.x - TILE_SIZE, (int) canvas.y - TILE_SIZE, 0.0f);
    } else {
        glTranslatef(canvas.x - TILE_SIZE, canvas.y - TILE_SIZE, 0.0f);
    }

    glGetFloatv(GL_PROJECTION_MATRIX, projectionMatrix);
    glGetFloatv(GL_MODELVIEW_MATRIX, modelMatrix);
    glGetIntegerv(GL_VIEWPORT, viewPort);
}

void drawGLScene() {
    static GLint oldTicks = 0;
    static GLint frames = 0;
    int i, j;

    for (i = 0; i < TILES_X; i++) {
        for (j = 0; j < TILES_Y; j++) {
            if (tiles[i][j][currentTilesIdx] -> visible == TRUE) {
                glTranslatef((i - getCanvasShiftX()) * TILE_SIZE, (j - getCanvasShiftY()) * TILE_SIZE, 0);
                drawTile(tiles[i][j][currentTilesIdx]);
                glTranslatef(-(i - getCanvasShiftX()) * TILE_SIZE, -(j - getCanvasShiftY()) * TILE_SIZE, 0);
            }
        }
    }

    if (position -> status != UI_HIDDEN) {
        drawUiElement(position);
    }

    if (options.showDebugTiles) {
        glLoadIdentity();
        glTranslatef(300, 0, -100);
        glScalef(0.05, 0.05, 0.05);

        glEnable(GL_BLEND);
        glBlendFunc(GL_ONE, GL_ONE_MINUS_SRC_ALPHA);
        setQuadSize(TILE_SIZE, TILE_SIZE, quadVertices);
        glBindTexture(GL_TEXTURE_2D, 0);

        glTranslatef(-getCanvasShiftX() * TILE_SIZE, -getCanvasShiftY() * TILE_SIZE, 0);

        for (i = 0; i < TILES_X; i++) {
            for (j = 0; j < TILES_Y; j++) {
                glTranslatef(i * TILE_SIZE, j * TILE_SIZE, 0);
                drawTile_debug(tiles[i][j][currentTilesIdx]);
                glTranslatef(-i * TILE_SIZE, -j * TILE_SIZE, 0);
            }
        }

        if (!debugTilesGridInitialized) {
            for (i = 0; i < TILES_X + 1; i++) {
                debugTilesGrid[i * 6] = i * TILE_SIZE;
                debugTilesGrid[i * 6 + 1] = 0.0;
                debugTilesGrid[i * 6 + 2] = 0.0;

                debugTilesGrid[i * 6 + 3] = i * TILE_SIZE;
                debugTilesGrid[i * 6 + 4] = TILES_Y * TILE_SIZE;
                debugTilesGrid[i * 6 + 5] = 0.0;
            }

            for (i = 0; i < TILES_Y + 1; i++) {
                debugTilesGrid[(i + TILES_X + 1) * 6] = 0.0;
                debugTilesGrid[(i + TILES_X + 1) * 6 + 1] = i * TILE_SIZE;
                debugTilesGrid[(i + TILES_X + 1) * 6 + 2] = 0.0;

                debugTilesGrid[(i + TILES_X + 1) * 6 + 3] = TILES_X * TILE_SIZE;
                debugTilesGrid[(i + TILES_X + 1) * 6 + 4] = i * TILE_SIZE;
                debugTilesGrid[(i + TILES_X + 1) * 6 + 5] = 0.0;
            }
            debugTilesGridInitialized = TRUE;
        }
        glColor4f(0.4, 0.4, 0.4, .7);
        glVertexPointer(3, GL_FLOAT, 0, debugTilesGrid);
        glDrawArrays(GL_LINES, 0, (TILES_X + TILES_Y + 2) * 2);

        drawBoundingBox();
        glScalef(20, 20, 20);
//        struct mallinfo meminfo = mallinfo();
//        glTranslatef(-30, 175, 0);
//        sprintf(buf, "mem: %.3f MB", meminfo.uordblks / 1024.0 / 1024.0);
//        drawString(buf, 1.0, 0, 0, TRUE);

    }

    glLoadIdentity();
    glTranslatef(-SCREEN_WIDTH / 2, -SCREEN_HEIGHT / 2, -100);

    glEnable(GL_BLEND);
    glBindTexture(GL_TEXTURE_2D, 0);
    glBlendFunc(GL_SRC_COLOR, GL_ZERO);
    //     landscape fake fog
    if (fabs(canvas.rotx) > 0.01) {
        glTranslatef(0, -((LANDSCAPE_ROTATION_X - canvas.rotx) / LANDSCAPE_ROTATION_X) * 200, 0);
        glEnableClientState(GL_COLOR_ARRAY);
        glColorPointer(4, GL_FLOAT, 0, fakeFogColorsLandscape);
        setQuadSize(SCREEN_WIDTH, 200, quadVertices);
        glVertexPointer(3, GL_FLOAT, 0, quadVertices);
        glDrawArrays(GL_TRIANGLE_STRIP, 0, 4);
        glDisableClientState(GL_COLOR_ARRAY);
        glTranslatef(0, +((LANDSCAPE_ROTATION_X - canvas.rotx) / LANDSCAPE_ROTATION_X) * 200, 0);
    }

    // portrait fake fog
    if (fabs(canvas.roty) > 0.01) {
        GLfloat fogStart = ((PORTRAIT_ROTATION_Y + canvas.roty) / PORTRAIT_ROTATION_Y) * 250 - 50;
        if (fogStart < 0.0) {
            glColor4f(0.0, 0.0, 0.0, 1.0);
            setQuadSize(-fogStart, SCREEN_HEIGHT, quadVertices);
            glVertexPointer(3, GL_FLOAT, 0, quadVertices);
            glDrawArrays(GL_TRIANGLE_STRIP, 0, 4);
        }

        glTranslatef(-fogStart, 0, 0);
        glEnableClientState(GL_COLOR_ARRAY);
        glColorPointer(4, GL_FLOAT, 0, fakeFogColorsPortrait);
        setQuadSize(200, SCREEN_HEIGHT, quadVertices);
        glVertexPointer(3, GL_FLOAT, 0, quadVertices);
        glDrawArrays(GL_TRIANGLE_STRIP, 0, 4);
        glDisableClientState(GL_COLOR_ARRAY);
        glTranslatef(fogStart, 0, 0);
    }

    drawUiElems();
    drawStatusBar(LANDSCAPE);
    glLoadIdentity();
    glTranslatef(-SCREEN_WIDTH / 2, -SCREEN_HEIGHT / 2, -100);
    drawStatusBar(PORTRAIT);

    glLoadIdentity();
    glTranslatef(15, 15, -100);
    if (options.showCoordinates) {
        sprintf(buf, "%02.6f %02.6f", canvas.center.latitude, canvas.center.longitude);
        drawString(buf, 0.4, 0.4, 0.4, TRUE);
    }

    frames++;
    {
        GLint t = SDL_GetTicks();
        if (t - oldTicks >= 1000) {
            seconds = (t - oldTicks) / 1000.0;
            fps = frames / seconds;
            oldTicks = t;
            frames = 0;
            //            fprintf(stderr, "fps: %f\n", fps);
        }
    }

    SDL_GLES_SwapBuffers();
}
