#!/usr/bin/env python
##################################################################
##   Cleven  -  a user interface of aircrack-ng for the N900    ##
##################################################################
#                                                                #
# Copyright (c) 2011 Christos Zamantzas                          #
# Licenced under GPLv2                                           #
#                                                                # 
# Christos Zamantzas (Saturn) <christos.zamantzas@gmail.com>     #
#                                                                # 
# * name comes from http://www.thefreedictionary.com/cleave      #
##################################################################

Version = '2.4'
Build = '5'

import sys
import os
import string

import subprocess

from PyQt4.QtGui import *
from PyQt4.QtCore import *
from PyQt4.QtMaemo5 import *

from clevenStartupUI import *
from clevenMainUI import *
from clevenCaptureUI import *
from clevenDriversUI import *
from clevenDictionaryUI import *
from clevenKeysUI import *
from clevenManageCapturedUI import *

pathMain             = '/opt/cleven'                        # main path for the application
pathStorage          = '/home/user/.cleven'                 # storage path for the application
pathDrivers          = '%s/compat-wireless' % pathMain
pathReaver           = '/home/user/.reaver'                 # storage path for reaver
helperScript         = 'clevenHelper.sh'
folderKeys           = 'keys'
folderDictionaries   = 'dictionaries'
folderCapturedData   = 'capturedData'
reaverBinary         = 'reaver'
reaverDatabase       = 'reaver.db'
washBinary           = 'wash'

##############################################################

def showMessage(message):
    ''' Method to display a message to the user that waits for a confirmation. '''

    os.system('dbus-send --type=method_call --dest=org.freedesktop.Notifications \
               /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteDialog \
               string:"%s" uint32:0 string:"OK"' % message)          
  
def showQuickMessage(message):
    ''' Method to display a message to the user. '''

    os.system('dbus-send --type=method_call --dest=org.freedesktop.Notifications \
               /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint \
               string:"%s"' % message)          

class clevenMainWindow(QtGui.QMainWindow):

    def __init__(self, parent=None):
       QtGui.QWidget.__init__(self, parent)
       self.ui = Ui_clevenMainUI()
       self.ui.setupUi(self)
       self.setWindowTitle('Cleven %s-%s' % (Version, Build))
       self.setAttribute(Qt.WA_Maemo5AutoOrientation, True)
       self.setAttribute(Qt.WA_Maemo5StackedWindow, True)

       ##Connect Menu Buttons 
       QtCore.QObject.connect(self.ui.actionQuit,                    QtCore.SIGNAL('triggered()'), QtGui.qApp, QtCore.SLOT('quit()'))
       QtCore.QObject.connect(self.ui.actionAbout,                   QtCore.SIGNAL('triggered()'), self.showAboutWindow)
       
       ##Connect Push Buttons
       QtCore.QObject.connect(self.ui.pushButtonConfigureDrivers,    QtCore.SIGNAL('clicked()'), self.showConfigureDriversDialog)
       QtCore.QObject.connect(self.ui.pushButtonDecryptCaptured,     QtCore.SIGNAL('clicked()'), self.showDecryptWindow)
       QtCore.QObject.connect(self.ui.pushButtonShowKeys,            QtCore.SIGNAL('clicked()'), self.showKeysWindow)
       QtCore.QObject.connect(self.ui.pushButtonCapturePackets,      QtCore.SIGNAL('clicked()'), self.showCaptureWindow)
       QtCore.QObject.connect(self.ui.pushButtonDeleleCaptured,      QtCore.SIGNAL('clicked()'), self.showDeleteWindow)

       self.showStartupDialog()          ## (Un)comment for pop-up of the start-up dialog at start-up
       # self.showConfigureDriversDialog() ## (Un)comment for pop-up of the configuration dialog at start-up  
       
    def showAboutWindow(self):
       self.aboutWin = clevenAbout(self)

    def showStartupDialog(self):
       StartupDialog = clevenStartup()
       StartupDialog.exec_()

    def showConfigureDriversDialog(self):
       DriverDialog = clevenConfigureDrivers()
       DriverDialog.exec_()

    def showKeysWindow(self):
       self.aboutWin = clevenShowKeys(self)

    def showCaptureWindow(self):
       self.aboutWin = clevenCapture(self)

    def showDecryptWindow(self):
       global deleteModeOn
       deleteModeOn = 'False'
       self.aboutWin =  clevenManageCaptured(self)       
       
    def showDeleteWindow(self):
       global deleteModeOn
       deleteModeOn = 'True'
       self.aboutWin = clevenManageCaptured(self)
       
class clevenCapture(QtGui.QMainWindow):

    def __init__(self, parent=None):
    
       ##Build the parent user interface
       QtGui.QMainWindow.__init__(self, parent)
       self.ui = Ui_clevenCaptureUI()
       self.ui.setupUi(self)
       self.setAttribute(Qt.WA_Maemo5AutoOrientation, True)
       self.setAttribute(Qt.WA_Maemo5StackedWindow, True)
       self.show()       

       ##Access Point
       QtCore.QObject.connect(self.ui.scanButton,  QtCore.SIGNAL('clicked()'), self.scanNetworks)
       QtCore.QObject.connect(self.ui.wepRadio,    QtCore.SIGNAL('clicked()'), self.displayNetworks)
       QtCore.QObject.connect(self.ui.wpaRadio,    QtCore.SIGNAL('clicked()'), self.displayNetworks)
       QtCore.QObject.connect(self.ui.wpsRadio,    QtCore.SIGNAL('clicked()'), self.displayNetworks)
       QtCore.QObject.connect(self.ui.scanList,    QtCore.SIGNAL('itemSelectionChanged()'), self.displayNetworkInformation)

       ##Capture of packets
       QtCore.QObject.connect(self.ui.captureButton,        QtCore.SIGNAL('clicked()'), self.executeCapture)
       QtCore.QObject.connect(self.ui.authenticateButton,   QtCore.SIGNAL('clicked()'), self.executeAuthenticate)
       QtCore.QObject.connect(self.ui.deauthenticateButton, QtCore.SIGNAL('clicked()'), self.executeDeauthenticate)
       QtCore.QObject.connect(self.ui.injectionButton,      QtCore.SIGNAL('clicked()'), self.executeInjection)
       QtCore.QObject.connect(self.ui.reaverButton,         QtCore.SIGNAL('clicked()'), self.executeReaver)

       if reaverAvailability == False:
          self.ui.reaverButton.setHidden(True)
       if washAvailability == False:
          self.ui.wpsRadio.setHidden(True)
       
       self.ui.captureButton.setEnabled(False)
       self.ui.reaverButton.setEnabled(False)
       
       self.ui.injectionButton.setHidden(True)
       self.ui.authenticateButton.setHidden(True)
       self.ui.deauthenticateButton.setHidden(True)

       ##Show some info in the UI
       self.ui.textBrowser.clear()
       self.ui.textBrowser.append('Scan first for available networks')
       self.ui.textBrowser.append('then choose WEP or WPA')
       
    def scanNetworks(self):
       '''Initiate scanning for available networks'''
       
       # print driverStateInjection, interfaceStateMonitor

       ##Clean the interface
       self.ui.scanList.clear()
       self.ui.textBrowser.clear()
       ##Check first if the correct drivers are loaded and the interface is in monitor mode
       if driverStateInjection == 'False' or interfaceStateMonitor == 'False':
          message ='ERROR: Cannot scan for available networks.\n\nThe drivers or the interface are not to the correct state.\nPlease configure them from the available menu option.'
          showMessage(message) 
       else:
          duration = str(self.ui.durationSpin.value())
        
          message ='Scanning for available networks.\nPlease wait..'
          showQuickMessage(message) 
          
          os.system('sudo %s/%s getWlanInformation %s %s' % (pathMain, helperScript, pathStorage, duration))
          message ='Scan for available networks completed!\nChoose WEP or WPA..'
          showQuickMessage(message)

       self.ui.textBrowser.append(message)

    def displayNetworks(self): #FIXME: read ESSIDs directly and not from the file.
       '''Show available networks in the UI.'''

       message ='Showing available networks.'
       showQuickMessage(message)
       
       ##Clean the interface
       self.ui.scanList.clear()
       self.ui.textBrowser.clear()
       self.ui.textBrowser.append('Select network from the list')
       self.ui.captureButton.setEnabled(False)
       self.ui.reaverButton.setEnabled(False)
       self.ui.injectionButton.setHidden(True)
       self.ui.authenticateButton.setHidden(True)
       self.ui.deauthenticateButton.setHidden(True)

       if self.ui.wepRadio.isChecked():
          encryption = "WEP"
       else:
          encryption = "WPA"      

       if self.ui.wpsRadio.isChecked(): ##FIX splitting for new version of wash
          values = []
          rValues = os.popen('sudo %s/%s wash' %(pathMain, helperScript)).read()
          rValues = rValues.split("\n")                     ##split them to create an entry for each in the list
          rValues = filter(None, rValues)                   ##remove unknown (empty)
          for i in rValues:                                 ##iterate on the values stored in the list
             newList = i.split()                            ##split each line into a list
             newValue = newList[4]                          ##keep the 5th element only
             values.append(newValue)                        ##append the AP into a new list
          # print 'The WPS clean list is:\n',values
       else:
          values = os.popen('sudo %s/%s readESSIDs %s %s' %(pathMain, helperScript, pathStorage, encryption)).read()
          values = values.lstrip(" ")                       ##remove trailing space from first ESSID
          values = values.replace("\n ","\n")               ##remove trailing space from the rest of the ESSIDs 
          values = values.split("\n")                       ##split them to create an entry for each in the list
          # print 'The WEP/WPA list is:\n',values

       values = filter(None, values)                        ##remove unknown (hidden)
       values.sort(key=str.lower)                           ##sort them by name.
       # print 'The final list is:\n',values
       self.ui.scanList.addItems(values)

    def displayNetworkInformation(self): #FIXME: read wlan info directly and not from a file.

       global essid, bssid, channel, encryption, power, essid_clean

       self.ui.captureButton.setEnabled(True)
       self.ui.captureButton.setHidden(False)
       if self.ui.wepRadio.isChecked() == False:
          if reaverAvailability:
             self.ui.reaverButton.setEnabled(True)
             self.ui.reaverButton.setHidden(False)
       
       if self.ui.scanList.currentRow() == -1:
          self.ui.textBrowser.clear()
          self.ui.captureButton.setEnabled(False)
          self.ui.reaverButton.setEnabled(False)
          return
          
       essid = self.ui.scanList.currentItem().text()
       # print '(taken from the list) ESSID: ',essid
       essidInfo = os.popen('sudo %s/%s readESSIDinfo %s \"%s\"' % (pathMain, helperScript, pathStorage, essid)).read().split("\n")
       
       essid      = essidInfo[0]
       bssid      = essidInfo[1]
       channel    = essidInfo[2]
       encryption = essidInfo[3]
       power      = essidInfo[4]

       essid      = essid.lstrip(" ").rstrip(" ")
       bssid      = bssid.strip()
       channel    = channel.strip()
       encryption = encryption.strip()
       power      = power.strip()
       
       self.ui.textBrowser.clear()
       self.ui.textBrowser.append('Name: ' + essid)
       self.ui.textBrowser.append('MAC: ' + bssid)
       self.ui.textBrowser.append('Ch: ' + channel + ', Priv.: ' + encryption + ', Pw: ' + power + 'dBm')
  
       essid_clean = essid
       character_list = [' ', '(', ')', '!', '$', '%', '^', '&', '*', '-', '+', '=', '#', '@', ';', ':', '?', '/', '>', '<'] 
       for i in character_list:
          essid_clean = essid_clean.replace(i,'_')
       print 'essid: ', essid, ' to essid (clean): ', essid_clean   
       
    def executeCapture(self):
       '''Opens an xterm window that captures the packets.'''
       
       global encryption
       
       ## disable buttons again if no row is selected and return.   
       if self.ui.scanList.currentRow() == -1: 
          self.ui.captureButton.setEnabled(False)
          self.ui.reaverButton.setEnabled(False)

          self.ui.authenticateButton.setEnabled(False)
          self.ui.injectionButton.setEnabled(False)
          self.ui.deauthenticateButton.setEnable(False)

          self.ui.injectionButton.setHidden(True)
          self.ui.authenticateButton.setHidden(True)
          self.ui.deauthenticateButton.setHidden(True)

          return

       ##Remove not needed buttons   
       self.ui.captureButton.setHidden(True)
       self.ui.captureButton.setEnabled(False)
       self.ui.reaverButton.setHidden(True)
       self.ui.reaverButton.setEnabled(False)
      
       if self.ui.wepRadio.isChecked():
          encryption = "WEP"

          self.ui.authenticateButton.setHidden(False)
          self.ui.injectionButton.setHidden(False)
          self.ui.deauthenticateButton.setHidden(False)

          self.ui.authenticateButton.setEnabled(True)
          self.ui.injectionButton.setEnabled(True)
          self.ui.deauthenticateButton.setEnabled(True)

       else:
          encryption = "WPA"

          self.ui.authenticateButton.setHidden(True)
          self.ui.injectionButton.setHidden(True)
          self.ui.deauthenticateButton.setHidden(False)
          
          self.ui.authenticateButton.setEnabled(False)
          self.ui.injectionButton.setEnabled(False)
          self.ui.deauthenticateButton.setEnabled(True)
          
       # print "capture options: ", channel, bssid, pathStorage, encryption, essid, essid_clean
       # os.system('osso-xterm -e "sudo %s/%s capture %s %s %s %s \"%s\" " &' % (pathMain, helperScript, channel, bssid, pathStorage, encryption, essid))
       os.system('osso-xterm -e "sudo %s/%s capture %s %s %s %s \"%s\" " &' % (pathMain, helperScript, channel, bssid, pathStorage, encryption, essid_clean))
      
    def executeDeauthenticate(self): #FIXME:: the essid should be the connected client's mac; atm ignoring essid and just broadcasting. 
       '''Opens an xterm window that sends deauthentication packets.'''
       
       # print "deauthenticate options: ", bssid, essid
       os.system('osso-xterm -e "sudo %s/%s deauthenticate %s \"%s\" " &' % (pathMain, helperScript, bssid, essid))

    def executeAuthenticate(self):
       '''Opens an xterm window that sends authentication packets.'''
       
       # print "authenticate options: ", essid, bssid, myMAC
       os.system('osso-xterm -e "sudo %s/%s authenticate %s %s" &' % (pathMain, helperScript, bssid, myMAC))

    def executeInjection(self):
       '''Opens an xterm window that sends injection packets.'''
       
       # print "injection options: ", bssid, myMAC
       os.system('osso-xterm -e "sudo %s/%s injection %s %s" &' % (pathMain, helperScript, bssid, myMAC))

    def executeReaver(self):
       '''Opens an xterm window that sends authentication packets.'''
       
       # print "reaver -i wlan0 -b ",bssid," -c ",channel," -e ",essid," -a -E -vv" 
       os.system('osso-xterm -e "sudo %s/%s reaver %s %s %s" &' % (pathMain, helperScript, bssid, channel, essid))
       
class clevenConfigureDrivers(QtGui.QDialog):

    def __init__(self, parent=None):
       ##Build the parent user interface
       QtGui.QDialog.__init__(self, parent)
       self.ui = Ui_clevenDriversUI()
       self.ui.setupUi(self)
       self.setAttribute(Qt.WA_Maemo5AutoOrientation, True)
       self.setAttribute(Qt.WA_Maemo5StackedWindow, True)
       
       ##Connect the buttons for the monitoring drivers
       QtCore.QObject.connect(self.ui.enableMonitor,     QtCore.SIGNAL('clicked()'), self.enableMonitor)
       QtCore.QObject.connect(self.ui.disableMonitor,    QtCore.SIGNAL('clicked()'), self.disableMonitor)
       QtCore.QObject.connect(self.ui.enableInjection,   QtCore.SIGNAL('clicked()'), self.enableInjection)
       QtCore.QObject.connect(self.ui.disableInjection,  QtCore.SIGNAL('clicked()'), self.disableInjection)
       QtCore.QObject.connect(self.ui.macButton,         QtCore.SIGNAL('clicked()'), self.setMACinterfaceValue)
       QtCore.QObject.connect(self.ui.randomButton,      QtCore.SIGNAL('clicked()'), self.setMACrandomValue)
       QtCore.QObject.connect(self.ui.WLAN,              QtCore.SIGNAL('clicked()'), self.setConnectionBehaviour)
       QtCore.QObject.connect(self.ui.GPRS,              QtCore.SIGNAL('clicked()'), self.setConnectionBehaviour)
       QtCore.QObject.connect(self.ui.ANY,               QtCore.SIGNAL('clicked()'), self.setConnectionBehaviour)
       QtCore.QObject.connect(self.ui.ASK,               QtCore.SIGNAL('clicked()'), self.setConnectionBehaviour)
       
       ##Get and populate the UI with the current info 
       self.getKernelVersion()
       self.getDriversState()
       self.getInterfaceState()
       self.getConnectionBehaviour()
       self.getMAC()
       global myMAC
       myMAC = self.getMAC()

    def getKernelVersion(self):

       global kernelVersion
       kernelVersion = os.popen('uname -r').read().strip('\n').strip('')
       print kernelVersion
       
       if kernelVersion == '2.6.28.10power46-wl1':
          pass
       elif kernelVersion == '2.6.28.10-power47':
          pass
       elif kernelVersion == '2.6.28.10-power48':
          pass
       elif kernelVersion == '2.6.28.10-power49':
          pass
       else: 
          message = 'WARNING: The system did not find a known compatible kernel version for the injection drivers.\n\nThe application might not work properly..'
          showMessage(message)
    
    def getDriversState(self):
       '''Check the state of the Drivers (Stock/Bleeding)'''
       
       global driverStateInjection
       
       DRIVERS = os.popen('cat /proc/modules | grep wl12xx').read()
       
       if DRIVERS == '':
          driverStateInjection = 'True'
          self.ui.enableInjection.setHidden(True)
          self.ui.disableInjection.setHidden(False)
       else:
          driverStateInjection = 'False'
          self.ui.enableInjection.setHidden(False)
          self.ui.disableInjection.setHidden(True)

    def getInterfaceState(self):
       '''Check the state of the interface (Managed/Monitor)'''
       
       global interfaceStateMonitor
       MODE = os.popen('sudo %s/%s checkInterface' %(pathMain, helperScript)).read()
       
       if MODE == 'Monitor\n':
          interfaceStateMonitor = 'True'
          self.ui.disableMonitor.setHidden(False)
          self.ui.enableMonitor.setHidden(True)
       elif MODE == 'Managed\n':
          interfaceStateMonitor = 'False'
          self.ui.disableMonitor.setHidden(True)
          self.ui.enableMonitor.setHidden(False)

    def enableMonitor(self):
       '''Set the interface to Monitor mode'''
      
       message ='Setting the interface to MONITOR mode..'
       showQuickMessage(message)

       os.system('sudo %s/%s enableMode Monitor' %(pathMain, helperScript))
       self.getDriversState()
       self.getInterfaceState()
       self.getMAC()

    def disableMonitor(self):
       '''Set the interface to Managed mode'''

       message ='Setting the interface to MANAGED mode..'
       showQuickMessage(message)

       os.system('sudo %s/%s enableMode Managed' %(pathMain, helperScript))
       self.getDriversState()
       self.getInterfaceState()
       self.getMAC()

    def enableInjection(self):
       '''Load the injection drivers'''
      
       message ='Loading the injection drivers..'
       showQuickMessage(message)
       
       os.system('sudo %s/load.sh' % pathDrivers)
       self.getDriversState()
       self.getInterfaceState()
       self.getMAC()

    def disableInjection(self):
       '''Unload the injection drivers'''

       message ='Unloading the injection drivers..'
       showQuickMessage(message)

       os.system('sudo %s/unload.sh' % pathDrivers)
       self.getInterfaceState()
       self.getMAC()
       self.getDriversState()

    def getMAC(self):
       '''Get the MAC address defined on the device'''

       if self.ui.enableMonitor.isEnabled():
          ##interface is in Managed mode
          macList = os.popen('sudo %s/%s getMACmanaged' %(pathMain, helperScript)).read()
       else:
          ##interface is in Monitor mode 
          macList = os.popen('sudo %s/%s getMACmonitor' %(pathMain, helperScript)).read()
       
       myMAC = macList[0:17]
       myMAC = myMAC.replace('-',':')
       self.ui.macEdit.setText(myMAC)
       return myMAC

    def setMACrandomValue(self):
       '''Set a random MAC address on the device'''
       
       global myMAC
       message ='Setting a random MAC address..'
       showQuickMessage(message)
       os.system('sudo %s/%s setMACrandom' %(pathMain, helperScript))
       myMAC = self.getMAC()

    def setMACinterfaceValue(self):
       '''Set a user defined MAC address on the device'''
       
       global myMAC
       message ='Setting the UI defined MAC address..'
       showQuickMessage(message)
       newMAC = str(self.ui.macEdit.text())
       newMAC = newMAC.strip()
       os.system('sudo %s/%s setMACmanual %s' %(pathMain, helperScript, newMAC))
       myMAC = self.getMAC()

    def getConnectionBehaviour(self):
       '''Get current data connection behaviour.''' 

       Mode = os.popen('gconftool-2 -g --list-type string /system/osso/connectivity/network_type/auto_connect').read().strip('\n') 
       
       if Mode == '[]':
           self.ui.ASK.setChecked(True)
       elif Mode == '[*]':
           self.ui.ANY.setChecked(True)
       elif Mode == '[GPRS]':
           self.ui.GPRS.setChecked(True)    
       elif Mode == '[WLAN_INFRA]':
           self.ui.WLAN.setChecked(True)

    def setConnectionBehaviour(self):
       '''Set new data connection behaviour.'''

       ##Available options: [WLAN_INFRA], [GPRS], [*] <=='any', [] <=='ask'
       if self.ui.ASK.isChecked():
           String = ''
       elif self.ui.WLAN.isChecked():
           String = 'WLAN_INFRA'
       elif self.ui.GPRS.isChecked():        
           String = 'GPRS'
       elif self.ui.ANY.isChecked():
           String = '*'
          
       ##Set user requested value for the "Connect automatically" option 
       os.system('gconftool-2 -s --type list --list-type string /system/osso/connectivity/network_type/auto_connect [%s]' % String)

class clevenSelectDictionary(QtGui.QDialog):

    def __init__(self, parent=None):
       ##Build the parent user interface
       QtGui.QDialog.__init__(self, parent)
       self.ui = Ui_clevenDictionaryUI()
       self.ui.setupUi(self)
       self.setAttribute(Qt.WA_Maemo5AutoOrientation, True)
       self.setAttribute(Qt.WA_Maemo5StackedWindow, True)

       QtCore.QObject.connect(self.ui.dictionaryList, QtCore.SIGNAL('itemSelectionChanged()'), self.setDictionary)
       
       self.ui.dictionaryList.clear()     
       dlist = os.listdir(pathStorage + '/' + folderDictionaries)
       self.ui.dictionaryList.addItems(dlist)
       
    def setDictionary(self):
       global myDictionary
       myDictionary = self.ui.dictionaryList.currentItem().text()

       self.close()

class clevenManageCaptured(QtGui.QMainWindow):

    def __init__(self, parent=None):
       ##Build the parent user interface
       QtGui.QMainWindow.__init__(self, parent)
       self.ui = Ui_clevenManageCapturedUI()
       self.ui.setupUi(self)
       self.setAttribute(Qt.WA_Maemo5AutoOrientation, True)
       self.setAttribute(Qt.WA_Maemo5StackedWindow, True)
       
       ##Decryption and Deletion actions
       QtCore.QObject.connect(self.ui.performActionButton, QtCore.SIGNAL('clicked()'), self.actOnCapturedFiles)
       QtCore.QObject.connect(self.ui.dictionaryButton, QtCore.SIGNAL('clicked()'), self.showSelectDictionaryDialog)
       QtCore.QObject.connect(self.ui.capturedList, QtCore.SIGNAL('itemSelectionChanged()'), self.enableActionButtons)
       QtCore.QObject.connect(self.ui.wepRadio, QtCore.SIGNAL('clicked()'), self.showCapturedFiles)
       QtCore.QObject.connect(self.ui.wpaRadio, QtCore.SIGNAL('clicked()'), self.showCapturedFiles)
       
       self.show()       

       self.ui.performActionButton.setEnabled(False)
       self.ui.selectCommonRadio.setEnabled(False)
       self.ui.dictionaryLine.setEnabled(False)
       self.ui.dictionaryButton.setHidden(True)
       self.ui.dictionaryLine.setHidden(True)
       
       self.enableOptions()
       
    def showSelectDictionaryDialog(self):
       '''Open the dictionary selection dialog'''
       
       DictionariesDialog = clevenSelectDictionary()
       DictionariesDialog.exec_()
       self.ui.dictionaryLine.setText(myDictionary)

    def enableActionButtons(self):
       '''Enable in the UI the Decrypt button'''
      
       self.ui.performActionButton.setEnabled(True)
       self.ui.selectCommonRadio.setEnabled(True)

    def enableOptions(self):
       '''Prepare the UI to either have the Delete or Decrypt options'''
     
       if deleteModeOn == 'True':
       
          self.setWindowTitle('Deletion')
          
          self.ui.performActionButton.setEnabled(False)
          self.ui.performActionButton.setText('Delete')       
          self.ui.selectCommonRadio.setEnabled(False)
          
          ##Hide the dictionary selection buttons 
          self.ui.dictionaryButton.setHidden(True)
          self.ui.dictionaryLine.setHidden(True)
      
       else:  

          self.setWindowTitle('Decryption')
          
          self.ui.performActionButton.setEnabled(False)
          self.ui.performActionButton.setText('Decrypt')
          self.ui.selectCommonRadio.setEnabled(False)
       
    def showCapturedFiles(self):
       '''Read and add in the UI the captured file list'''
      
       if self.ui.wepRadio.isChecked():
          encryption = "WEP"
          self.ui.dictionaryButton.setHidden(True)
          self.ui.dictionaryLine.setHidden(True)
          
       else:
          encryption = "WPA"
          if deleteModeOn == 'False':
            self.ui.dictionaryButton.setHidden(False)
            self.ui.dictionaryLine.setHidden(False)

       self.ui.capturedList.clear() 
       self.ui.performActionButton.setEnabled(False)
       
       clist = os.listdir(pathStorage + '/' + folderCapturedData + '/' + encryption)
       clist_clean = [line for line in clist if (('.cap' in line) or ('.ivs' in line))]
       clist_clean.sort(key=str.lower)
       self.ui.capturedList.addItems(clist_clean)

    def actOnCapturedFiles(self):
       '''Start the decryption OR deletion of the captured files saved in the system'''

       if self.ui.capturedList.currentRow() == -1:
          self.ui.performActionButton.setEnabled(False)
          return
          
       self.capfile = str(self.ui.capturedList.currentItem().text())
       
       ##Decrypt files
       if deleteModeOn == 'False':
          if self.ui.selectCommonRadio.isChecked():
             name = self.capfile.strip().rpartition('-')
             name = name[0]
             suffix = self.capfile.strip().rpartition('.')
             suffix = suffix[2]
             if suffix == 'ivs':
                cap = name+'*.ivs'
             else:
                cap = name+'*.cap'
             key = name+'-common'
          else:
             cap = self.capfile.strip()
             key = self.capfile.strip()
          
          if self.ui.wpaRadio.isChecked():
             if myDictionary == '':
                self.ui.performActionButton.setEnabled(False)
                return
             else:
                os.system('osso-xterm -e "sudo %s/%s decryptWPA %s %s %s %s" &' % (pathMain, helperScript, pathStorage, myDictionary, key, cap))
          else:
             # print pathMain, pathStorage, key, cap
             os.system('osso-xterm -e "sudo %s/%s decryptWEP %s %s %s" &' % (pathMain, helperScript, pathStorage, key, cap))
       
       ##Delete files             
       elif deleteModeOn == 'True':
          self.ui.dictionaryButton.setHidden(True)
          self.ui.dictionaryLine.setHidden(True)

          if self.ui.wepRadio.isChecked():
             encryption = "WEP"
          else:
             encryption = "WPA"
             
          if self.ui.selectCommonRadio.isChecked():
             name = self.capfile.strip().rpartition('-')
             cap = name[0]
          else:
             cap = self.capfile.strip().replace('.cap','').replace('.ivs','')
          print "delete cap: ", cap

          os.system('sudo %s/%s deleteCaptured %s %s %s' % (pathMain, helperScript, pathStorage, encryption, cap))
          self.showCapturedFiles()          
         
class clevenShowKeys(QtGui.QMainWindow):

    def __init__(self, parent=None):
    
       ##Build the parent user interface
       QtGui.QMainWindow.__init__(self, parent)
       self.ui = Ui_clevenKeysUI()
       self.ui.setupUi(self)
       self.setAttribute(Qt.WA_Maemo5AutoOrientation, True)
       self.setAttribute(Qt.WA_Maemo5StackedWindow, True)
       self.show()       
       
       ##Buttons
       QtCore.QObject.connect(self.ui.keyRefreshButton, QtCore.SIGNAL('clicked()'), self.refreshKeyList)
       QtCore.QObject.connect(self.ui.keyReadButton, QtCore.SIGNAL('clicked()'), self.readKey)
       QtCore.QObject.connect(self.ui.keyList, QtCore.SIGNAL('itemSelectionChanged()'), self.enableReadKeyButton)
       self.ui.keyReadButton.setEnabled(False)

    def enableReadKeyButton(self):
    
       self.ui.keyReadButton.setEnabled(True)
       self.ui.keyBrowser.setText("Please select one of the Key files..")

    def refreshKeyList(self): 
    
       list = os.listdir(pathStorage + '/' + folderKeys)
       self.ui.keyList.clear()
       self.ui.keyList.addItems(list)
       self.ui.keyBrowser.setText("Please select one of the Key files..")
       
    def readKey(self):
    
       if self.ui.keyList.currentRow() == -1:
          self.ui.keyBrowser.setText("Please select one of the Key files..")
          return
       keyfile = str(self.ui.keyList.currentItem().text()).strip()
       try:
          key = open(pathStorage + '/' + folderKeys + '/' + keyfile, 'r' ).readline()
          self.ui.keyBrowser.setText(key)
       except IOError:
          self.ui.keyBrowser.setText("Key file cannot be read..")

class clevenAbout(QtGui.QMainWindow):
    '''About Window'''
      
    def __init__(self, parent=None):
       QMainWindow.__init__(self,parent)
       self.parent = parent
       self.setAttribute(Qt.WA_Maemo5AutoOrientation, True)
       self.setAttribute(Qt.WA_Maemo5StackedWindow, True)
       self.setWindowTitle("About Cleven")
        
       aboutScrollArea = QScrollArea(self)
       aboutScrollArea.setWidgetResizable(True)
       awidget = QWidget(aboutScrollArea)
       # awidget.setMinimumSize(470,1480)
       awidget.setSizePolicy( QSizePolicy.Expanding, QSizePolicy.Expanding )
       aboutScrollArea.setSizePolicy( QSizePolicy.Expanding, QSizePolicy.Expanding )
       try:
          scroller = aboutScrollArea.property("kineticScroller").toPyObject()
          scroller.setEnabled(True)
       except:
          pass

       aboutLayout = QVBoxLayout(awidget)
       
       aboutIcon = QLabel()
       aboutIcon.setPixmap( QIcon.fromTheme('cleven').pixmap(128,128) )
       aboutIcon.setAlignment( Qt.AlignCenter or Qt.AlignHCenter )
       aboutIcon.resize(128,128)

       aboutLayout.addWidget(aboutIcon)
       
       aboutLabel = QLabel('''<center><b>Cleven</b><br>version: %s-%s 
       <br><br><b>Cleven is a user interface to the AirCrack-NG console application.</b> 
       <br><br>Licenced under GPLv2
       <br>by <b>Christos Zamantzas</b> (Saturn) 
       <br><br>It provides the ability to easily configure the injection drivers, scan for surrounding stations, and by using injection and authentication or deauthentication, capture Identification Vector keys. 
       <br><br>In addition, it provides interfaces to decrypt the captured files and manage the keys from successful attacks. 
       <br><br><b>DISCLAIMER:</b> 
       <br>The application provided is to be used for educational purposes only. The application creator is in no way responsible for any misuse of the information provided. All of the information in this application is meant to help develop a hacker defence attitude in order to prevent the attacks discussed. In no way should you use the information to cause any kind of damage directly or indirectly. The word "Hack" or "Hacking" should be regarded as "Ethical Hack" or "Ethical Hacking" respectively. You implement the information given at your own risk. 
       <br><br>Additional information on the usage, settings and implications can be found in the wiki pages (see buttons in the end). 
       <br><br><b>THANKS TO:</b> 
       <br><br><b>David Gnedt</b> (lxp) for the development of the bleeding-edge wlan drivers. You can support his work by sending him your donations. See for more info: http://david.gnedt.eu/blog/wl1251/ 
       <br><br><b>Benoit HERVIER</b> at http://khertan.net/ for the code used in this about window. 
       <br></center>''' % (Version, Build))
       
       aboutLabel.setWordWrap(True)
       aboutLabel.setAlignment( Qt.AlignCenter or Qt.AlignHCenter )
       
       aboutLayout.addWidget(aboutLabel)
       self.wikiButton = QPushButton('Cleven Wiki')
       self.wikiButton.clicked.connect(self.openWikiPage)
       self.issuesButton = QPushButton('Issue Tracker')
       self.issuesButton.clicked.connect(self.openIssueTracker)
       
       awidget2 = QWidget()
       buttonLayout = QHBoxLayout(awidget2)        
       buttonLayout.addWidget(self.wikiButton)
       buttonLayout.addWidget(self.issuesButton)
       aboutLayout.addWidget(awidget2)
       
       awidget.setLayout(aboutLayout)
       aboutScrollArea.setWidget(awidget)
       self.setCentralWidget(aboutScrollArea)
       self.show()        
       
    def openWikiPage(self):
       QDesktopServices.openUrl(QUrl('http://wiki.maemo.org/Cleven'))
    def openIssueTracker(self):
       QDesktopServices.openUrl(QUrl('http://wiki.maemo.org/Cleven'))

class clevenStartup(QtGui.QDialog):
    '''Application start up dialog'''
    
    def __init__(self, parent=None):
       ##Build the parent user interface
       QtGui.QDialog.__init__(self, parent)
       self.ui = Ui_clevenStartupUI()
       self.ui.setupUi(self)
       self.setAttribute(Qt.WA_Maemo5AutoOrientation, True)
       self.setAttribute(Qt.WA_Maemo5StackedWindow, True)
       self.showFullScreen()
       self.timer = QtCore.QBasicTimer()
       self.step = 0       
       self.timer.start(100, self)

    def timerEvent(self, event):

       if self.step >= 100:
          self.timer.stop()
          self.close()
       self.step = self.step + 1
       self.ui.progressBarStart.setValue(self.step)
    
class clevenMain():

    ##Check with what priviledges the GUI has been executed.
    if os.geteuid() == 0:
       message ='ERROR: Cleven should not be executed as root. Exiting..'
       showMessage(message)
       sys.exit(1)
    
    ##Check if user's storage folder is available:   
    if os.path.exists(pathStorage) == False:
       message ='First Time Use: Creating user folders at:\n%s' % pathStorage
       showMessage(message)    
       os.system('mkdir -p %s'         % (pathStorage))
       os.system('mkdir -p %s/%s'      % (pathStorage,folderCapturedData))
       os.system('mkdir -p %s/%s/WEP'  % (pathStorage,folderCapturedData))
       os.system('mkdir -p %s/%s/WPA'  % (pathStorage,folderCapturedData))
       os.system('mkdir -p %s/%s'      % (pathStorage,folderDictionaries))
       os.system('mkdir -p %s/%s'      % (pathStorage,folderKeys))
    else:
       pass
    
    global reaverAvailability, washAvailability
    reaverAvailability = False
    washAvailability = False
    
    ##Check if reaver and/or wash is available in the home directory:
    if os.path.exists(pathReaver):
       if os.path.isfile(pathReaver + '/' + reaverBinary):
          if os.WEXITSTATUS(os.system('sudo %s/%s copyReaver %s %s' % ( pathMain, helperScript, pathReaver, pathMain ))) == 0:
             print 'found Reaver binary and made a copy'
       if os.path.isfile(pathReaver + '/' + washBinary):
          if os.WEXITSTATUS(os.system('sudo %s/%s copyWash %s %s' % ( pathMain, helperScript, pathReaver, pathMain ))) == 0:
             print 'found Wash binary and made a copy'
       if os.path.isfile(pathReaver + '/' + reaverDatabase):
          if os.WEXITSTATUS(os.system('sudo %s/%s copyReaverDB %s %s' % ( pathMain, helperScript, pathReaver, pathMain ))) == 0:
             print 'found Reaver database and made a copy'

    ##Check if reaver is available to the application:
    if os.path.isfile(pathMain + '/' + reaverBinary):
       os.path.exists(pathReaver) or os.mkdir(pathReaver)
       reaverAvailability = True
       print 'Reaver is available for usage..'
       
    ##Check if wash is available to the application:
    if os.path.isfile(pathMain + '/' + washBinary):
       os.path.exists(pathReaver) or os.mkdir(pathReaver)
       washAvailability = True
       print 'Wash is available for usage..'
       
    app = QtGui.QApplication(sys.argv)
    myapp = clevenMainWindow()
    myapp.show()
    
    sys.exit(app.exec_())