#!/usr/bin/env python2.5
##################################################################
##   Cleven  -  a user interface of aircrack-ng for the N900    ##
##################################################################
#                                                                #
# Copyright (c) 2011 Christos Zamantzas                          #
# Licenced under GPLv2                                           #
#                                                                # 
# Christos Zamantzas (Saturn) <christos.zamantzas@gmail.com>     #
#                                                                # 
# * name comes from http://www.thefreedictionary.com/cleave      #
##################################################################

Version = '1.8'
Build = '1'

import sys
import os
import string

import subprocess

from PyQt4.QtGui import *
from PyQt4.QtCore import *
from PyQt4.QtMaemo5 import *

from clevenMainUI import *
from clevenDriversUI import *
from clevenDecryptUI import *
from clevenKeysUI import *
from clevenStartupUI import *

pathMain             = '/opt/cleven'                        # main path of files
pathTemp             = '/home/user/.cleven'                 # temp path of files
pathDrivers          = '%s/compat-wireless' % pathMain
helperScript         = 'clevenHelper.sh'
folderKeys           = 'keys'
folderDictionaries   = 'dictionaries'
folderCapturedData   = 'capturedData'

##############################################################

def showMessage(message):
    ''' Method to display a message to the user that waits for a confirmation. '''

    os.system('dbus-send --type=method_call --dest=org.freedesktop.Notifications \
               /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteDialog \
               string:"%s" uint32:0 string:"OK"' % message)          
  
def showQuickMessage(message):
    ''' Method to display a message to the user. '''

    os.system('dbus-send --type=method_call --dest=org.freedesktop.Notifications \
               /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint \
               string:"%s"' % message)          

def checkFile(Path, File):
    ''' Check if a file exists. '''

    try:
       f = open(Path + '/' + File, 'r')
       f.close()
    except:
       return False
    else:
       return True

class clevenMainWindow(QtGui.QMainWindow): # need fixes

    def __init__(self, parent=None):
       QtGui.QWidget.__init__(self, parent)
       self.ui = Ui_clevenMainUI()
       self.ui.setupUi(self)
       self.setWindowTitle('Cleven %s' % Version)
       self.setAttribute(Qt.WA_Maemo5AutoOrientation, True)
       self.setAttribute(Qt.WA_Maemo5StackedWindow, True)

       ##Connect Menu Buttons 
       QtCore.QObject.connect(self.ui.actionQuit, QtCore.SIGNAL('triggered()'), QtGui.qApp, QtCore.SLOT('quit()'))
       QtCore.QObject.connect(self.ui.actionAbout, QtCore.SIGNAL('triggered()'), self.showAboutWindow)
       QtCore.QObject.connect(self.ui.actionConfigureDrivers, QtCore.SIGNAL('triggered()'), self.showConfigureDriversDialog)
       QtCore.QObject.connect(self.ui.actionDecryptCaptured, QtCore.SIGNAL('triggered()'), self.showDecryptWindow)
       QtCore.QObject.connect(self.ui.actionShowKeys, QtCore.SIGNAL('triggered()'), self.showKeysWindow)
       
       ##Access Point
       QtCore.QObject.connect(self.ui.scanButton, QtCore.SIGNAL('clicked()'), self.scanNetworks)
       QtCore.QObject.connect(self.ui.wepRadio, QtCore.SIGNAL('clicked()'), self.displayNetworks)
       QtCore.QObject.connect(self.ui.wpaRadio, QtCore.SIGNAL('clicked()'), self.displayNetworks)
       QtCore.QObject.connect(self.ui.scanList, QtCore.SIGNAL('itemSelectionChanged()'), self.displayNetworkInformation)

       ##Capture of packets
       QtCore.QObject.connect(self.ui.captureButton, QtCore.SIGNAL('clicked()'), self.executeCapture)
       QtCore.QObject.connect(self.ui.authenticateButton, QtCore.SIGNAL('clicked()'), self.executeAuthenticate)
       QtCore.QObject.connect(self.ui.deauthenticateButton, QtCore.SIGNAL('clicked()'), self.executeDeauthenticate)
       QtCore.QObject.connect(self.ui.injectionButton, QtCore.SIGNAL('clicked()'), self.executeInjection)

       self.showStartupDialog()          ## (Un)comment for pop-up of the start-up dialog at start-up
       self.showConfigureDriversDialog() ## (Un)comment for pop-up of the configuration dialog at start-up  

       self.ui.captureButton.setEnabled(False)
       self.ui.injectionButton.setHidden(True)
       self.ui.authenticateButton.setHidden(True)
       self.ui.deauthenticateButton.setHidden(True)
      
       ##Show some info in the UI
       self.ui.textBrowser.clear()
       self.ui.textBrowser.append('Scan first for available networks')
       self.ui.textBrowser.append('then choose WEP or WPA')
       
    def showAboutWindow(self):
       self.aboutWin = clevenAbout(self)

    def showStartupDialog(self):
       StartupDialog = clevenStartup()
       StartupDialog.exec_()

    def showConfigureDriversDialog(self):
       DriverDialog = clevenConfigureDrivers()
       DriverDialog.exec_()

    def showDecryptWindow(self):
       self.aboutWin = clevenDecryptCaptured(self)

    def showKeysWindow(self):
       self.aboutWin = clevenShowKeys(self)

    def scanNetworks(self):
       '''Initiate scanning for available networks'''
       
       # print driverStateInjection, interfaceStateMonitor

       ##Check first if the correct drivers are loaded and the interface is in monitor mode
       if driverStateInjection == 'False' or interfaceStateMonitor == 'False':
          message ='ERROR: Cannot scan for available networks.\n\nThe drivers or the interface are not to the correct state.\nPlease configure them from the available menu option.'
          showMessage(message) 
       else:
          duration = str(self.ui.durationSpin.value())
        
          message ='Scanning for available networks.\nPlease wait..'
          showQuickMessage(message) 
          
          os.system('sudo %s/%s getWlanInformation %s %s' % (pathMain, helperScript, pathTemp, duration))
          message ='Scan for available networks completed!'
          showQuickMessage(message)

    def displayNetworks(self): #FIXME: read ESSIDs directly and not from the file.
       '''Show available networks in the UI.'''

       message ='Showing available networks.'
       showQuickMessage(message)
       
       ##Clean the interface
       self.ui.scanList.clear()
       self.ui.textBrowser.clear()
       self.ui.textBrowser.append('Select network from the list')
       self.ui.captureButton.setEnabled(False)
       self.ui.injectionButton.setHidden(True)
       self.ui.authenticateButton.setHidden(True)
       self.ui.deauthenticateButton.setHidden(True)

       if self.ui.wepRadio.isChecked():
          encryption = "WEP"
       else:
          encryption = "WPA"      

       values = os.popen('sudo %s/%s readESSIDs %s %s' %(pathMain, helperScript, pathTemp, encryption)).read()
       values = values.lstrip(" ")            ##remove trailing space from first ESSID
       values = values.replace("\n ","\n")    ##remove trailing space from the rest of the ESSIDs 
       values = values.split("\n")            ##split them to create an entry for each in the list
       # print "ESSIDs found:\n", values
       values = filter(None, values)          ##remove unknown (hidden)
       # print "ESSIDs cleaned:\n", values
       values.sort(key=str.lower)             ##sort them by name.
       # print "ESSIDs sorted:\n", values

       # print "BSSIDs to put in the list:\n", values
       self.ui.scanList.addItems(values)

    def displayNetworkInformation(self): #FIXME: read wlan info directly and not from a file.

       global essid, bssid, channel, encryption
    
       if self.ui.scanList.currentRow() == -1:
          self.ui.textBrowser.clear()
          self.ui.captureButton.setEnabled(False)
          return
       self.ui.captureButton.setEnabled(True)
       essid = self.ui.scanList.currentItem().text()
       essidInfo = os.popen('sudo %s/%s readESSIDinfo %s %s' % (pathMain, helperScript, pathTemp, essid)).read().split("\n")
       
       essid = essidInfo[0]
       bssid = essidInfo[1]
       channel = essidInfo[2]
       encryption = essidInfo[3]
       essid = essid.strip()
       bssid = bssid.strip()
       channel = channel.strip()
       encryption = encryption.strip()
       
       self.ui.textBrowser.clear()
       self.ui.textBrowser.append('Name: ' + essid)
       self.ui.textBrowser.append('MAC: ' + bssid)
       self.ui.textBrowser.append('Ch: ' + channel + ' Security: ' + encryption)

    def executeCapture(self):
       '''Opens an xterm window that captures the packets.'''
   
       if self.ui.scanList.currentRow() == -1:
          self.ui.captureButton.setEnabled(False)
          self.ui.authenticateButton.setEnabled(False)
          self.ui.injectionButton.setEnabled(False)
          self.ui.deauthenticateButton.setEnable(False)
          self.ui.injectionButton.setHidden(True)
          self.ui.authenticateButton.setHidden(True)
          self.ui.deauthenticateButton.setHidden(True)
          return
      
       if self.ui.wepRadio.isChecked():
          encryption = "WEP"

          self.ui.authenticateButton.setHidden(False)
          self.ui.injectionButton.setHidden(False)
          self.ui.deauthenticateButton.setHidden(True)

          self.ui.authenticateButton.setEnabled(True)
          self.ui.injectionButton.setEnabled(True)
          self.ui.deauthenticateButton.setEnabled(False)
       else:
          encryption = "WPA"
          self.ui.authenticateButton.setHidden(True)
          self.ui.injectionButton.setHidden(True)
          self.ui.deauthenticateButton.setHidden(False)

          self.ui.authenticateButton.setEnabled(False)
          self.ui.injectionButton.setEnabled(False)
          # self.ui.deauthenticateButton.setEnabled(True) ##INFO: uncomment when "executeDeauthenticate" is fixed.
          
       # print "capture options: ", channel, bssid, pathTemp, encryption, essid
       os.system('osso-xterm -e "sudo %s/%s capture %s %s %s %s %s" &' % (pathMain, helperScript, channel, bssid, pathTemp, encryption, essid))
      
    def executeDeauthenticate(self): #FIXME:: the essid should be the connected client's mac
       '''Opens an xterm window that sends deauthentication packets.'''
       
       # print "deauthenticate options: ", bssid, essid
       os.system('osso-xterm -e "sudo %s/%s deauthenticate %s %s" &' % (pathMain, helperScript, bssid, essid))

    def executeAuthenticate(self):
       '''Opens an xterm window that sends authentication packets.'''
       
       # print "authenticate options: ", essid, bssid, myMAC
       os.system('osso-xterm -e "sudo %s/%s authenticate %s %s %s" &' % (pathMain, helperScript, essid, bssid, myMAC))

    def executeInjection(self):
       '''Opens an xterm window that sends injection packets.'''
       
       # print "injection options: ", bssid, myMAC
       os.system('osso-xterm -e "sudo %s/%s injection %s %s" &' % (pathMain, helperScript, bssid, myMAC))
       
class clevenConfigureDrivers(QtGui.QDialog): # Complete

    def __init__(self, parent=None):
       ##Build the parent user interface
       QtGui.QDialog.__init__(self, parent)
       self.ui = Ui_clevenDriversUI()
       self.ui.setupUi(self)
       self.setAttribute(Qt.WA_Maemo5AutoOrientation, True)
       self.setAttribute(Qt.WA_Maemo5StackedWindow, True)
       
       ##Connect the buttons for the monitoring drivers
       QtCore.QObject.connect(self.ui.enableMonitor, QtCore.SIGNAL('clicked()'), self.enableMonitor)
       QtCore.QObject.connect(self.ui.disableMonitor, QtCore.SIGNAL('clicked()'), self.disableMonitor)
       QtCore.QObject.connect(self.ui.enableInjection, QtCore.SIGNAL('clicked()'), self.enableInjection)
       QtCore.QObject.connect(self.ui.disableInjection, QtCore.SIGNAL('clicked()'), self.disableInjection)
       QtCore.QObject.connect(self.ui.macButton, QtCore.SIGNAL('clicked()'), self.setMACinterfaceValue)
       QtCore.QObject.connect(self.ui.randomButton, QtCore.SIGNAL('clicked()'), self.setMACrandomValue)
       QtCore.QObject.connect(self.ui.WLAN, QtCore.SIGNAL('clicked()'), self.setConnectionBehaviour)
       QtCore.QObject.connect(self.ui.GPRS, QtCore.SIGNAL('clicked()'), self.setConnectionBehaviour)
       QtCore.QObject.connect(self.ui.ANY, QtCore.SIGNAL('clicked()'), self.setConnectionBehaviour)
       QtCore.QObject.connect(self.ui.ASK, QtCore.SIGNAL('clicked()'), self.setConnectionBehaviour)
       
       ##Get and populate the UI with the curent info 
       self.getKernelVersion()
       self.getDriversState()
       self.getInterfaceState()
       self.getConnectionBehaviour()
       self.getMAC()
       global myMAC
       myMAC = self.getMAC()

    def getKernelVersion(self):

       global kernelVersion
       kernelVersion = os.popen('uname -r').read()
       print kernelVersion
       
       if kernelVersion == '2.6.28.10power46-wl1\n':
          pass
       elif kernelVersion == '2.6.28.10power47\n':
          pass
       elif kernelVersion == '2.6.28.10power48\n':
          pass
       else: 
          message = 'WARNING: The system did not find a compatible kernel version for the injection drivers.\n\nThe application might not work properly..'
          showMessage(message)

    
    def getDriversState(self):
       '''Check the state of the Drivers (Stock/Bleeding)'''
       
       global driverStateInjection
       
       DRIVERS = os.popen('cat /proc/modules | grep wl12xx').read()
       
       if DRIVERS == '':
          driverStateInjection = 'True'
          self.ui.enableInjection.setHidden(True)
          self.ui.disableInjection.setHidden(False)
       else:
          driverStateInjection = 'False'
          self.ui.enableInjection.setHidden(False)
          self.ui.disableInjection.setHidden(True)

    def getInterfaceState(self):
       '''Check the state of the interface (Managed/Monitor)'''
       
       global interfaceStateMonitor
       MODE = os.popen('sudo %s/%s checkInterface' %(pathMain, helperScript)).read()
       
       if MODE == 'Monitor\n':
          interfaceStateMonitor = 'True'
          self.ui.disableMonitor.setHidden(False)
          self.ui.enableMonitor.setHidden(True)
       elif MODE == 'Managed\n':
          interfaceStateMonitor = 'False'
          self.ui.disableMonitor.setHidden(True)
          self.ui.enableMonitor.setHidden(False)

    def enableMonitor(self):
       '''Set the interface to Monitor mode'''
      
       message ='Setting the interface to MONITOR mode..'
       showQuickMessage(message)

       os.system('sudo %s/%s enableMode Monitor' %(pathMain, helperScript))
       self.getDriversState()
       self.getInterfaceState()
       self.getMAC()

    def disableMonitor(self):
       '''Set the interface to Managed mode'''

       message ='Setting the interface to MANAGED mode..'
       showQuickMessage(message)

       os.system('sudo %s/%s enableMode Managed' %(pathMain, helperScript))
       self.getDriversState()
       self.getInterfaceState()
       self.getMAC()

    def enableInjection(self):
       '''Load the injection drivers'''
      
       message ='Loading the injection drivers..'
       showQuickMessage(message)
       
       os.system('sudo %s/load.sh' % pathDrivers)
       self.getDriversState()
       self.getInterfaceState()
       self.getMAC()

    def disableInjection(self):
       '''Unload the injection drivers'''

       message ='Unloading the injection drivers..'
       showQuickMessage(message)

       os.system('sudo %s/unload.sh' % pathDrivers)
       self.getInterfaceState()
       self.getMAC()
       self.getDriversState()

    def getMAC(self):
       '''Get the MAC address defined on the device'''

       if self.ui.enableMonitor.isEnabled():
          #interface is in Managed mode
          macList = os.popen('sudo %s/%s getMACmanaged' %(pathMain, helperScript)).read()
       else:
          #interface is in Monitor mode 
          macList = os.popen('sudo %s/%s getMACmonitor' %(pathMain, helperScript)).read()
       
       myMAC = macList[0:17]
       myMAC = myMAC.replace('-',':')
       self.ui.macEdit.setText(myMAC)
       return myMAC

    def setMACrandomValue(self):
       '''Set a random MAC address on the device'''
       
       global myMAC
       message ='Setting a random MAC address..'
       showQuickMessage(message)
       os.system('sudo %s/%s setMACrandom' %(pathMain, helperScript))
       myMAC = self.getMAC()

    def setMACinterfaceValue(self):
       '''Set a user defined MAC address on the device'''
       
       global myMAC
       message ='Setting the UI defined MAC address..'
       showQuickMessage(message)
       newMAC = str(self.ui.macEdit.text())
       newMAC = newMAC.strip()
       os.system('sudo %s/%s setMACmanual %s' %(pathMain, helperScript, newMAC))
       myMAC = self.getMAC()

    def getConnectionBehaviour(self):
       '''Get current data connection behaviour.''' 

       Mode = os.popen('gconftool-2 -g --list-type string /system/osso/connectivity/network_type/auto_connect').read().strip('\n') 
       
       if Mode == '[]':
           self.ui.ASK.setChecked(True)
       elif Mode == '[*]':
           self.ui.ANY.setChecked(True)
       elif Mode == '[GPRS]':
           self.ui.GPRS.setChecked(True)    
       elif Mode == '[WLAN_INFRA]':
           self.ui.WLAN.setChecked(True)

    def setConnectionBehaviour(self):
       '''Set new data connection behaviour.'''

       ## Available options: [WLAN_INFRA], [GPRS], [*] <=='any', [] <=='ask'
       if self.ui.ASK.isChecked():
           String = ''
       elif self.ui.WLAN.isChecked():
           String = 'WLAN_INFRA'
       elif self.ui.GPRS.isChecked():        
           String = 'GPRS'
       elif self.ui.ANY.isChecked():
           String = '*'
          
       ## Set requested setting for "Connect automatically" 
       os.system('gconftool-2 -s --type list --list-type string /system/osso/connectivity/network_type/auto_connect [%s]' % String)

class clevenDecryptCaptured(QtGui.QMainWindow): # Complete

    def __init__(self, parent=None):
       ##Build the parent user interface
       QtGui.QMainWindow.__init__(self, parent)
       self.ui = Ui_clevenDecryptUI()
       self.ui.setupUi(self)
       self.setAttribute(Qt.WA_Maemo5AutoOrientation, True)
       self.setAttribute(Qt.WA_Maemo5StackedWindow, True)

       ##Connect Menu Buttons 
       QtCore.QObject.connect(self.ui.actionEnableDeleteOptions, QtCore.SIGNAL('triggered()'), self.enableDeleteOptions)
       QtCore.QObject.connect(self.ui.actionDisableDeleteOptions, QtCore.SIGNAL('triggered()'), self.disableDeleteOptions)
       
       # Decryption
       QtCore.QObject.connect(self.ui.decryptButton, QtCore.SIGNAL('clicked()'), self.decryptORdeleteCapturedFiles)
       QtCore.QObject.connect(self.ui.capturedList, QtCore.SIGNAL('itemSelectionChanged()'), self.enableDecryptionButtons)
       QtCore.QObject.connect(self.ui.dictionaryList, QtCore.SIGNAL('itemSelectionChanged()'), self.enableDecryptionButtons)
       QtCore.QObject.connect(self.ui.wepRadio, QtCore.SIGNAL('clicked()'), self.showCapturedFiles)
       QtCore.QObject.connect(self.ui.wpaRadio, QtCore.SIGNAL('clicked()'), self.showCapturedFiles)
       
       self.show()       

       self.ui.decryptButton.setEnabled(False)
       self.ui.selectCommonRadio.setEnabled(False)
       self.ui.actionEnableDeleteOptions.setEnabled(True)
       self.ui.actionDisableDeleteOptions.setEnabled(False)       

       global deleteModeOn
       deleteModeOn = 'False'
       
    def enableDecryptionButtons(self):
       '''Enable in the UI the Decrypt button'''
      
       self.ui.decryptButton.setEnabled(True)
       self.ui.selectCommonRadio.setEnabled(True)

    def enableDeleteOptions(self):
       '''Enable in the UI the Delete buttons'''
       
       global deleteModeOn
       deleteModeOn = 'True'
       
       self.ui.decryptButton.setEnabled(False)
       self.ui.decryptButton.setText('Delete')       
       self.ui.selectCommonRadio.setEnabled(False)
       self.ui.actionEnableDeleteOptions.setEnabled(False)
       self.ui.actionDisableDeleteOptions.setEnabled(True)
       self.setWindowTitle('Deletion')
       
    def disableDeleteOptions(self):
       '''Disable in the UI the Delete buttons'''

       global deleteModeOn
       deleteModeOn = 'False'
       
       self.ui.decryptButton.setEnabled(False)
       self.ui.decryptButton.setText('Decrypt')
       self.ui.selectCommonRadio.setEnabled(False)
       self.ui.actionEnableDeleteOptions.setEnabled(True)
       self.ui.actionDisableDeleteOptions.setEnabled(False)
       self.setWindowTitle('Decryption')
       
    def showCapturedFiles(self):
       '''Read and add in the UI the captured file list'''
      
       if self.ui.wepRadio.isChecked():
          encryption = "WEP"
          self.ui.dictionaryList.setHidden(True)
          self.ui.labelDictionaries.setHidden(True)
       else:
          encryption = "WPA"
          self.ui.dictionaryList.setHidden(False)
          self.ui.labelDictionaries.setHidden(False)          

       self.ui.capturedList.clear() 
       self.ui.decryptButton.setEnabled(False)
       
       clist = os.listdir(pathTemp + '/' + folderCapturedData + '/' + encryption)
       clist_clean = [line for line in clist if '.cap' in line]
       clist_clean.sort(key=str.lower)
       self.ui.capturedList.addItems(clist_clean)

       self.ui.dictionaryList.clear()     
       dlist = os.listdir(pathTemp + '/' + folderDictionaries)
       self.ui.dictionaryList.addItems(dlist)

    def decryptORdeleteCapturedFiles(self):
       '''Start the decryption of the packets OR Delete captured files saved in the system'''

       if self.ui.capturedList.currentRow() == -1:
          self.ui.decryptButton.setEnabled(False)
          return
          
       self.capfile = str(self.ui.capturedList.currentItem().text())
       
       ##Decrypt files
       if deleteModeOn == 'False':
          if self.ui.selectCommonRadio.isChecked():
             name = self.capfile.strip().partition('-')
             name = name[0]
             cap = name+'*.cap'
             key = name+'-common'
          else:
             cap = self.capfile.strip()
             key = self.capfile.strip()
          # print "cap: ", cap
          # print "key: ", key   
          if self.ui.wpaRadio.isChecked():
             if self.ui.dictionaryList.currentRow() == -1:
                self.ui.decryptButton.setEnabled(False)
                return
             else:
                myDictionary = self.ui.dictionaryList.currentItem().text()
                os.system('osso-xterm -e "sudo %s/%s decryptWPA %s %s %s %s" &' % (pathMain, helperScript, pathTemp, myDictionary, key, cap))
          else:
             # print pathMain, pathTemp, key, cap
             os.system('osso-xterm -e "sudo %s/%s decryptWEP %s %s %s" &' % (pathMain, helperScript, pathTemp, key, cap))
       
       ##Delete files             
       elif deleteModeOn == 'True':
          self.ui.dictionaryList.setHidden(True)
          self.ui.labelDictionaries.setHidden(True)

          if self.ui.wepRadio.isChecked():
             encryption = "WEP"
          else:
             encryption = "WPA"
             
          if self.ui.selectCommonRadio.isChecked():
             ##FIXME: add a check if the name has also a '-'
             name = self.capfile.strip().partition('-')
             cap = name[0]
          else:
             cap = self.capfile.strip().replace('.cap','')
          print "delete cap: ", cap

          os.system('sudo %s/%s deleteCaptured %s %s %s' % (pathMain, helperScript, pathTemp, encryption, cap))
          self.showCapturedFiles()          
         
class clevenShowKeys(QtGui.QMainWindow): # Complete

    def __init__(self, parent=None):
    
       ##Build the parent user interface
       QtGui.QMainWindow.__init__(self, parent)
       self.ui = Ui_clevenKeysUI()
       self.ui.setupUi(self)
       self.setAttribute(Qt.WA_Maemo5AutoOrientation, True)
       self.setAttribute(Qt.WA_Maemo5StackedWindow, True)
       self.show()       
       
       ##Buttons
       QtCore.QObject.connect(self.ui.keyRefreshButton, QtCore.SIGNAL('clicked()'), self.refreshKeyList)
       QtCore.QObject.connect(self.ui.keyReadButton, QtCore.SIGNAL('clicked()'), self.readKey)
       QtCore.QObject.connect(self.ui.keyList, QtCore.SIGNAL('itemSelectionChanged()'), self.enableReadKeyButton)
       self.ui.keyReadButton.setEnabled(False)

    def enableReadKeyButton(self):
    
       self.ui.keyReadButton.setEnabled(True)
       self.ui.keyBrowser.setText("Please select one of the Key files..")

    def refreshKeyList(self): 
    
       list = os.listdir(pathTemp + '/' + folderKeys)
       self.ui.keyList.clear()
       self.ui.keyList.addItems(list)
       self.ui.keyBrowser.setText("Please select one of the Key files..")
       
    def readKey(self):
    
       if self.ui.keyList.currentRow() == -1:
          self.ui.keyBrowser.setText("Please select one of the Key files..")
          return
       keyfile = str(self.ui.keyList.currentItem().text()).strip()
       try:
          key = open(pathTemp + '/' + folderKeys + '/' + keyfile, 'r' ).readline()
          self.ui.keyBrowser.setText(key)
       except IOError:
          self.ui.keyBrowser.setText("Key file cannot be read..")

class clevenAbout(QtGui.QMainWindow): # Complete
    '''About Window'''
      
    def __init__(self, parent=None):
       QMainWindow.__init__(self,parent)
       self.parent = parent
       self.setAttribute(Qt.WA_Maemo5AutoOrientation, True)
       self.setAttribute(Qt.WA_Maemo5StackedWindow, True)
       self.setWindowTitle("About Cleven")
        
       aboutScrollArea = QScrollArea(self)
       aboutScrollArea.setWidgetResizable(True)
       awidget = QWidget(aboutScrollArea)
       awidget.setMinimumSize(470,1480)
       awidget.setSizePolicy( QSizePolicy.Expanding, QSizePolicy.Expanding )
       aboutScrollArea.setSizePolicy( QSizePolicy.Expanding, QSizePolicy.Expanding )
       try:
          scroller = aboutScrollArea.property("kineticScroller").toPyObject()
          scroller.setEnabled(True)
       except:
          pass

       aboutLayout = QVBoxLayout(awidget)
       
       aboutIcon = QLabel()
       aboutIcon.setPixmap( QIcon.fromTheme('cleven').pixmap(64,64) )
       aboutIcon.setAlignment( Qt.AlignCenter or Qt.AlignHCenter )
       aboutIcon.resize(128,128)
       aboutLayout.addWidget(aboutIcon)
       
       aboutLabel = QLabel('''<center><b>Cleven</b> 
                               <br>version: %s
                               <br>
                               <br>
                               <b>Cleven is a user interface to the 
                               <br>AirCrack-NG console application.</b>
                               <br>
                               <br>Licenced under GPLv2
                               <br>by <b>Christos Zamantzas</b> (Saturn)
                               <br>
                               <br>It provides the ability to easily
                               <br>configure the injection drivers,
                               <br>scan for surrounding stations,
                               <br>and, using injection and
                               <br>authentication or deauthentication, 
                               <br>capture Identification Vector keys.
                               <br>
                               <br>In addition, it provides interfaces 
                               <br>to decrypt the captured files and 
                               <br>manage the successful attacks.
                               <br>
                               <br><b>DISCLAIMER:</b>
                               <br>This program is intended for learning
                               <br>purposes only. I do not condone hacking
                               <br>and wouldn't be held responsible for
                               <br>your actions. Only you would face legal
                               <br>consequences if you used this script
                               <br>for illegal activities.
                               <br>
                               <br>Additional information on the usage,
                               <br>settings and implications can be found in
                               <br>the wiki pages (see buttons in the end).
                               <br>
                               <br><b>THANKS TO:</b>
                               <br><b>David Gnedt</b> (lxp) for the 
                               <br>development of the bleeding-edge 
                               <br>wlan drivers. You can support his work 
                               <br>by donating. See here for more info: 
                               <br>http://david.gnedt.eu/blog/wl1251/
                               <br>
                               <br><b>Benoit HERVIER</b> at http://khertan.net/
                               <br>for the code used in this about window.
                               <br>
                               </center>''' % Version)
       aboutLayout.addWidget(aboutLabel)
       self.wikiButton = QPushButton('Cleven Wiki')
       self.wikiButton.clicked.connect(self.openWikiPage)
       self.issuesButton = QPushButton('Issue Tracker')
       self.issuesButton.clicked.connect(self.openIssueTracker)
       awidget2 = QWidget()
       buttonLayout = QHBoxLayout(awidget2)        
       buttonLayout.addWidget(self.wikiButton)
       buttonLayout.addWidget(self.issuesButton)
       aboutLayout.addWidget(awidget2)
       
       awidget.setLayout(aboutLayout)
       aboutScrollArea.setWidget(awidget)
       self.setCentralWidget(aboutScrollArea)
       self.show()        
       
    def openWikiPage(self):
       QDesktopServices.openUrl(QUrl('http://wiki.maemo.org/Cleven'))
    def openIssueTracker(self):
       QDesktopServices.openUrl(QUrl('http://wiki.maemo.org/Cleven'))

class clevenStartup(QtGui.QDialog): # Complete
    '''Application start up dialog'''
    
    def __init__(self, parent=None):
       ##Build the parent user interface
       QtGui.QDialog.__init__(self, parent)
       self.ui = Ui_clevenStartupUI()
       self.ui.setupUi(self)
       self.setAttribute(Qt.WA_Maemo5AutoOrientation, True)
       self.setAttribute(Qt.WA_Maemo5StackedWindow, True)
       self.showFullScreen()
       self.timer = QtCore.QBasicTimer()
       self.step = 0       
       self.timer.start(100, self)

    def timerEvent(self, event):

       if self.step >= 100 or self.ui.skipIntroRadioButton.isChecked():
          self.timer.stop()
          self.close()
       self.step = self.step + 1
       self.ui.progressBarStart.setValue(self.step)
    
class clevenMain(): # Complete

    ##Check with what priviledges the GUI has been executed.
    if os.geteuid() == 0:
       message ='ERROR: Cleven should not be executed as root. Exiting..'
       showMessage(message)
       sys.exit(1)
    
    ##Check if temp folder is available   
    if os.path.exists(pathTemp) == False:
       message ='First Time Use: Creating user folders at:\n%s' % pathTemp
       showMessage(message)    
       os.system('mkdir -p %s' % pathTemp)
       os.system('mkdir -p %s/%s' % (pathTemp,folderCapturedData))
       os.system('mkdir -p %s/%s/WEP' % (pathTemp,folderCapturedData))
       os.system('mkdir -p %s/%s/WPA' % (pathTemp,folderCapturedData))
       os.system('mkdir -p %s/%s' % (pathTemp,folderDictionaries))
       os.system('mkdir -p %s/%s' % (pathTemp,folderKeys))
    else:
       pass
    
    app = QtGui.QApplication(sys.argv)
    myapp = clevenMainWindow()
    myapp.show()
    
    sys.exit(app.exec_())