#include "mainwindow.h"
#include "ui_mainwindow.h"

#include "useform.h"
#include "searchform.h"
#include "onoffform.h"
#include "aboutform.h"

#include <QtCore/QCoreApplication>
#include <QProcess>

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent), ui(new Ui::MainWindow),
      useForm(0),
      searchForm(0),
      onoffForm(0),
      aboutForm(0)
{
    ui->setupUi(this);

    setAttribute(Qt::WA_Maemo5StackedWindow);
    useForm = new UseForm(this);
    searchForm = new SearchForm(this);
    onoffForm = new OnOffForm(this);
    aboutForm = new AboutForm(this);
}

MainWindow::~MainWindow()
{
    if (aboutForm) delete (aboutForm);
    if (onoffForm) delete (onoffForm);
    if (searchForm) delete (searchForm);
    if (useForm) delete (useForm);
    delete ui;
}

void MainWindow::setOrientation(ScreenOrientation orientation)
{
#if defined(Q_OS_SYMBIAN)
    // If the version of Qt on the device is < 4.7.2, that attribute won't work
    if (orientation != ScreenOrientationAuto) {
        const QStringList v = QString::fromAscii(qVersion()).split(QLatin1Char('.'));
        if (v.count() == 3 && (v.at(0).toInt() << 16 | v.at(1).toInt() << 8 | v.at(2).toInt()) < 0x040702) {
            qWarning("Screen orientation locking only supported with Qt 4.7.2 and above");
            return;
        }
    }
#endif // Q_OS_SYMBIAN

    Qt::WidgetAttribute attribute;
    switch (orientation) {
#if QT_VERSION < 0x040702
    // Qt < 4.7.2 does not yet have the Qt::WA_*Orientation attributes
    case ScreenOrientationLockPortrait:
        attribute = static_cast<Qt::WidgetAttribute>(128);
        break;
    case ScreenOrientationLockLandscape:
        attribute = static_cast<Qt::WidgetAttribute>(129);
        break;
    default:
    case ScreenOrientationAuto:
        attribute = static_cast<Qt::WidgetAttribute>(130);
        break;
#else // QT_VERSION < 0x040702
    case ScreenOrientationLockPortrait:
        attribute = Qt::WA_LockPortraitOrientation;
        break;
    case ScreenOrientationLockLandscape:
        attribute = Qt::WA_LockLandscapeOrientation;
        break;
    default:
    case ScreenOrientationAuto:
        attribute = Qt::WA_AutoOrientation;
        break;
#endif // QT_VERSION < 0x040702
    };
    setAttribute(attribute, true);
}

void MainWindow::showExpanded()
{
#if defined(Q_OS_SYMBIAN) || defined(Q_WS_SIMULATOR)
    showFullScreen();
#elif defined(Q_WS_MAEMO_5)
    showMaximized();
#else
    show();
#endif
}

void MainWindow::on_actionUseful_Commands_triggered()
{
    useForm->show();
}

void MainWindow::on_actionSearch_File_triggered()
{
    searchForm->show();
}

void MainWindow::on_actionON_OFF_triggered()
{
    onoffForm->show();
}

void MainWindow::on_pushButton_clicked()
{
    QProcess process;
    process.start("sh /opt/clean900/script/clean.sh");
    process.waitForFinished();
}

void MainWindow::on_autoclean_clicked()
{
    QProcess process;
    process.start("sh /opt/clean900/script/autoclean.sh");
    process.waitForFinished();
}

void MainWindow::on_autoremove_clicked()
{
    QProcess process;
    process.start("sh /opt/clean900/script/autoremove.sh");
    process.waitForFinished();
}

void MainWindow::on_purge_clicked()
{
    QProcess process;
    process.start("sh /opt/clean900/script/purge.sh");
    process.waitForFinished();
}

void MainWindow::on_update_clicked()
{
    QProcess process;
    process.start("sh /opt/clean900/script/update.sh");
    process.waitForFinished();
}

void MainWindow::on_upgrade_clicked()
{
    QProcess process;
    process.start("sh /opt/clean900/script/upgrade.sh");
    process.waitForFinished();
}

void MainWindow::on_reboot_clicked()
{
    QProcess process;
    process.start("sh /opt/clean900/script/reboot.sh");
    process.waitForFinished();
}

void MainWindow::on_purgedpkg_clicked()
{
    QProcess process;
    process.start("sh /opt/clean900/script/purgedpkg.sh");
    process.waitForFinished();
}

void MainWindow::on_backup_clicked()
{
    QProcess process;
    process.start("sh /opt/clean900/script/backup.sh");
    process.waitForFinished();
}

void MainWindow::on_rebackup_clicked()
{
    QProcess process;
    process.start("sh /opt/clean900/script/ripbackup.sh");
    process.waitForFinished();
}

void MainWindow::on_deb_clicked()
{
    QProcess process;
    process.start("sh /opt/clean900/script/install.sh");
    process.waitForFinished();
}

void MainWindow::on_removepack_clicked()
{
    QProcess process;
    process.start("sh /opt/clean900/script/remove.sh");
    process.waitForFinished();
}

void MainWindow::on_reboot_2_clicked()
{
    QProcess process;
    process.start("sh /opt/clean900/script/reboot.sh");
    process.waitForFinished();
}

void MainWindow::on_actionXTerm_with_root_triggered()
{
    QProcess process;
    process.start("sh /opt/clean900/script/term.sh");
    process.waitForFinished();
}

void MainWindow::on_actionHardware_Details_triggered()
{
    QProcess process;
    process.start("sh /opt/clean900/script/harddet.sh");
    process.waitForFinished();
}

void MainWindow::on_actionAbout_triggered()
{
    aboutForm->show();
}

void MainWindow::on_actionDonate_triggered()
{
    QProcess process;
    process.start("sh /opt/clean900/script/donate.sh");
    process.waitForFinished();
}
