var signalNum=0;//0- ready, 1 game, 2-suspended, 3-settlement
var maxX = 37;
var maxY = 20;
var maxIndex = maxX*maxY;
var p = new Array(maxIndex);
var blockSrc = "qml/plat.qml";
var component = Qt.createComponent(blockSrc);
var snake=new Array(2);
var di=3;//Direction, the 0-, 1-under, 2 left, 3 right
var tdi=di;
var m=[[0,-1],[0,1],[-1,0],[1,0]];//Changes in the corresponding direction
var r=[0,0];//Random location
var highScoreBar = 0;
var score=0;
var bestScore=0;
var isNew=0;

//Score rankings initialization
var db = openDatabaseSync("ClassicSnake1997Scores","1.0","Local ClassicSnake1997Scores High Scores",100);
db.transaction(
    function(tx) {
        //tx.executeSql('DROP TABLE Scores');
        tx.executeSql('CREATE TABLE IF NOT EXISTS Scores(score NUMBER)');
        var rs = tx.executeSql('SELECT * FROM Scores ORDER BY score LIMIT 1');
        for (var i = 0; i < rs.rows.length; i++) {
            bestScore=rs.rows.item(i).score;
        }
    }
);

function sicle(){
    tdi=di;
    if(isDie()){
        mTimer.running=false;
        showDie();
        if(isNew==1){
            saveHighScore(bestScore);
        }
    }else if(snake[0].x+m[di][0]==r[0] && snake[0].y+m[di][1]==r[1]){
        snake.unshift({"x":snake[0].x+m[di][0],"y":snake[0].y+m[di][1]});
        mTimer.interval--;
        score+=7;
        scoreTxt.text=formatScore(score);
        if(score>bestScore){
            bestScore=score;
            bestScoreTxt.text="Best:"+formatScore(bestScore);
            isNew=1;
        }

        p[index(snake[0].x,snake[0].y)].visible=true;
        formatSnake();
        getNew();
    }else{
       // console.log("Step");
        snake.unshift({"x":snake[0].x+m[di][0],"y":snake[0].y+m[di][1]});
        p[index(snake[0].x,snake[0].y)].visible=true;
        var endl=snake.length-1;
        p[index(snake[endl].x,snake[endl].y)].width=9;
        p[index(snake[endl].x,snake[endl].y)].height=9;
        p[index(snake[endl].x,snake[endl].y)].visible=false;
        snake.pop();
        formatSnake();
    }
}

function clickHandle(mouseX,mouseY){
    var xx=Math.floor(mouseX*3/480);
    var xy=Math.floor(mouseY*128/512);//47-27-27-27
    if(xy<47){          xy=0;
    }else if(xy<74){    xy=1;
    }else if(xy<101){   xy=2;
    }else if(xy<128){   xy=3;
    }else{              return;}
    menuDiv.y=882;
    console.log("x:"+xx+",y:"+xy+"--x:"+mouseX+",y:"+mouseY);
    if(xx+xy*3==0){
        if(mTimer.running==true && signalNum==1){
            mTimer.running=false;
            signalNum=2;
        }else if(mTimer.running==false && signalNum==2){
            mTimer.running=true;
            signalNum=1;
        }
    }else if(xx+xy*3==1){
        startGame();
        signalNum=1;
    }else if(xx+xy*3==2){
        menu_bar.y=714;
    }else if(xx+xy*3==4){//Prevent reverse operation
        if(tdi!=1) di=0;
    }else if(xx+xy*3==6){
        if(tdi!=3) di=2;
    }else if(xx+xy*3==8){
        if(tdi!=2) di=3;
    }else if(xx+xy*3==10){
        if(tdi!=0) di=1;
    }
}
function startGame(){
    initDiv();
    for(var i=0;i<snake.length;i++){
        p[index(snake[i].x,snake[i].y)].visible=true;
    }
    getNew();
    myDia.forceClose();
    mTimer.running=true;
}

function showBest(){
    myDia.show("You best score is "+bestScore+".\n\nAuthor: chanxi\n");
}

function showDie(){
    myDia.show("You Die!\nYou got "+score+".\n\nAuthor:chanxi\n");
}

function index(column, row){
    return column + row * maxX;
}
function initDiv(){
    for(var i=0;i<maxY;i++){
        for(var j=0;j<maxX;j++){
            if(p[i*maxX+j])p[i*maxX+j].destroy(0);
            p[i*maxX+j]=component.createObject(gameDiv,{"x":j*10,"y":i*10,"visible":false});
        }
    }
    snake=[{"x":18,"y":9},{"x":17,"y":9}];
    randO.visible=true;
    di=3;
    score=0;
    isNew=0;
    bestScoreTxt.text="Best:"+formatScore(bestScore);
    scoreTxt.text=formatScore(score);
    formatSnake();
}
function getNew(){
    r[0]=Math.floor(Math.random()*37);
    for(;;){
        r[1]=Math.floor(Math.random()*20);
        if(p[index(r[0],r[1])].visible==false){
            break;
        }
    }
    randO.x=r[0]*10;
    randO.y=r[1]*10;
}

function formatSnake(){
    for(var i=0;i<snake.length;i++){
        p[index(snake[i].x,snake[i].y)].width=9;
        p[index(snake[i].x,snake[i].y)].height=9;
    }
    for(var i=0;i<snake.length;i++){
        if(i<snake.length-1){
            if(snake[i].x==snake[i+1].x){
                if(snake[i].y<snake[i+1].y){
                    p[index(snake[i].x,snake[i].y)].height=10;
                }else{
                    p[index(snake[i+1].x,snake[i+1].y)].height=10;
                }
            }else{
                if(snake[i].x<snake[i+1].x){
                    p[index(snake[i].x,snake[i].y)].width=10;
                }else{
                    p[index(snake[i+1].x,snake[i+1].y)].width=10;
                }

            }
        }
    }
}

function isDie(){
    if(snake[0].x+m[di][0]<0 || snake[0].x+m[di][0]>=maxX)
        return true;
    if(snake[0].y+m[di][1]<0 || snake[0].y+m[di][1]>=maxY)
        return true;
    if(p[index(snake[0].x+m[di][0],snake[0].y+m[di][1])] && p[index(snake[0].x+m[di][0],snake[0].y+m[di][1])].visible==true)
        return true;
    return false;
}

function formatScore(sc){
    if(sc<10){
        return "000"+sc;
    }else if(sc<100){
        return "00"+sc;
    }else if(sc<1000){
        return "0"+sc;
    }else{
        return sc;
    }
}
//Storage score
function saveHighScore(sc){
    var dataStr = "INSERT INTO Scores VALUES(?)";
    var data = [sc];
    db.transaction(
        function(tx) {
            tx.executeSql('CREATE TABLE IF NOT EXISTS Scores(score NUMBER)');
            tx.executeSql(dataStr, data);
        }
    );
}
