import QtQuick 1.1
import "qml"
import "script.js" as Sd

Item{
    width: 480;
    height: 800;
    FontLoader { id: gameFont; source: "fonts/dice.ttf" }
    Image {
        id: bg
        anchors.horizontalCenter: parent.horizontalCenter
        source: "img/bg_5190.png"
    }
    Text {
        id:scoreTxt
        x: 48;y: 25
        color: "#333333"
        font.family: gameFont.name;
        font.pixelSize: 40
        text: "0000"
    }
    Text {
        id:bestScoreTxt
        x: 298
        y: 38
        color: "#333333"
        text: "Best:0000"
        font.pixelSize: 25
        font.family: gameFont.name
    }

    function pauseGame()
    {
        Sd.clickHandle(82, 68);
    }

    Item  {
        id: gameDiv
        x: 53;y: 82;width: 370;height: 200;
        MouseArea {
            x: -55;y: 245;width: 480;height: 512
            onClicked: {
                Sd.clickHandle(mouseX,mouseY);
            }
        }
        Item  {
            id: randO;
            visible: false;
            x: 100;y: 100;width: 9;height: 9;
            Rectangle{x: 2;y: 0;width: 5;height: 2;color: "#333333";}
            Rectangle{x: 0;y: 2;width: 2;height: 5;color: "#333333";}
            Rectangle{x: 7;y: 2;width: 2;height: 5;color: "#333333";}
            Rectangle{x: 2;y: 7;width: 5;height: 2;color: "#333333";}
        }
    }

    Item {
        id:menuDiv
        x: 106;y: 882;
        width: 300;height: 150
        Rectangle {
            x: 0;y: 0;width: 250;height: 50;
            border{width: 1;color: "#333333";}
            Text {
                anchors.centerIn: parent;color: "#333333";
                font.family: gameFont.name;font.pixelSize: 50;
                text: "--> 3210";
            }
            MouseArea{anchors.fill: parent;onClicked: {bg.source="img/bg_3210.png";}}
        }
        Rectangle {
            x: 0;y: 50;width: 250;height: 50;
            border{width: 1;color: "#333333";}
            Text {
                anchors.centerIn: parent;color: "#333333";
                font.family: gameFont.name;font.pixelSize: 50;
                text: "--> 3310"
            }
            MouseArea{anchors.fill: parent;onClicked: {bg.source="img/bg_3310.png";}}
        }
        Rectangle {
            x: 0;y: 100;width: 250;height: 50;
            border{width: 1;color: "#333333";}
            Text {
                anchors.centerIn: parent;color: "#333333";
                font.family: gameFont.name;font.pixelSize: 50;
                text: "--> 5190"
            }
            MouseArea{anchors.fill: parent;onClicked: {bg.source="img/bg_5190.png";}}
        }
        Rectangle {
            x: 250;y: 0;width:50;height: 150;color: "#bfe0cf";
            border{width: 1;color: "#333333";}
            Text {
                anchors.centerIn: parent;color: "#333333";
                font.family: gameFont.name;font.pixelSize: 50;
                text: "X";
            }
            MouseArea{anchors.fill: parent;onClicked:{menuDiv.y=882;}}
        }
        Behavior on y {SpringAnimation{ spring: 2; damping: 0.2 }}
    }

    Item {
        id: menu_bar;
        x:-1;y:840;width: parent.width+1;height: 85
        Mbt{
            width: parent.width/2;
            str:"Settings"
            url:"settings_64.png";
            MouseArea {
                anchors.fill:parent;
                onClicked: {
                    menuDiv.y=106;
                    menu_bar.y=840;
                }
            }
        }
        Mbt{
            x:parent.width/2;
            width: parent.width/2;
            str:"Best Score"
            url:"cup_64.png"
            MouseArea {
                anchors.fill:parent;
                onClicked: {
                    Sd.showBest();
                    menu_bar.y=840;
                }
            }
        }
        Behavior on y {
            SpringAnimation{ spring: 2; damping: 0.2 }
        }
   }
    //"About" pop-up
    Dialog{
        id:myDia
        anchors.centerIn: parent
        z: 22;
    }
    //Timer
    Timer{
        id:mTimer
        interval: 200;
        running: false;
        repeat: true
        onTriggered: {
            Sd.sicle();
        }
    }

    Connections {
        target: viewer
        onHideSignal: {
            pauseGame();
        }
    }

}
