/*!
** @file	FlashButton.h
**
** @brief	Custom button widget for flash
**
*/
#ifndef __flashbutton__h
#define __flashbutton__h

/*---------------------------------------------------------------------------
** Includes
*/
#include <QToolButton>
#include "camera.h"

/*---------------------------------------------------------------------------
** Defines and Macros
*/

/*---------------------------------------------------------------------------
** Typedefs
*/

/*---------------------------------------------------------------------------
** Local function prototypes
*/

/*---------------------------------------------------------------------------
** Data
*/

class FlashButton : public QToolButton {
	Q_OBJECT

public:
	//--------------------------------------------------------------------------
	/*!
	** @brief   	Constructor
	*/
	FlashButton(QWidget* parent = NULL);

	//--------------------------------------------------------------------------
	/*!
	** @brief   	Destructor
	*/
	virtual ~FlashButton();
	
	//--------------------------------------------------------------------------
	/*!
	** @brief		Set the button to show the current flash mode
	**
	** @param[In]	New flash mode
	**
	*/
	void set_flash_mode(CAMERA_FLASH_MODE new_flash_mode);

signals:
	//--------------------------------------------------------------------------
	/*!
	** @brief		Signal that is sent when the flash mode changes
	**
	** @param[In]	New flash mode selected by user
	**
	*/
	void flash_mode_changed(CAMERA_FLASH_MODE new_flash_mode);

private slots:
	//--------------------------------------------------------------------------
	/*!
	** @brief		Slot that is called when the user selects the button
	**
	*/
	void clicked(bool checked = false);

private:
	int		m_flash_mode;
};

#endif
