#include "saveimagedialog.h"
#include "ui_saveimagedialog.h"
#include <QImage>

SaveImageDialog::SaveImageDialog(QImage* image, QWidget *parent) :
    QDialog(parent),
    ui(new Ui::SaveImageDialog)
{
	m_image_width = image->width();
	m_image_height = image->height();
	m_selected_width = m_image_width;
	m_selected_height = m_image_height;
    ui->setupUi(this);

	m_updating = true;
	ui->spin_width->setMaximum(m_image_width);
	ui->spin_width->setMinimum(100);
	ui->spin_height->setMaximum(m_image_height);
	ui->spin_height->setMinimum(100);
	ui->spin_width->setValue(m_selected_width);
	ui->spin_height->setValue(m_selected_height);
	m_updating = false;

}

SaveImageDialog::~SaveImageDialog()
{
    delete ui;
}

void SaveImageDialog::setSelectedSize(int width, int height) {
	m_updating = true;
	m_selected_width = width;
	m_selected_height = height;
	if ((m_selected_width > m_image_width) ||
		(m_selected_height > m_image_height)) {
		m_selected_width = m_image_width;
		m_selected_height = m_image_height;
	}
	ui->spin_width->setValue(m_selected_width);
	ui->spin_height->setValue(m_selected_height);
	m_updating = false;
}

void SaveImageDialog::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void SaveImageDialog::on_spin_width_valueChanged(int width)
{
	if (!m_updating) {
		m_updating = true;
		double aspect = (double)m_image_width / (double)m_image_height;
		m_selected_width = width;
		m_selected_height = (int)((double)width / aspect + 0.5);
		if (m_selected_height > m_image_height) {
			m_selected_width = m_image_width;
			m_selected_height = m_image_height;
		}
		ui->spin_width->setValue(m_selected_width);
		ui->spin_height->setValue(m_selected_height);
		m_updating = false;
	}
}

void SaveImageDialog::on_spin_height_valueChanged(int height)
{
	if (!m_updating) {
		m_updating = true;
		double aspect = (double)m_image_width / (double)m_image_height;
		m_selected_height = height;
		m_selected_width = (int)((double)height * aspect + 0.5);
		if (m_selected_width > m_image_width) {
			m_selected_width = m_image_width;
			m_selected_height = m_image_height;
		}
		ui->spin_width->setValue(m_selected_width);
		ui->spin_height->setValue(m_selected_height);
		m_updating = false;
	}
}

void SaveImageDialog::on_btn_photo_res_clicked()
{
	m_selected_width = m_image_width;
	m_selected_height = m_image_height;
	ui->spin_width->setValue(m_selected_width);
	ui->spin_height->setValue(m_selected_height);
}

void SaveImageDialog::on_buttonBox_accepted()
{
	accept();
}
