#include "settingsdialog.h"
#include "ui_settingsdialog.h"
#include "ClassicPrint.h"
#include <QFileDialog>

SettingsDialog::SettingsDialog(ClassicPrint* print, QWidget *parent) :
    QDialog(parent),
    ui(new Ui::SettingsDialog)
{
	m_print = print;
    ui->setupUi(this);

	ui->resolution->addItem("High resolution (5M)", QVariant(5));
	ui->resolution->addItem("Medium resolution (3M)", QVariant(3));
	ui->resolution->addItem("Low resolution (1.3M)", QVariant(1));

	ui->resolution->setCurrentIndex(ui->resolution->findData(QVariant(m_print->cameraMp())));
	ui->keep_negatives->setChecked(m_print->keepNegatives());
	ui->process_preview->setChecked(m_print->processPreview());
	setNegativesButton(m_print->negativesFolder());
	setDevelopedButton(m_print->developedFolder());
}

SettingsDialog::~SettingsDialog()
{
    delete ui;
}

void SettingsDialog::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void SettingsDialog::on_buttonBox_accepted()
{
	// Read the settings and put them in the print object
	m_print->setKeepNegatives(ui->keep_negatives->checkState() == Qt::Checked);
	m_print->setProcessPreview(ui->process_preview->checkState() == Qt::Checked);

	// Set the resolution
	int res = ui->resolution->itemData(ui->resolution->currentIndex()).toInt();
	m_print->setCameraMp(res);

	// Save the folders
	m_print->setNegativesFolder(m_negatives_folder);
	m_print->setDevelopedFolder(m_developed_folder);

	accept();
}

void SettingsDialog::on_buttonBox_rejected()
{
	reject();
}

void SettingsDialog::setNegativesButton(QString folder) {
	QString name(folder);
	int pos = name.lastIndexOf('/');
	if ((pos != -1) && (pos == (name.size() - 1))) {
		name = name.left(pos);
	}
	pos = name.lastIndexOf('/');
	if (pos != -1) {
		name = name.mid(pos + 1);
	}
	ui->negatives_button->setText(name);
	m_negatives_folder = folder;
}

void SettingsDialog::setDevelopedButton(QString folder) {
	QString name(folder);
	int pos = name.lastIndexOf('/');
	if ((pos != -1) && (pos == (name.size() - 1))) {
		name = name.left(pos);
	}
	pos = name.lastIndexOf('/');
	if (pos != -1) {
		name = name.mid(pos + 1);
	}
	ui->developed_button->setText(name);
	m_developed_folder = folder;
}

void SettingsDialog::on_developed_button_clicked()
{
	QString dir = QFileDialog::getExistingDirectory(this, "Developed Images",
													m_print->developedFolder());

	if (dir.size() > 0) {
		setDevelopedButton(dir);
	}
}

void SettingsDialog::on_negatives_button_clicked()
{
	QString dir = QFileDialog::getExistingDirectory(this, "Negatives",
													m_print->negativesFolder());

	if (dir.size() > 0) {
		setNegativesButton(dir);
	}
}
