/* This file is part of Cinaest.
 *
 * Copyright (C) 2009 Philipp Zabel
 *
 * Cinaest is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Cinaest is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Cinaest. If not, see <http://www.gnu.org/licenses/>.
 */

using Gtk;
using Hildon;

public class SourceListMenu : AppMenu {
	private SourceListWindow source_list_window;

	public SourceListMenu (SourceListWindow window) {
		source_list_window = window;
	}

	construct {
		// Add view menu buttons
		var settings = new Gtk.Button.with_label (_("Settings"));

		// Connect signals
		settings.clicked.connect (on_settings_clicked);

		append (settings);

		show_all ();
	}

	public void on_settings_clicked (Gtk.Button button) {
		var dialog = new SettingsDialog (source_list_window);

		dialog.run ();
	}
}
