/*
 * Decompiled with CFR 0.152.
 */
package jpcap;

import java.io.IOException;
import jpcap.JpcapInstance;
import jpcap.NetworkInterface;
import jpcap.packet.Packet;

public class JpcapSender
extends JpcapInstance {
    private static final int RAW_SOCKET_ID = 99999;

    private native String nativeOpenDevice(String var1);

    private native void nativeSendPacket(Packet var1);

    private native void nativeCloseDevice();

    private native void nativeOpenRawSocket();

    private native void nativeSendPacketViaRawSocket(Packet var1);

    private native void nativeCloseRawSocket();

    private JpcapSender() throws IOException {
        if (this.reserveID() < 0) {
            throw new IOException("Unable to open a device: 255 devices are already opened.");
        }
    }

    JpcapSender(int ID) {
        this.ID = ID;
    }

    public static JpcapSender openDevice(NetworkInterface device) throws IOException {
        JpcapSender sender = new JpcapSender();
        String ret = sender.nativeOpenDevice(device.name);
        if (ret == null) {
            return sender;
        }
        throw new IOException(ret);
    }

    public static JpcapSender openRawSocket() throws IOException {
        JpcapSender sender = new JpcapSender();
        sender.nativeOpenRawSocket();
        sender.ID = 99999;
        return sender;
    }

    public void close() {
        if (this.ID == 99999) {
            this.nativeCloseRawSocket();
        } else {
            this.nativeCloseDevice();
        }
        this.unreserveID();
    }

    public void sendPacket(Packet packet) {
        if (this.ID == 99999) {
            this.nativeSendPacketViaRawSocket(packet);
        } else {
            this.nativeSendPacket(packet);
        }
    }
}

