#ifndef CHARMAPBUTTON_H
#define CHARMAPBUTTON_H

#include <QPushButton>

class CharMapButton : public QPushButton
{
    Q_OBJECT

public:
    CharMapButton(QWidget *parent, uint uid)
        : QPushButton(parent)
        , id(uid)
    {}

signals:
    void clicked(uint id);

public slots:
    void notify() { emit clicked(id); }

private:
    uint id;
};

#endif // CHARMAPBUTTON_H
