#include "cellinfo-window.h"

#include <gtk/gtk.h>
#include <libosso.h>

#include <locale.h>

#include <config.h>
#define OSSO_SERVICE "org.debuntu."PACKAGE


#include <glib/gi18n.h>

typedef struct _AppData AppData;

struct _AppData
{
  HildonProgram *program; /* handle to application */
  CellinfoWindow *window; /* handle to app's window */
};

/* Stop the mainloop whenever the window is hidden, 
 * however it is hidden.
 */
static void on_main_window_hide (GtkWidget *widget, gpointer user_data)
{
  gtk_main_quit ();
}

int main (int argc, char **argv)
{
  osso_context_t *osso = NULL;
  AppData *data = g_new0 (AppData, 1);

  /* Initialize the locale stuff: */
  setlocale (LC_ALL, "");
  bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
  bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);

  /* Inititialize GTK+ and hildon: */
  hildon_gtk_init (&argc, &argv);

  if (!g_thread_supported()) {
    g_thread_init (NULL);
  }

  /* Create the hildon application and setup the title: */
  data->program = HILDON_PROGRAM (hildon_program_get_instance ());
  g_set_application_name (_("Cell Tower Info"));

  /* osso initialization */
  osso = osso_initialize (OSSO_SERVICE, VERSION, TRUE, NULL);
  g_assert (osso);
  
  /* Create the window for our application: */
  data->window = cellinfo_window_new (osso);
  /* Show the main window and start the mainloop, 
  * quitting the mainloop when it the main window is hidden:
  */
  gtk_widget_show (GTK_WIDGET (data->window));
  g_signal_connect(data->window, "hide", G_CALLBACK (&on_main_window_hide), NULL);
  g_signal_connect(data->window, "delete_event", 
    G_CALLBACK (&gtk_widget_hide_on_delete), NULL);
  gtk_main();
  
  /* Clean up: */
  gtk_widget_destroy (GTK_WIDGET (data->window));
  g_free (data);

  return 0;
}

