#ifndef _CELLINFO_WINDOW_H_
#define _CELLINFO_WINDOW_H_

#include <hildon/hildon.h>
#include <libosso.h>
#include <location/location-gps-device.h>
#include <location/location-gpsd-control.h>


G_BEGIN_DECLS

#define CELLINFO_TYPE_WINDOW cellinfo_window_get_type()

#define CELLINFO_WINDOW(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
  CELLINFO_TYPE_WINDOW, CellinfoWindow))

#define CELLINFO_WINDOW_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), \
  CELLINFO_TYPE_WINDOW, CellinfoWindowClass))

#define CELLINFO_IS_WINDOW(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
  CELLINFO_TYPE_WINDOW))

#define CELLINFO_IS_WINDOW_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), \
  CELLINFO_TYPE_WINDOW))

#define CELLINFO_WINDOW_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), \
  CELLINFO_TYPE_WINDOW, CellinfoWindowClass))

typedef struct _CellinfoWindow CellinfoWindow;
typedef struct _CellinfoWindowClass CellinfoWindowClass;

struct _CellinfoWindow
{
  HildonWindow       parent;
  osso_context_t    *osso;
  /* Fullscreen mode is on (TRUE) or off (FALSE): */
  /*
  gboolean           fullscreen;
  */

  GtkWidget         *vb_cellinfo;
  /* Button items for menu */
  GtkWidget         *select_sensors;

  /* labels */
  GtkWidget         *lb_cell_type;
  GtkWidget         *lb_mnc;
  GtkWidget         *lb_mcc;
  GtkWidget         *lb_cell_id;
  GtkWidget         *lb_ucid;
  GtkWidget         *lb_lac;

  /* Box that might be hidden */
  GtkWidget         *hb_cell_id;
  GtkWidget         *hb_lac;
  GtkWidget         *hb_ucid;

  /* location info */
  LocationGPSDControl *control;
  LocationGPSDevice   *device;
};

struct _CellinfoWindowClass
{
  HildonWindowClass parent_class;
};

GType cellinfo_window_get_type (void);
CellinfoWindow* cellinfo_window_new (osso_context_t *osso);

G_END_DECLS

#endif /* _CELLINFO_WINDOW_H_ */
