#include "cellinfo-window.h"

#include <gtk/gtk.h>

#include <glib/gi18n.h>

static void create_cellinfo (CellinfoWindow *self);
static void create_menu (CellinfoWindow *self);

static void cellinfo_on_location_changed(LocationGPSDevice *device, gpointer data);

static void cellinfo_window_on_menu_select_sensors (GtkButton *button, gpointer data);
static void cellinfo_window_on_menu_configuration (GtkButton *button, gpointer data);


G_DEFINE_TYPE (CellinfoWindow, cellinfo_window, HILDON_TYPE_WINDOW)

static void
cellinfo_window_dispose (GObject *object)
{
  CellinfoWindow *self = CELLINFO_WINDOW (object);
  
  location_gpsd_control_stop(self->control);
  G_OBJECT_CLASS (cellinfo_window_parent_class)->dispose (object);
}

static void
cellinfo_window_finalize (GObject *object)
{
  G_OBJECT_CLASS (cellinfo_window_parent_class)->finalize (object);
}

static void
cellinfo_window_class_init (CellinfoWindowClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);


  object_class->dispose = cellinfo_window_dispose;
  object_class->finalize = cellinfo_window_finalize;
}

static void
cellinfo_window_init (CellinfoWindow *self)
{
   
  /* Create a vbox which will contain our text view: */
  GtkWidget *main_vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (self), main_vbox);
    
  /* Create all necessary parts: */
  create_cellinfo (self);
  create_menu (self);
    
  /* Put the cell info in the vbox and show it: */
  gtk_box_pack_start (GTK_BOX (main_vbox), self->vb_cellinfo, TRUE, TRUE, 0);
  gtk_widget_show (main_vbox);
    
  /* Set the intial focus on the text view: */
  gtk_widget_grab_focus (GTK_WIDGET(self->vb_cellinfo));
  
}

CellinfoWindow*
cellinfo_window_new (osso_context_t *osso)
{
  CellinfoWindow *self = 
    CELLINFO_WINDOW (g_object_new (CELLINFO_TYPE_WINDOW, NULL));
  
  /* Avoid adding extra code such as this to a _new() function when writing 
   * widgets that should be reusable. This should really be a GObject property.
   */
  self->osso = osso; 
  
  return self;
}

static GtkWidget* add_menu_item (GtkWidget *main_menu, const gchar* title,
    GCallback clicked_callback, gpointer user_data)
{
  HildonAppMenu *app_menu = HILDON_APP_MENU (main_menu);
    
  /* Create a button, add it, and return it: */
  GtkWidget *button = hildon_button_new_with_text (HILDON_SIZE_AUTO, 
        HILDON_BUTTON_ARRANGEMENT_VERTICAL, title, NULL);
  gtk_widget_show (button);
    
  g_signal_connect_after (button, "clicked", 
    G_CALLBACK (clicked_callback), user_data);
            
  hildon_app_menu_append (app_menu, GTK_BUTTON (button));
    
  return button;
}

static void create_menu (CellinfoWindow *self)
{
  return;
  /* Create needed handles */
  GtkWidget *main_menu = hildon_app_menu_new ();
  
  /* Create the menu items */
  self->select_sensors = add_menu_item (main_menu, _("Select Sensors"),
    G_CALLBACK (&cellinfo_window_on_menu_select_sensors), self);
    

  /* Create the menu items */
  self->select_sensors = add_menu_item (main_menu, _("Configuration"),
    G_CALLBACK (&cellinfo_window_on_menu_configuration), self);

  /* Add menu to HildonWindow */
  hildon_window_set_app_menu (
    HILDON_WINDOW (self),
    HILDON_APP_MENU (main_menu));
  
  /* We need to show menu items */
  gtk_widget_show_all (GTK_WIDGET (main_menu));
}
static gboolean cellinfo_start_location (gpointer data)
{
  location_gpsd_control_start ((LocationGPSDControl *) data);
  return FALSE;
}

static gboolean cellinfo_on_gpsd_running (LocationGPSDControl *control, gpointer data){
  CellinfoWindow *self = (CellinfoWindow *)data;
  if(self->device){
    g_print("gpsd running status %d\n", self->device->status);
  }else{
    g_print("No device !");
  }
  return FALSE;
}

static void cellinfo_on_gpsd_error(LocationGPSDControl *control, LocationGPSDControlError error, gpointer user_data)
{
  g_print("GPSD error!\n");
  switch (error) {
  case LOCATION_ERROR_USER_REJECTED_DIALOG:
    g_debug("User didn't enable requested methods");
    break;
  case LOCATION_ERROR_USER_REJECTED_SETTINGS:
    g_debug("User changed settings, which disabled location");
    break;
  case LOCATION_ERROR_BT_GPS_NOT_AVAILABLE:
    g_debug("Problems with BT GPS");
    break;
  case LOCATION_ERROR_METHOD_NOT_ALLOWED_IN_OFFLINE_MODE:
    g_debug("Requested method is not allowed in offline mode");
    break;
  case LOCATION_ERROR_SYSTEM:
    g_debug("System error");
    break;
  }
}

static GtkWidget *add_cellinfo_label_entry(CellinfoWindow *self, const char *entry_name, GtkWidget **label){
  GtkWidget *hbox;
  GtkWidget *l;

  hbox = gtk_hbox_new (TRUE, 1);
  l = gtk_label_new(entry_name);
  *label = gtk_label_new("");

  gtk_label_set_justify (GTK_LABEL (l), GTK_JUSTIFY_LEFT);
  gtk_label_set_justify (GTK_LABEL (*label), GTK_JUSTIFY_LEFT);
  gtk_box_pack_start (GTK_BOX (hbox), l, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (hbox), *label, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (self->vb_cellinfo), hbox, TRUE, TRUE, 0);

  return hbox;
}
static void create_cellinfo (CellinfoWindow *self)
{
  GtkWidget   *hbox;
  GtkWidget   *label;

  /* Location stuff */
  self->control = location_gpsd_control_get_default();
  self->device = g_object_new(LOCATION_TYPE_GPS_DEVICE, NULL);

  g_object_set(G_OBJECT(self->control),
    "preferred-method", LOCATION_METHOD_CWP,
    "preferred-interval", LOCATION_INTERVAL_DEFAULT,
    NULL);

  g_signal_connect(self->device, "changed", G_CALLBACK(cellinfo_on_location_changed), self);
  g_signal_connect(self->control, "gpsd-running", G_CALLBACK(cellinfo_on_gpsd_running), self);
  g_signal_connect(self->control, "error", G_CALLBACK(cellinfo_on_gpsd_error), self);

  g_idle_add(cellinfo_start_location, self->control);

  /* Main container */
  self->vb_cellinfo = gtk_vbox_new(TRUE, 1);

  /* CELL TYPE */
  hbox = gtk_hbox_new (TRUE, 1);
  label = gtk_label_new(_("Cell Type:"));
  self->lb_cell_type = gtk_label_new("");
  gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (hbox), self->lb_cell_type, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (self->vb_cellinfo), hbox, TRUE, TRUE, 0);


  /* CELL ID */
  self->hb_cell_id = add_cellinfo_label_entry (self, _("Cell Id:"), &self->lb_cell_id);

  /* MNC */
  hbox = gtk_hbox_new (TRUE, 1);
  label = gtk_label_new (_("MNC:"));
  self->lb_mnc = gtk_label_new("");
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
  gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0); 
  gtk_box_pack_start (GTK_BOX (hbox), self->lb_mnc, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (self->vb_cellinfo), hbox, TRUE, TRUE, 0);

  /* MCC */
  hbox = gtk_hbox_new (TRUE, 1);
  label = gtk_label_new(_("MCC:"));
  self->lb_mcc = gtk_label_new("");
  gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (hbox), self->lb_mcc, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (self->vb_cellinfo), hbox, TRUE, TRUE, 0);

  /* LAC */
  self->hb_lac = gtk_hbox_new (TRUE, 1);
  label = gtk_label_new(_("LAC:"));
  self->lb_lac = gtk_label_new("");
  gtk_box_pack_start (GTK_BOX (self->hb_lac), label, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (self->hb_lac), self->lb_lac, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (self->vb_cellinfo), self->hb_lac, TRUE, TRUE, 0);

  /* UCID */ 
  self->hb_ucid = gtk_hbox_new (TRUE, 1);
  label = gtk_label_new(_("UCID:"));
  self->lb_ucid = gtk_label_new("");
  gtk_box_pack_start (GTK_BOX (self->hb_ucid), label, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (self->hb_ucid), self->lb_ucid, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (self->vb_cellinfo), self->hb_ucid, TRUE, TRUE, 0);


  gtk_widget_show_all (self->vb_cellinfo);

  gtk_widget_hide_all (self->hb_cell_id);
  gtk_widget_hide_all (self->hb_lac);
  gtk_widget_hide_all (self->hb_ucid);

}

static void cellinfo_window_on_menu_select_sensors (GtkButton *button, gpointer data)
{
  return;
}

static void cellinfo_window_on_menu_configuration (GtkButton *button, gpointer data)
{
  //CellinfoWindow *self = CELLINFO_WINDOW (data);
  return;
}

static void cellinfo_on_location_changed(LocationGPSDevice *device, gpointer data)
{
  CellinfoWindow *self = CELLINFO_WINDOW (data);
  if (!device) {
    g_print("No device\n");
    return;
  }
  g_print("Changed! status %d\n", device->status);
  if (device->cell_info){
    if (device->cell_info->flags & LOCATION_CELL_INFO_GSM_CELL_INFO_SET){
      _gsm_cell_info ci = device->cell_info->gsm_cell_info;
      gtk_label_set_text (GTK_LABEL (self->lb_cell_type), _("GSM"));
      gtk_label_set_text (GTK_LABEL (self->lb_cell_id), g_strdup_printf ("%d",ci.cell_id));
      gtk_label_set_text (GTK_LABEL (self->lb_mnc), g_strdup_printf ("%d",ci.mnc));
      gtk_label_set_text (GTK_LABEL (self->lb_mcc), g_strdup_printf ("%d",ci.mcc));
      gtk_label_set_text (GTK_LABEL (self->lb_lac), g_strdup_printf ("%d",ci.lac));
      gtk_widget_show_all (self->hb_cell_id);
      gtk_widget_show_all (self->hb_lac);
      gtk_widget_hide_all (self->hb_ucid);
    } 
    if (device->cell_info->flags & LOCATION_CELL_INFO_WCDMA_CELL_INFO_SET){
      _wcdma_cell_info ci = device->cell_info->wcdma_cell_info;

      gtk_label_set_text (GTK_LABEL (self->lb_cell_type), _("WCDMA"));
      gtk_label_set_text (GTK_LABEL (self->lb_mnc), g_strdup_printf ("%d",ci.mnc));
      gtk_label_set_text (GTK_LABEL (self->lb_mcc), g_strdup_printf ("%d",ci.mcc));
      gtk_label_set_text (GTK_LABEL (self->lb_ucid), g_strdup_printf ("%d",ci.ucid));
      gtk_widget_hide_all (self->hb_cell_id);
      gtk_widget_hide_all (self->hb_lac);
      gtk_widget_show_all (self->hb_ucid);
    }    
  }
}


