/*
 * Don Ceferino - video game similary to Super Pang!
 * Copyright (c) 2010 Luigi Cotignano
 * web site: http://n900.altervista.org
 * 
 * This file is part of Don Ceferino Hazaa (ceferino).
 * Written by Luigi Cotignano <n900.altervista@gmail.com>
 *
 * Don Ceferino Hazaa is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Don Ceferino Hazaa is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _QUESTION_H
#define _QUESTION_H

#include <SDL/SDL.h>
#include "escena.h"
#include "grafico.h"

#define QUESTION_START_AUDIO	0
#define QUESTION_SAVE_GAME	1
#define QUESTION_RESTORE_GAME	2

#define YES_BUTTON		1
#define CANCEL_BUTTON		2
#define NO_BUTTON		3

/*!
 * \brief Un estado del juego: menu "Do you want to enable sound?"
 */
class question : public escena
{
	public:
		question(int qt);
		~question();
		int iniciar(class mundo *_pmundo, int conf_video, SDL_Surface *screen);
		void actualizar(int);
		void imprimir(void);
		void pausar(void);
	
	private:
		int get_menu_item(void);
		int tick_actual;
		SDL_Surface *screen;
		SDL_Surface *fondo;
		int question_type;
		int option_selected;
		int yes_cancel_no;
		int arrow_down;
		bool default_choice;
};	
#endif
