/*
 * Don Ceferino Hazaa - video game similary to Super Pang!
 * Copyright (c) 2004, 2005 Hugo Ruscitti
 * web site: http://www.loosersjuegos.com.ar
 * 
 * This file is part of Don Ceferino Hazaa (ceferino).
 * Written by Hugo Ruscitti <hugoruscitti@yahoo.com.ar>
 *
 * Don Ceferino Hazaa is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Don Ceferino Hazaa is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */
#ifndef _MUNDO_H
#define _MUNDO_H

#include <SDL/SDL.h>
#include "escena.h"
#include "menu.h"
#include "creditos.h"
#include "juego.h"
#include "question.h"
#include "intro.h"
#include "marcas.h"
#include "final.h"
#include "comojugar.h"
#include "audio.h"
#include "libgrafico.h"
#include "fuente2.h"
#include "common.h"

///todas las escenas gestinadas por mundo
enum {QUESTION, INTRO, MENU, JUEGO, CREDITOS, MARCAS, FINAL, COMOJUGAR, OPCIONES, SAVE_GAME, RESTORE_GAME};

/// parametros definidos por el archivo de configuracion
struct opciones_t
{
	int pantalla_completa;
	int sonido;
	int musica;
	int enable_music;
	int enable_sound;
	int modo_video;

	// Save game parameters
	int saved_lives;
	int saved_level;
	int saved_score;
	int saved_time;
	int saved_music;
	int saved_wallpaper;
};


/*!
 * \brief Mantiene todos los objetos del juego e inicia el juego
 */
class mundo
{
	public:
		mundo();
		int  iniciar(void);
		void correr(void);
		void terminar(void);
		int  cargar_opciones(void);
		int  save_options(bool flag);
		void cambiar_escena(int nueva_escena);
		void reiniciar_reloj(void);
		void eliminar(void);
		void deshabilitar_letras(void);
		void habilitar_letras(void);

		class audio audio;
		class libgrafico libgrafico;
		class fuente2 * fuente;

		void pantalla_completa (void);
		void reiniciar (void);
		struct opciones_t opciones;
		int  is_savegame_present(void);
		int  set_default_options(void);
		
	private:
		int  procesar_eventos(SDL_Event *evento);
		void intercambiar_escenas(void);
		void imprimir_cargando(void);

		int salir;
		int escena;
		int escena_anterior;
		int key_mouse_pressed;
		SDL_Surface *screen;
		class escena *actual;
		int leer_teclas;
		int question_answered;
		int question_answer;
		int savegame_present;
	
		int t, tl, tg; // tick actual, lgico y grafico
};

#endif
