/*
 * Don Ceferino - video game similary to Super Pang!
 * Copyright (c) 2010 Luigi Cotignano
 * web site: http://n900.altervista.org
 * 
 * This file is part of Don Ceferino Hazaa (ceferino).
 * Written by Luigi Cotignano <n900.altervista@gmail.com>
 *
 * Don Ceferino Hazaa is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Don Ceferino Hazaa is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */


#include <SDL/SDL.h>
#include <string.h>

#include "menu.h"
#include "mundo.h"
#include "grafico.h"
#include "utils.h"
#include "int.h"
#include "question.h"
#include "common.h"

question :: question(int qt)
{
	question_type = qt;
	tick_actual = SDL_GetTicks();
	SDL_Delay(300);
}

question :: ~question(void)
{
	SDL_FreeSurface(fondo);
}


/*!
 * \brief generate the post-intro scene
 *
 * return 0 always
 */
int question :: iniciar(class mundo *_pmundo, int _modo_video, SDL_Surface *_screen)
{
	SDL_Rect rect;
	pmundo = _pmundo;
	screen = _screen;

	if (question_type == QUESTION_START_AUDIO)
		SDL_FillRect(screen, NULL, 0);
	
	fondo = SDL_DisplayFormat(screen);

	switch (question_type)
	{
		case QUESTION_START_AUDIO:
			pmundo->fuente->myprintf(screen, SCREEN_RES_X/2, 150, NULL, NULL, false, CENTRADO, "  Do you want to enable audio?");
			break;

		case QUESTION_RESTORE_GAME:
			pmundo->fuente->myprintf(screen, SCREEN_RES_X/2, 150, NULL, NULL, false, CENTRADO, "  Do you want to restore the game?");
			break;

		case QUESTION_SAVE_GAME:
			pmundo->fuente->myprintf(screen, SCREEN_RES_X/2, 150, NULL, NULL, false, CENTRADO, "  Do you want to save the game?");
			break;
	}

	switch (question_type)
	{
		case QUESTION_START_AUDIO:
		case QUESTION_RESTORE_GAME:
			pmundo->fuente->myprintf (screen, 240, 250, NULL, NULL, true,  NINGUNO, "Yes");
			pmundo->fuente->myprintf (screen, 500, 250, NULL, NULL, false, NINGUNO, "No");
			yes_cancel_no = NO_BUTTON;
			break;

		case QUESTION_SAVE_GAME:
			yes_cancel_no = CANCEL_BUTTON;
			pmundo->fuente->myprintf (screen, 160, 250, NULL, NULL, true,  NINGUNO, "Yes");
			pmundo->fuente->myprintf (screen, 340, 250, NULL, NULL, false, NINGUNO, "Cancel");
			pmundo->fuente->myprintf (screen, 590, 250, NULL, NULL, true,  NINGUNO, "No");
			break;
	}

	SDL_Flip(screen);
	SDL_WarpMouse(1,1);
	option_selected = 0;
	arrow_down = 0;

	return 0;
}

/*!
 * \brief Return the current main menu item selected with touch-screen
 * 
 * \return UNDEFINED If no menu item has been selected
 */
int question :: get_menu_item(void)
{
	int item = TOUCH_SCREEN_NO_ITEM_SELECTED; // no item has been selected
	int x,y,i;
	static int p_item = 0;
	
	SDL_GetMouseState(&x, &y);

	switch (question_type)
	{
		case QUESTION_START_AUDIO:
		case QUESTION_RESTORE_GAME:
		{
			for (i=0; i<2; i++)
			{
				if (((x >= 200 + i*260) && (x < 360 + i*240)) && ((y >= 230) && (y < 350)))
				{
					if (SDL_GetTicks() - tick_actual > 100)
					{
						item = YES_BUTTON + i;
						tick_actual = SDL_GetTicks();
					}
					else
					{
						item = UNDEFINED;
					}
					break;
				}
			}
			break;
		}
		case QUESTION_SAVE_GAME:	
		{
			for (i=0; i<3; i++)
			{
				if (((x > (i*266)) && (x < (266 + i*266))) && ((y >= 230) && (y < 350)))
				{
					if (SDL_GetTicks() - tick_actual > 100)
					{
						item = YES_BUTTON + i;
						tick_actual = SDL_GetTicks();
//						printf("item=%d, x=%d, y=%d\n",item,x,y);
					}
					else
					{
						item = UNDEFINED;
					}
					break;
				}
			}
			break;
		}
	}

	return item;
}


/*!
 * \brief Get inputs
 */
void question :: actualizar(int key_pressed)
{
	Uint8 *tecla;
	int item;
	SDL_Rect srcrect;
	static int old_item = 0;

	tecla = SDL_GetKeyState(NULL);

	srcrect.x = 0;
	srcrect.y = 220;
	srcrect.w = SCREEN_RES_X;
	srcrect.h = 200;

	item = get_menu_item();

	switch (question_type)
	{
		case QUESTION_START_AUDIO:
		case QUESTION_RESTORE_GAME:
		{
			// The user has selected YES, so highlight it
			if (tecla[SDLK_LEFT] || (key_pressed == 'y') || (item == 1) && (yes_cancel_no != YES_BUTTON))
			{
				SDL_BlitSurface (fondo, &srcrect, screen, &srcrect);
				pmundo->fuente->myprintf (screen, 500, 250, NULL, NULL, true, NINGUNO, "No");
				pmundo->fuente->myprintf (screen, 240, 250, NULL, NULL, false, NINGUNO, "Yes");
				SDL_Flip(screen);
		
				yes_cancel_no = 1;
			}
			// The user has selected NO, so highlight it
			else if (tecla[SDLK_RIGHT] || (key_pressed == 'n') || (item == 2) && (yes_cancel_no != NO_BUTTON))
			{
				SDL_BlitSurface (fondo, &srcrect, screen, &srcrect);
				pmundo->fuente->myprintf (screen, 500, 250, NULL, NULL, false, NINGUNO, "No");
				pmundo->fuente->myprintf (screen, 240, 250, NULL, NULL, true, NINGUNO, "Yes");
				SDL_Flip(screen);

				yes_cancel_no = 3;	
			}
			
			if (tecla[SDLK_KP_ENTER] || (item > 0) || (key_pressed == 'y') || (key_pressed == 'n'))
			{
				option_selected = 1;
				return;
			}

			// YES
			if (option_selected && (yes_cancel_no == YES_BUTTON))
			{
				if (question_type == QUESTION_START_AUDIO)
				{
					pmundo->opciones.enable_music = 1;
					pmundo->opciones.enable_sound = 1;
					pmundo->audio.enable_musica();
					pmundo->audio.enable_sonido();
				}
				else if (question_type == QUESTION_RESTORE_GAME)
				{
					// Restore saved game state
					printf("Restoring savegame...\n");
					pmundo->cargar_opciones();
				}
			}
			// NO
			else if (option_selected && (yes_cancel_no == NO_BUTTON))
			{
				if (question_type == QUESTION_START_AUDIO)
				{
					pmundo->opciones.enable_music = 0;
					pmundo->opciones.enable_sound = 0;
					pmundo->audio.disable_musica();
					pmundo->audio.disable_sonido();
				}
				else if (question_type == QUESTION_RESTORE_GAME)
				{
					// Restore DEFAULT settings
					pmundo->set_default_options();
				}
			}
			else
				return;

			break;
		}
	
		case QUESTION_SAVE_GAME:
		{
			if (tecla[SDLK_LEFT] || tecla[SDLK_RIGHT])
			{
				if (tecla[SDLK_LEFT])
				{
					if (yes_cancel_no > YES_BUTTON)
						yes_cancel_no--;
					else
						return;
				}
				else if (tecla[SDLK_RIGHT])
				{
					if (yes_cancel_no < NO_BUTTON)
						yes_cancel_no++;
					else
						return;
				}

				SDL_Delay(200);
				arrow_down = 1;

				return;
			}

			// The user has selected YES, so highlight it
			if ( (key_pressed == 'y') || (arrow_down && (yes_cancel_no == YES_BUTTON)) || ((item == 1) && (yes_cancel_no != YES_BUTTON)) )
			{
				SDL_BlitSurface (fondo, &srcrect, screen, &srcrect);
				pmundo->fuente->myprintf (screen, 160, 250, NULL, NULL, false, NINGUNO, "Yes");
				pmundo->fuente->myprintf (screen, 340, 250, NULL, NULL, true,  NINGUNO, "Cancel");
				pmundo->fuente->myprintf (screen, 590, 250, NULL, NULL, true,  NINGUNO, "No");
				SDL_Flip(screen);

				yes_cancel_no = 1;
			}
			// The user has selected CANCEL, so highlight it
			else if ( (key_pressed == 'c') || (arrow_down && (yes_cancel_no == CANCEL_BUTTON)) || ((item == 2) && (yes_cancel_no != CANCEL_BUTTON)) )
			{
				SDL_BlitSurface (fondo, &srcrect, screen, &srcrect);
				pmundo->fuente->myprintf (screen, 160, 250, NULL, NULL, true,  NINGUNO, "Yes");
				pmundo->fuente->myprintf (screen, 340, 250, NULL, NULL, false, NINGUNO, "Cancel");
				pmundo->fuente->myprintf (screen, 590, 250, NULL, NULL, true,  NINGUNO, "No");
				SDL_Flip(screen);

				yes_cancel_no = 2;
			}
			// The user has selected NO, so highlight it
			else if ( (key_pressed == 'n') || (arrow_down && (yes_cancel_no == NO_BUTTON)) || ((item == 3) && (yes_cancel_no != NO_BUTTON)) )
			{
				SDL_BlitSurface (fondo, &srcrect, screen, &srcrect);
				pmundo->fuente->myprintf (screen, 160, 250, NULL, NULL, true,  NINGUNO, "Yes");
				pmundo->fuente->myprintf (screen, 340, 250, NULL, NULL, true,  NINGUNO, "Cancel");
				pmundo->fuente->myprintf (screen, 590, 250, NULL, NULL, false, NINGUNO, "No");
				SDL_Flip(screen);

				yes_cancel_no = 3;
			}

			arrow_down = 0;

			if (tecla[SDLK_KP_ENTER] || (item > 0) || (key_pressed == 'y') || (key_pressed == 'c') || (key_pressed == 'n'))
			{
				option_selected = 1;
				return;
			}

			// YES selected
			if (option_selected && (yes_cancel_no == YES_BUTTON))
			{
				// Save current game state
				pmundo->save_options(true);
				pmundo->set_default_options();
			}
			// CANCEL selected
			else if (option_selected && (yes_cancel_no == CANCEL_BUTTON))
			{
				pmundo->set_default_options();
			}
			// NO selected
			else if (option_selected && (yes_cancel_no == NO_BUTTON))
			{
				// Clear current game state
				pmundo->save_options(false);
				pmundo->set_default_options();
			}
			else
				return;

			break;
		} // End case
	} // End Switch

	pmundo->audio.play(5);

	SDL_Delay(300);

	if (option_selected)
	{
		if (question_type == QUESTION_START_AUDIO)
		{
			pmundo->cambiar_escena(INTRO);
		}
		else if (question_type == QUESTION_SAVE_GAME)
		{
			pmundo->cambiar_escena(MENU);
			pmundo->audio.play_musica(1);
		}
		else if (question_type == QUESTION_RESTORE_GAME)
		{
			pmundo->cambiar_escena(JUEGO);
		}
	}
}

void question :: imprimir(void)
{
}

void question :: pausar(void)
{
}


