/*
 * Don Ceferino Hazaa - video game similary to Super Pang!
 * Copyright (c) 2004, 2005 Hugo Ruscitti
 * web site: http://www.loosersjuegos.com.ar
 * 
 * This file is part of Don Ceferino Hazaa (ceferino).
 * Written by Hugo Ruscitti <hugoruscitti@yahoo.com.ar>
 *
 * Don Ceferino Hazaa is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Don Ceferino Hazaa is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */


#include <SDL/SDL.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>

#include "menu.h"
#include "mundo.h"
#include "grafico.h"
#include "utils.h"
#include "int.h"
#include "common.h"

marcas :: marcas(void)
{
	delay = 0;
	pausa = 0;
}


marcas :: ~marcas(void)
{
	SDL_FreeSurface(fondo);
}

/*!
 * \brief vincula el objeto creado
 */
int marcas :: iniciar(class mundo *_pmundo, int _mvideo, SDL_Surface *_screen)
{
	SDL_Rect rect;	
	
	pmundo = _pmundo;
	modo_video = _mvideo;
	screen = _screen;

	fondo = SDL_DisplayFormat(screen);

	if (fondo == NULL)
	{
		printf(_("error: Can't copy screen: '%s'\n"), SDL_GetError());
		exit(1);
	}

	cargar_marcas();

	pmundo->libgrafico.ima_menu->imprimir(0, fondo, &rect, 0, 0, 1);
	SDL_BlitSurface(fondo, NULL, screen, NULL);
	imprimir_puntajes ();
	SDL_Flip(screen);
	return 0;
}

/*!
 * \brief actualizacin lgica
 */
void marcas :: actualizar(int key_pressed)
{
	Uint8 *tecla;
	
	tecla = SDL_GetKeyState(NULL);

	if (tecla[SDLK_ESCAPE] || tecla[SDLK_SPACE] || (key_pressed == TOUCH_SCREEN_PRESSED))
	{
		pmundo->cambiar_escena(MENU);
		pmundo->audio.play(4);
	}
}

/*!
 * \brief imprime los records en pantalla
 */
void marcas :: imprimir(void)
{
}

void marcas :: imprimir_puntajes (void)
{
	int order_symbol = 109; //119

	pmundo->fuente->myprintf (screen, SCREEN_RES_X/2, 0, NULL, NULL, false, CENTRADO, "Best scores");

	if (vec_marcas[0].puntos == 0)
	{
		pmundo->fuente->myprintf(screen, SCREEN_RES_X/2, 220, NULL, NULL, false, CENTRADO, "Empty");
	}
	else
	{
		for (int i = 0; i < 7; i ++)
		{
			char puntos[5];
		
			if (vec_marcas [i].puntos != 0)
			{

				pmundo->fuente->myprintf(screen, 100, 60 + i * 50, NULL, NULL, false, NINGUNO, "%i  ", i+1);
				pmundo->fuente->imprimir_letra1(screen, order_symbol, 132, 60 + i * 50, NULL, false);
				pmundo->fuente->myprintf(screen, 190, 60 + i * 50, NULL, NULL, false, NINGUNO, "%s", vec_marcas[i].nombre);

				puntos[0] = (vec_marcas[i].puntos / 1000) % 10 +'0';
				puntos[1] = (vec_marcas[i].puntos / 100) % 10+'0';
				puntos[2] = (vec_marcas[i].puntos / 10) % 10 +'0';
				puntos[3] = (vec_marcas[i].puntos) % 10 + '0';
				puntos[4] = '\0';

				// Align score to the left
				int j = 0;
				while (puntos[0] == '0')
				{
					while (j < 4)
					{
						puntos[j] = puntos[j+1];
						j++;
						if (j == 4)
						{
							j = 0;
							break;
						}
					}
				}

				pmundo->fuente->myprintf(screen, 580, 60 + i * 50, NULL, NULL, false, NINGUNO, puntos);
			}
		}
	}	
	pmundo->fuente->myprintf (screen, SCREEN_RES_X/2, 420, NULL, NULL, false, CENTRADO, _("  Touch the screen to exit"));
}



/*!
 * \brief carga las marcas desde el archivo .ceferinomarcas
 */
void marcas :: cargar_marcas(void)
{
	FILE *fp;
	char ruta_completa[100] = {0};

#ifdef WIN32
	strcpy(ruta_completa, CEFERINO_SCORES_FILE);
#else
	strcpy(ruta_completa, getenv("HOME"));
	strcat(ruta_completa, "/");
	strcat(ruta_completa, CEFERINO_SCORES_FILE);
#endif

	fp = fopen(ruta_completa, "r+b");

	if (!fp)
	{
#ifdef DEBUG_PRINTF
		printf("Can't open the scores file named%s\n", ruta_completa);
#endif
		cargar_marcas_estandar();
		fp = fopen(ruta_completa, "r+b");
	}

	fread(vec_marcas, 7, sizeof(struct entrada), fp);
	fclose(fp);
}


void marcas :: pausar(void)
{
}
