/*
 * Don Ceferino Hazaa - video game similary to Super Pang!
 * Copyright (c) 2004, 2005 Hugo Ruscitti
 * web site: http://www.loosersjuegos.com.ar
 * 
 * This file is part of Don Ceferino Hazaa (ceferino).
 * Written by Hugo Ruscitti <hugoruscitti@yahoo.com.ar>
 *
 * Don Ceferino Hazaa is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Don Ceferino Hazaa is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */


#include <SDL/SDL.h>
#include <SDL/SDL_image.h>
#include <string.h>
#include "comojugar.h"
#include "mundo.h"
#include "grafico.h"
#include "utils.h"
#include "int.h"
#include "common.h"

comojugar :: comojugar(void)
{
	strcpy(mensaje,_("How to play"));
	
	paso = 0;
	pos = 0;
	posy_letra = 0;
	posx_letra = 0;
}

comojugar :: ~comojugar(void)
{
	SDL_FreeSurface(fondo);
}


/*!
 * \brief genera la escena como jugar
 *
 * return 1 en caso de error
 */
int comojugar :: iniciar(class mundo *_pmundo, int _modo_video, SDL_Surface *_screen)
{
	SDL_Rect rect;
	pmundo = _pmundo;
	screen = _screen;
	fondo = SDL_DisplayFormat(screen);

	pmundo->libgrafico.ima_menu->imprimir(0, fondo, &rect, 0, 0, 1);
	pmundo->libgrafico.ima_how_to_play->imprimir(0, fondo, &rect, 80, 30, 1);
	
	SDL_BlitSurface(fondo, NULL, screen, NULL);
	pmundo->fuente->myprintf (screen, 0, 0, NULL, NULL, false, CONSALTO, mensaje);
	pmundo->fuente->myprintf (screen, SCREEN_RES_X/2, 420, NULL, NULL, false, CENTRADO, _("  Touch the screen to exit"));
	SDL_Flip(screen);

	return 0;
}


/*!
 * \brief actualiza los textos que se muestran en pantalla
 */
void comojugar :: actualizar(int key_pressed)
{
	Uint8 *tecla;

	tecla = SDL_GetKeyState(NULL);

	if (tecla[SDLK_ESCAPE] || tecla[SDLK_SPACE] || (key_pressed == TOUCH_SCREEN_PRESSED))
	{
		pmundo->audio.play(4);
		pmundo->cambiar_escena(MENU);
	}
}


/*!
 * \brief impresion programada desde mundo
 */
void comojugar:: imprimir(void)
{
}


void comojugar :: pausar(void)
{
}
