/* ccchh_dooris_desktop_widget.h */

#ifndef _CCCHH_DOORIS_DESKTOP_WIDGET
#define _CCCHH_DOORIS_DESKTOP_WIDGET

#include <libhildondesktop/libhildondesktop.h>
#include <conic.h> /* libconic - Internet Connectivity library */

G_BEGIN_DECLS

#define TYPE_CCCHH_DOORIS_DESKTOP_WIDGET ccchh_dooris_desktop_widget_get_type()

#define CCCHH_DOORIS_DESKTOP_WIDGET(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CCCHH_DOORIS_DESKTOP_WIDGET, CCCHHDoorIsDesktopWidget))

#define CCCHH_DOORIS_DESKTOP_WIDGET_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CCCHH_DOORIS_DESKTOP_WIDGET, CCCHHDoorIsDesktopWidgetClass))

#define IS_CCCHH_DOORIS_DESKTOP_WIDGET(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CCCHH_DOORIS_DESKTOP_WIDGET))

#define IS_CCCHH_DOORIS_DESKTOP_WIDGET_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CCCHH_DOORIS_DESKTOP_WIDGET))

#define CCCHH_DOORIS_DESKTOP_WIDGET_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CCCHH_DOORIS_DESKTOP_WIDGET, CCCHHDoorIsDesktopWidgetClass))

typedef enum {
	DOORIS_OPEN,
	DOORIS_CLOSED,
	DOORIS_FNORD
} dooris_state_t;

typedef struct {
	// external handlers
	HDHomePluginItem parent;
	gint timeout_handler;
	ConIcConnection *connection;
	gint connection_handler;

	// internal state
	cairo_surface_t *image_current;
	gboolean force_banner;
	gboolean updating;
	gboolean connected;
	gdouble current_alpha;

	// door state information
	dooris_state_t last_state;
	dooris_state_t last_known_state;
	dooris_state_t current_state;
	gulong last_change_ts;
	gulong last_report_ts;

	// configuration settings
	guint update;
	gchar *url;
	gboolean notify;
	gboolean use_connection;
	gboolean force_connection;

	// used by the settings dialog
	GtkWidget *settings_window;
	GtkWidget *url_entry;
	GtkWidget *update_picker;
	GtkWidget *notify_button;
	GtkWidget *connection_button;
	GtkWidget *connforce_button;
} CCCHHDoorIsDesktopWidget;

typedef struct {
	HDHomePluginItemClass parent_class;
} CCCHHDoorIsDesktopWidgetClass;

GType ccchh_dooris_desktop_widget_get_type (void);

CCCHHDoorIsDesktopWidget* ccchh_dooris_desktop_widget_new (void);

// timer callback function
static gboolean
ccchh_dooris_desktop_widget_on_timeout (gpointer data);

// connection event callback function
static void
ccchh_dooris_desktop_widget_connection_event(ConIcConnection *connection,
  ConIcConnectionEvent *event, gpointer user_data);

G_END_DECLS

#endif /* _CCCHH_DOORIS_DESKTOP_WIDGET */

