/* ccchh_dooris_desktop_widget.h */

#ifndef _CCCHH_DOORIS_DESKTOP_WIDGET
#define _CCCHH_DOORIS_DESKTOP_WIDGET


#define WIDGET_NAME PACKAGE_STRING
// #define WIDGET_NAME "ccchh-dooris-widget-"PACKAGE_VERSION

// gconf base path
#define GCONF_DIR "/apps/maemo/ccchh-dooris-widget"

// default configuration
// TODO: this should be moved to turing.hamburg.ccc.de
#define DEFAULT_URL "http://dooris.koalo.de/door.txt"
//#define DEFAULT_URL "http://formularfetischisten.de/~packbart/temp/door.txt"
//#define DEFAULT_URL "http://formularfetischisten.de/~packbart/lustitsch/whale.mov"

// maximum report age in seconds
#define REPORT_TIMEOUT 7200

// async I/O timeouts in seconds
#define TIMEOUT_CONNECT 5
#define TIMEOUT_READ	30
#define TIMEOUT_CLOSE	5

// max download size in bytes
#define MAX_HTTP_SIZE 1024

// minimum/maximum selectable update interval
// in minutes
#define UPDATE_INTERVAL_MIN	5
#define UPDATE_INTERVAL_MAX	1440

// paths to icon files
#define IMAGE_DOORIS_OPEN			DATADIR"/dooris_open.png"
#define IMAGE_DOORIS_CLOSED			DATADIR"/dooris_closed.png"
#define IMAGE_DOORIS_FNORD			DATADIR"/dooris_fnord.png"
#define IMAGE_OVERLAY_DISCONNECTED	DATADIR"/dooris_notavail.png"

// widget size in pixels
#define IMAGE_WIDGET_WIDTH	102
#define IMAGE_WIDGET_HEIGHT	72

// colors & transparency
#define IMAGE_COLOR_BG			1, 1, 1
#define IMAGE_ALPHA_BG			0.0

#define IMAGE_COLOR_HIGHLIGHT	1, 1, 1
#define IMAGE_ALPHA_HIGHLIGHT	0.65

#define IMAGE_ALPHA_NORMAL		1.0
#define IMAGE_ALPHA_PROGRESS	0.65


G_BEGIN_DECLS


#include <libhildondesktop/libhildondesktop.h>
#include <conic.h> /* libconic - Internet Connectivity library */
#include <gconf/gconf-client.h>

#define TYPE_CCCHH_DOORIS_DESKTOP_WIDGET ccchh_dooris_desktop_widget_get_type()

#define CCCHH_DOORIS_DESKTOP_WIDGET(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CCCHH_DOORIS_DESKTOP_WIDGET, CCCHHDoorIsDesktopWidget))

#define CCCHH_DOORIS_DESKTOP_WIDGET_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CCCHH_DOORIS_DESKTOP_WIDGET, CCCHHDoorIsDesktopWidgetClass))

#define IS_CCCHH_DOORIS_DESKTOP_WIDGET(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CCCHH_DOORIS_DESKTOP_WIDGET))

#define IS_CCCHH_DOORIS_DESKTOP_WIDGET_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CCCHH_DOORIS_DESKTOP_WIDGET))

#define CCCHH_DOORIS_DESKTOP_WIDGET_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CCCHH_DOORIS_DESKTOP_WIDGET, CCCHHDoorIsDesktopWidgetClass))

typedef enum {
	DOORIS_OPEN,
	DOORIS_CLOSED,
	DOORIS_FNORD
} dooris_state_t;

typedef struct {
	// external handlers
	HDHomePluginItem parent;
	gint timeout_handler;
	ConIcConnection *connection;
	gint connection_handler;
	gint gvfs_timeout_handler;

	// internal state
	cairo_surface_t *image_current;
	gboolean force_banner;
	gboolean connected;
	gboolean highlighted;
	gboolean too_old;
	gchar *disconnecting_iap;
	gdouble current_alpha;
	GStaticMutex button_lock;
	GStaticMutex fetch_lock;
	GConfClient *gconf_client;

	// door state information
	dooris_state_t last_state;
	dooris_state_t last_known_state;
	dooris_state_t current_state;
	gulong last_change_ts;
	gulong last_report_ts;

	// configuration settings
	guint update_interval;
	gchar *update_url;
	gboolean notify_enabled;
	gboolean use_connection;
	gboolean force_connection;
	gboolean auto_update;

	// used by the settings dialog
	GtkWidget *settings_window;
	GtkWidget *url_entry;
	GtkWidget *update_picker;
	GtkWidget *notify_button;
	GtkWidget *connection_button;
	GtkWidget *connforce_button;

	// gvfs structures
	GnomeVFSAsyncHandle *gvfs_handle;
	gchar *gvfs_input_buffer;

} CCCHHDoorIsDesktopWidget;

typedef struct {
	HDHomePluginItemClass parent_class;
} CCCHHDoorIsDesktopWidgetClass;

GType ccchh_dooris_desktop_widget_get_type (void);

CCCHHDoorIsDesktopWidget* ccchh_dooris_desktop_widget_new (void);


// invalidate widget region, force expose event
static void
force_redraw (CCCHHDoorIsDesktopWidget *self);

// display informational banner
static void
show_status_banner (CCCHHDoorIsDesktopWidget *self);


// timer callback function
static gboolean
ccchh_dooris_desktop_widget_on_timeout (gpointer data);

// connection event callback function
static void
ccchh_dooris_desktop_widget_connection_event(ConIcConnection *connection,
	ConIcConnectionEvent *event, gpointer user_data);

// async I/O timeout callback function
static gboolean
fetch_update_cancel_cb (gpointer data);

// async I/O open callback function
static void
fetch_update_async_open_cb (GnomeVFSAsyncHandle *handle, GnomeVFSResult result,
	gpointer data);

// async I/O read callback function
static void
fetch_update_async_read_cb (GnomeVFSAsyncHandle *handle, GnomeVFSResult result,
	gpointer buffer, GnomeVFSFileSize bytes_requested, GnomeVFSFileSize bytes_read,
	gpointer data);

// async I/O close callback function
static void
fetch_update_async_close_cb (GnomeVFSAsyncHandle *handle, GnomeVFSResult result,
	gpointer data);

// update state with new data
static void
fetch_update_process (CCCHHDoorIsDesktopWidget *self, dooris_state_t new_state,
    gulong new_change_ts, gulong new_report_ts);


G_END_DECLS

#endif /* _CCCHH_DOORIS_DESKTOP_WIDGET */
