/*
 * imagecache.h - routines to abstract image caching and asynchronous image
 * loading.
 *
 * Copyright (C) 2008 Benoit Goudreault-Emond (bgoudreaultemond@gmail.com)
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef __G_IMAGE_CACHE_H__
#define __G_IMAGE_CACHE_H__

#include <glib-object.h>
#include <gdk/gdk.h>

#include "support.h"
#include "garchivereader.h"

void image_cache_load(GArchiveReader* reader);
GdkPixbuf* image_cache_request_page(int page_number,
				    gboolean is_double_page,
				    gboolean is_manga_mode,
				    double* w,
				    double* h,
				    const gchar** page_title);
int image_cache_length(void);
void image_cache_resort(void);
void image_cache_free(void);
void image_cache_dump_data(void);

#endif
