#ifndef MAINMENU_H
#define MAINMENU_H

#include <QMainWindow>
#include <QList>
#include <QProcess>
#include <QDirIterator>
#include "entry.h"

QT_BEGIN_NAMESPACE
class QWidget;
class QGridLayout;
class QAction;
class QLabel;
class QMenu;
class QScrollArea;
class QScrollBar;
class QStringList;
class QComboBox;
class QProgressDialog;
QT_END_NAMESPACE
//! [0]
class Mainmenu : public QMainWindow
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "com.nokia.catorisegui")
private slots:
    void showAbout();
    void saveMenuFile();
    void updateProgressDialog();
    void resetProgressDialog();
public slots:
    Q_SCRIPTABLE int top_application();
public:
    Mainmenu();

private:
    QWidget *widget;
    QScrollArea *scrollArea;
    QGridLayout *gLayout;
    QMenu *fileMenu;
    QAction *actSave;
    QAction *actAbout;
    QProgressDialog *progDialog;


    QStringList listCatoriseMenEntries;
    QStringList listPossibleIconDirs;
    QList<QLabel *> *listLabels;
    QList<QComboBox *> *listCBoxes;
    QList<Entry *> *listEntries;
    QProcess *proc;
    QDirIterator *it;

    QString getIconPath(QString iconName);

    void createMenu();
    void readMenuFile();
    void generateEntries();
    void readDesktopFileInformation(Entry *);
    void putEntriesToLayout();

    void getPossibleIconDirs();
    void showInformationBox(QString information);


};
//! [0]

#endif
