// case - file manager for N900
// Copyright (C) 2010 Lukas Hrazky <lukkash@email.cz>
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.


#ifndef PROGRESSBAR_H
#define PROGRESSBAR_H

#include <QProgressBar>
#include <QIcon>


class ProgressBar : public QProgressBar {
    Q_OBJECT;

public:
    explicit ProgressBar(const QPixmap &icon, const QPixmap &inverseIcon);

    QString mainText, fromText, toText;
    QPixmap bgIcon, fgIcon;
    bool paused;

public slots:
    void updateProgress(int val);
    void updateMainText(const QString &text);
    void setBottomTexts(const QString &left, const QString &right);
    void setStartTime(time_t t);
    void pause();
    void resume(time_t stallTime);
    void showRemoveNotice();

protected:
    void mouseReleaseEvent(QMouseEvent *);
    void contextMenuEvent(QContextMenuEvent *);

    bool contextEvent;

    // stamp of the last ETA recalculation - done every second
    time_t lastTimeUpdate;
    time_t startTime;
    char timeBuf[10];

signals:
    void abortOperation(ProgressBar*);
    void togglePauseOperation(ProgressBar*);
};

#endif // PROGRESSBAR_H
