// case - file manager for N900
// Copyright (C) 2010 Lukas Hrazky <lukkash@email.cz>
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.


#include "pane.h"

#include <QHeaderView>
#include <QVBoxLayout>
#include <QMessageBox>
#include <QInputDialog>
#include <QDesktopServices>
#include <QUrl>
#include <QProcess>
#include <QPainter>
#include <QEvent>


Pane::Pane(QWidget *theCase, QWidget *parent) :
    QWidget(parent),
    active(false),
    theCase(theCase),
    location(new AddressBar),
    up(new Button("go_up", 0, 70, 60)),
    fileList(new FileList)
{
    QVBoxLayout *layout = new QVBoxLayout;
    layout->setContentsMargins(2, 1, 2, 2);
    layout->setSpacing(0);
    setLayout(layout);

    QHBoxLayout *topLine = new QHBoxLayout;

    location->setText(fileList->path());

    topLine->addWidget(location);
    topLine->addWidget(up);
    layout->addLayout(topLine);
    layout->addWidget(fileList);

    connect(location, SIGNAL(pathEntered(QString)), fileList, SLOT(changePath(QString)));
    connect(up, SIGNAL(pressed()), fileList, SLOT(goUp()));
    connect(fileList, SIGNAL(pathChanged(QString)), location, SLOT(setText(QString)));

    location->installEventFilter(this);
    up->installEventFilter(this);
    // doesn't work in QT 4.6.2 - mouse events wont get through the kinetic scroller
    //fileList->installEventFilter(this);
    connect(fileList, SIGNAL(mousePressed()), this, SLOT(fileListMouseHackaround()));
}


const QString Pane::path() const {
    return fileList->path();
}


const QFileInfoList Pane::selection() const {
    return fileList->selection();
}


void Pane::paintEvent(QPaintEvent *) {
    if (active) {
        QPainter painter(this);
        painter.setPen(palette().highlight().color());
        QRect g = this->geometry();
        g.moveTo(0, 0);
        g.adjust(0, 0, -1, -1);
        painter.drawRoundedRect(g, 3, 3);
    }
}


bool Pane::eventFilter(QObject *object, QEvent *event) {
    if (!active && event->type() == QEvent::MouseButtonPress) {
        emit switchPanes();
        if (object == fileList) return true;
    }
    return false;
}


void Pane::toggleActive() {
    active = !active;
    update();
}


void Pane::toggleShowHiddenFiles() {
    fileList->toggleShowHiddenFiles();
}


void Pane::fileListMouseHackaround() {
    if (!active) {
        fileList->preventNextSelection();
        emit switchPanes();
    }
}


bool Pane::changePath(QString path) {
    location->setText(path);
    return fileList->changePath(path);
}
